/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.ApplicationFileResult;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.LayoutViewUpdateListItem;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.StageStyle;
import javafx.stage.Window;

public class ApplicationFileChooser {
    public Context mContext = null;
    public FileChooser mFileChooser = null;

    public ApplicationFileChooser(Context context) {
        this.mContext = context;
    }

    public void addFilter(String description, boolean isDefault, String ... extensions) {
        ArrayList<CallSite> formatedExtensions = new ArrayList<CallSite>();
        for (String extension : extensions) {
            formatedExtensions.add((CallSite)((Object)("*." + extension)));
        }
        FileChooser.ExtensionFilter extensionFilter = new FileChooser.ExtensionFilter(description, formatedExtensions.toArray(new String[0]));
        this.mFileChooser.getExtensionFilters().add((Object)extensionFilter);
    }

    public void close() {
    }

    public void enable() {
    }

    public void init(String title, File initialDirectory, String initialFileName, boolean showAllFiles) {
        this.init(title, initialDirectory, initialFileName, showAllFiles, StageStyle.DECORATED, 1.0);
    }

    public void init(String title, File initialDirectory, String initialFileName, boolean showAllFiles, StageStyle stageStyle, double opacity) {
        this.mFileChooser = new FileChooser();
        this.mFileChooser.setInitialDirectory(initialDirectory);
        this.mFileChooser.setInitialFileName(initialFileName);
        this.mFileChooser.getExtensionFilters().clear();
        if (showAllFiles) {
            this.mFileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("All files", new String[]{"*.*"})});
        }
    }

    public void showOpenDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mLogger.log("showSaveDialog start");
        File fileToWrite = this.mFileChooser.showOpenDialog((Window)this.mContext.mPrimaryStage);
        this.mContext.mLogger.log("showSaveDialog end");
        Platform.runLater(() -> {
            try {
                applicationFileResult.choose(fileToWrite, elConfScene, layoutViewUpdateListItem);
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        });
    }

    public void showOpenMultipleDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mLogger.log("showSaveDialog start");
        List filesToOpen = this.mFileChooser.showOpenMultipleDialog((Window)this.mContext.mPrimaryStage);
        this.mContext.mLogger.log("showSaveDialog end");
        Platform.runLater(() -> {
            try {
                if (filesToOpen != null) {
                    for (File file : filesToOpen) {
                        applicationFileResult.choose(file, elConfScene, layoutViewUpdateListItem);
                    }
                } else {
                    applicationFileResult.choose(null, elConfScene, layoutViewUpdateListItem);
                }
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        });
    }

    public void showSaveDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mLogger.log("showSaveDialog start");
        File fileToWrite = this.mFileChooser.showSaveDialog((Window)this.mContext.mPrimaryStage);
        this.mContext.mLogger.log("showSaveDialog end");
        Platform.runLater(() -> {
            try {
                applicationFileResult.choose(fileToWrite, elConfScene, layoutViewUpdateListItem);
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        });
    }
}

