/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.ApplicationFileChooser;
import com.elinchrom.software.ApplicationFileChooserSwing;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.FileDocumentElConf;
import com.elinchrom.software.FileManager;
import com.elinchrom.software.LayoutPresenterChannel;
import com.elinchrom.software.LayoutPresenterHelp;
import com.elinchrom.software.LayoutPresenterHelpLinks;
import com.elinchrom.software.LayoutPresenterHelpUpdateDetail;
import com.elinchrom.software.LayoutPresenterHelpUpdateList;
import com.elinchrom.software.LayoutPresenterMessages;
import com.elinchrom.software.LayoutPresenterScene;
import com.elinchrom.software.LayoutPresenterSceneButtons;
import com.elinchrom.software.LayoutPresenterSceneDetail;
import com.elinchrom.software.LayoutPresenterSceneEmpty;
import com.elinchrom.software.LayoutPresenterSceneHasContent;
import com.elinchrom.software.LayoutPresenterSceneList;
import com.elinchrom.software.LayoutPresenterSceneSave;
import com.elinchrom.software.LayoutPresenterSceneSaveAs;
import com.elinchrom.software.LayoutPresenterSceneSaveNew;
import com.elinchrom.software.LayoutPresenterSettings;
import com.elinchrom.software.LayoutPresenterSideMenu;
import com.elinchrom.software.LayoutPresenterUnits;
import com.elinchrom.software.LayoutPresenterUpdate;
import com.elinchrom.software.LayoutPresenterUpdateDetail;
import com.elinchrom.software.LayoutPresenterUpdateList;
import com.elinchrom.software.LayoutViewUpdateListItem;
import com.elinchrom.software.Logger;
import com.elinchrom.software.ModuleManagerApp;
import com.elinchrom.software.ModuleManagerSdk;
import com.elinchrom.software.NavigationManager;
import com.elinchrom.software.OpDispatcherCore;
import com.elinchrom.software.OpDispatcherUi;
import com.elinchrom.software.OpHandlerCore;
import com.elinchrom.software.OpHandlerUi;
import com.elinchrom.software.OpThreadCore;
import com.elinchrom.software.OpThreadUi;
import com.elinchrom.software.SortedCollection;
import com.elinchrom.software.SplashDialog;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.Util;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javafx.animation.PauseTransition;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import org.apache.commons.io.IOUtils;

public class ApplicationMain
extends Application {
    public Context mContext = null;
    public int mReadyState = 0;

    public static void main(String[] args) {
        try {
            Application.launch(ApplicationMain.class, (String[])args);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void choosePictureDialogResult(File fileToOpen, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mLayoutPresenterSceneHasContent.openPicture(elConfScene, fileToOpen);
        this.mContext.mLayoutPresenterSceneHasContent.disableDarkMask();
    }

    public void exportDialogResult(File fileToWrite, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        try {
            if (fileToWrite != null) {
                FileOutputStream outputStream = new FileOutputStream(fileToWrite);
                ((OutputStream)outputStream).write(new byte[]{69, 76, 67, 79, 78, 70});
                for (int exportId : this.mContext.mUtil.arrayAppendUnsignedOrdered(this.mContext.mStoredPreferences.elConfIds, 20)) {
                    if (exportId == 20) {
                        String elConfString = this.mContext.mGson.toJson(this.mContext.mStoredPreferences.elConfVersion0x00000014);
                        byte[] elConfBytes = this.mContext.mUtil.convertStringToUtf8Bytes(elConfString);
                        ((OutputStream)outputStream).write(this.mContext.mUtil.convertIntToByteArrayMSBFirst(20));
                        ((OutputStream)outputStream).write(this.mContext.mUtil.convertIntToByteArrayMSBFirst(elConfBytes.length));
                        ((OutputStream)outputStream).write(elConfBytes);
                        continue;
                    }
                    FileDocumentElConf fileDocumentElConf = new FileDocumentElConf(this.mContext).fromElConfId(exportId);
                    long fileSize = fileDocumentElConf.getFileSize();
                    if (fileSize >= 0xFFFFFFFFL) continue;
                    ((OutputStream)outputStream).write(this.mContext.mUtil.convertIntToByteArrayMSBFirst(exportId));
                    ((OutputStream)outputStream).write(this.mContext.mUtil.convertIntToByteArrayMSBFirst((int)fileSize));
                    InputStream inputStream = fileDocumentElConf.getInputStream();
                    IOUtils.copy(inputStream, (OutputStream)outputStream);
                    IOUtils.closeQuietly(inputStream);
                }
                IOUtils.closeQuietly(outputStream);
                this.mContext.mStoredPreferences.lastUsedElConfFile = fileToWrite.getName();
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        this.mContext.mLayoutPresenterScene.disableDarkMask();
    }

    public void importDialogResult(File fileToOpen, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        if (fileToOpen != null) {
            FileDocumentElConf fileDocumentElConf = new FileDocumentElConf(this.mContext).fromLocalFile(fileToOpen);
            if (fileDocumentElConf.parse()) {
                this.mContext.mLayoutPresenterSideMenu.displayScenes();
                this.mContext.mLayoutClickSceneListener.onTouch();
            } else {
                this.mContext.mLogger.printStackTrace("Could not parse ELCONF data.");
            }
            this.mContext.mStoredPreferences.lastUsedElConfFile = fileToOpen.getName();
            this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        }
        this.mContext.mLayoutPresenterScene.disableDarkMask();
    }

    public void init() throws Exception {
        try {
            this.initialize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void initialize() {
        Platform.setImplicitExit((boolean)false);
        this.mContext = new Context();
        this.mContext.mAppMain = this;
        this.mContext.mLogger = new Logger();
        this.mContext.mUtil = new Util(this.mContext);
        this.setUncaughtExceptionHandler();
        this.mContext.mApplicationFileChooser = this.mContext.mUtil.isWindows() ? new ApplicationFileChooserSwing(this.mContext) : new ApplicationFileChooser(this.mContext);
        this.mContext.mGson = new Gson();
        this.mContext.mColorGroup[0] = "21b894";
        this.mContext.mColorGroup[1] = "50C4C3";
        this.mContext.mColorGroup[2] = "fbb04b";
        this.mContext.mColorGroup[3] = "f05654";
        this.mContext.mColorGroup[4] = "21b894";
        this.mContext.mDayGraphicsColor = "33363B";
        this.mContext.mDayActivatedColor = "000000";
        this.mContext.mDayEnabledColor = "909090";
        this.mContext.mDayDisabledColor = "D6DADC";
        this.mContext.mNightGraphicsColor = "D6DADC";
        this.mContext.mNightActivatedColor = "FFFFFF";
        this.mContext.mNightEnabledColor = "707070";
        this.mContext.mNightDisabledColor = "33363B";
        this.mContext.mOpacityTransparent = "B8";
        this.mContext.mFontRegular = Thread.currentThread().getContextClassLoader().getResource("fonts/Muli-Regular.ttf");
        this.mContext.mFontSemibold = Thread.currentThread().getContextClassLoader().getResource("fonts/Muli-SemiBold.ttf");
        this.mContext.mFontBold = Thread.currentThread().getContextClassLoader().getResource("fonts/Muli-Bold.ttf");
        this.mContext.mFontBlack = Thread.currentThread().getContextClassLoader().getResource("fonts/Muli-Black.ttf");
        this.mContext.mFolderDebug = this.mContext.mFolderApplication = this.mContext.mUtil.getApplicationDirectory();
        this.mContext.mFolderUserApplicationData = this.mContext.mUtil.getUserApplicationDataDirectory();
        this.mContext.mFolderConfig = this.mContext.mFolderUserApplicationData + System.getProperty("file.separator") + "config" + System.getProperty("file.separator");
        this.mContext.mFolderImages = this.mContext.mFolderUserApplicationData + System.getProperty("file.separator") + "images" + System.getProperty("file.separator");
        this.mContext.mFolderPreferences = this.mContext.mFolderUserApplicationData + System.getProperty("file.separator") + "preferences" + System.getProperty("file.separator");
        this.mContext.mFolderScenes = this.mContext.mFolderUserApplicationData + System.getProperty("file.separator") + "scenes" + System.getProperty("file.separator");
        this.mContext.mFolderTemporary = this.mContext.mFolderUserApplicationData;
        this.mContext.mFileManager = new FileManager(this.mContext);
        this.mContext.mOpThreadCore = new OpThreadCore(this.mContext);
        this.mContext.mOpDispatcherCore = new OpDispatcherCore(this.mContext);
        this.mContext.mOpHandlerCore = new OpHandlerCore(this.mContext);
        this.mContext.mOpThreadUi = new OpThreadUi(this.mContext);
        this.mContext.mOpDispatcherUi = new OpDispatcherUi(this.mContext);
        this.mContext.mOpHandlerUi = new OpHandlerUi(this.mContext);
        this.mContext.mModuleManagerApp = new ModuleManagerApp(this.mContext);
        this.mContext.mModuleManagerSdk = new ModuleManagerSdk(this.mContext);
        this.mContext.mCommandIndexes.put("ELSP_CMD_AUDIO", 0);
        this.mContext.mCommandIndexes.put("ELSP_CMD_CELL_STATUS", 10);
        this.mContext.mCommandIndexes.put("ELSP_CMD_PWR_CTRL", 11);
        this.mContext.mCommandIndexes.put("ELSP_CMD_SCAN_UNIT", 19);
        this.mContext.mCommandIndexes.put("ELSP_CMD_HEAD_STATUS", 6);
        this.mContext.mCommandIndexes.put("ELSP_CMD_MOD_FSTOP", 7);
        this.mContext.mCommandIndexes.put("ELSP_CMD_MOD_PERCENTAGE", 8);
        this.mContext.mCommandIndexes.put("ELSP_CMD_FLASH_FSTOP", 3);
        this.mContext.mCommandIndexes.put("ELSP_CMD_FRIENDLY_NAME", 4);
        this.mContext.mCommandIndexes.put("ELSP_CMD_WRITE_EEPROM", 20);
        this.mContext.mCommandIndexes.put("ELSP_CMD_TRIG", 15);
        this.mContext.mCommandIndexes.put("ELSP_CMD_UNIT_INFO", 18);
        this.mContext.mCommandIndexes.put("ELSP_CMD_FLASH_COUNT", 13);
        this.mContext.mCommandIndexes.put("ELSP_CMD_GROUP", 5);
        this.mContext.mCommandIndexes.put("ELSP_CMD_CHARGE_MODE", 1);
        this.mContext.mCommandIndexes.put("ELSP_CMD_MOD_STATUS", 9);
        this.mContext.mCommandIndexes.put("ELSP_CMD_AUTOOFF_STATUS", 14);
        this.mContext.mCommandIndexes.put("ELSP_CMD_RADIO_INFO", 17);
        this.mContext.mCommandIndexes.put("ELSP_CMD_SKYPORT_STATUS", 12);
        this.mContext.mCommandIndexes.put("ELSP_CMD_OLD_UNIT_STANDBY", 16);
        this.mContext.mCommandIndexes.put("ELSP_CMD_FLASH_MODE", 2);
        this.mContext.mCommandIndexes.put("ELSP_CMD_BIOS_COMMAND", 23);
        this.mContext.mCommandIndexes.put("ELSP_CMD_ERASE_FIRMWARE", 24);
        this.mContext.mCommandIndexes.put("ELSP_CMD_READ_FW_PAGE_GENERATION_2", 27);
        this.mContext.mCommandIndexes.put("ELSP_CMD_BIOS_COMMAND_GENERATION_2", 28);
    }

    public void launchManualRefresh() {
        this.mContext.mPeriodicTarget = (byte)((this.mContext.mPeriodicTarget + 1) % 127);
        this.mContext.mModuleManagerSdk.valueSetByte(44, this.mContext.mPeriodicTarget);
    }

    public void onChangeSceneHeight(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeSceneSize((int)this.mContext.mPrimaryStage.getScene().getWidth(), (int)newValue.doubleValue());
    }

    public void onChangeSceneSize(int width, int height) {
        this.mContext.mLogger.log("Window size changed: " + width + "x" + height);
        this.mContext.mSceneWidth = width;
        this.mContext.mSceneHeight = height;
        this.mContext.mOnScreenLayoutPresenter.onChangeWindowSize(width, height);
    }

    public void onChangeSceneWidth(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeSceneSize((int)newValue.doubleValue(), (int)this.mContext.mPrimaryStage.getScene().getHeight());
    }

    public void onChangeWindowHeight(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeWindowSize(this.mContext.mStoredPreferences.windowWidth, (int)newValue.doubleValue());
    }

    public void onChangeWindowPosition(int x, int y) {
        this.mContext.mStoredPreferences.windowX = x;
        this.mContext.mStoredPreferences.windowY = y;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
    }

    public void onChangeWindowSize(int width, int height) {
        this.mContext.mStoredPreferences.windowWidth = width;
        this.mContext.mStoredPreferences.windowHeight = height;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
    }

    public void onChangeWindowWidth(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeWindowSize((int)newValue.doubleValue(), this.mContext.mStoredPreferences.windowHeight);
    }

    public void onChangeWindowX(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeWindowPosition((int)newValue.doubleValue(), this.mContext.mStoredPreferences.windowY);
    }

    public void onChangeWindowY(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
        this.onChangeWindowPosition(this.mContext.mStoredPreferences.windowX, (int)newValue.doubleValue());
    }

    public void onKeyUpdate(KeyEvent keyEvent) {
        try {
            if ((this.mContext.mLayoutPresenterUpdate.isOnScreen() || this.mContext.mLayoutPresenterUpdateList.isOnScreen() || this.mContext.mLayoutPresenterUpdateDetail.isOnScreen()) && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getCode() == KeyCode.F6) {
                this.mContext.mLayoutPresenterUpdate.onToggleSav();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onReady() {
        if (this.mReadyState == 3) {
            this.mContext.mLayoutPresenterChannel.onDetect();
        }
    }

    public void onReadyCore() {
        this.mReadyState |= 1;
        this.onReady();
    }

    public void onReadyUi() {
        this.mReadyState |= 2;
        this.onReady();
    }

    public void onUncaughtException(Thread thread, Throwable throwable) {
        final int code = throwable.hashCode() == 0 ? 51 : throwable.hashCode();
        try {
            this.mContext.mLogger.log("An uncaught error occurred in the thread " + thread.getName());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            this.mContext.mLogger.printStackTrace(throwable);
        }
        catch (Throwable t) {
            this.mContext.mLogger.log("An exception occured in print stack trace");
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10000L);
                }
                catch (Throwable t) {
                    ApplicationMain.this.mContext.mLogger.printStackTrace(t);
                }
                System.exit(code);
            }
        }.start();
        try {
            this.mContext.mUtil.isOk(Alert.AlertType.ERROR, "An error occurred", "An unexpected error occurred.", "The application will now stop.");
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        System.exit(code);
    }

    public void onWindowClose(WindowEvent t) {
        Platform.exit();
    }

    public void savSelectVersionResult(File fileToOpen, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mLayoutPresenterUpdate.onSavLoadVersion(layoutViewUpdateListItem, fileToOpen);
        this.mContext.mLayoutPresenterUpdate.disableDarkMask();
    }

    protected void setUncaughtExceptionHandler() {
        try {
            Thread.setDefaultUncaughtExceptionHandler((t, e) -> this.onUncaughtException(t, e));
        }
        catch (Throwable t2) {
            this.mContext.mLogger.printStackTrace(t2);
        }
    }

    public void showChoosePictureDialog(ElConfScene elConfScene) {
        this.mContext.mApplicationFileChooser.init("Open", new File(System.getProperty("user.home")), "", false);
        this.mContext.mApplicationFileChooser.addFilter("image file", true, "bmp", "dib", "gif", "jfi", "jfif", "jif", "jpe", "jpeg", "jpg", "png");
        this.mContext.mApplicationFileChooser.addFilter("BMP", false, "bmp");
        this.mContext.mApplicationFileChooser.addFilter("DIB", false, "dib");
        this.mContext.mApplicationFileChooser.addFilter("GIF", false, "gif");
        this.mContext.mApplicationFileChooser.addFilter("JFI", false, "jfi");
        this.mContext.mApplicationFileChooser.addFilter("JFIF", false, "jfif");
        this.mContext.mApplicationFileChooser.addFilter("JIF", false, "jif");
        this.mContext.mApplicationFileChooser.addFilter("JPE", false, "jpe");
        this.mContext.mApplicationFileChooser.addFilter("JPEG", false, "jpeg");
        this.mContext.mApplicationFileChooser.addFilter("JPG", false, "jpg");
        this.mContext.mApplicationFileChooser.addFilter("PNG", false, "png");
        this.mContext.mLogger.log("showOpenDialog start");
        this.mContext.mApplicationFileChooser.showOpenMultipleDialog(this::choosePictureDialogResult, elConfScene, null);
        this.mContext.mLogger.log("showOpenDialog end");
    }

    public void showExportDialog(String fileName) {
        this.mContext.mApplicationFileChooser.init("Save as", new File(System.getProperty("user.home")), fileName, false);
        this.mContext.mApplicationFileChooser.addFilter("Elinchrom configuration file", true, "elconf");
        this.mContext.mLogger.log("showOpenDialog start");
        this.mContext.mApplicationFileChooser.showSaveDialog(this::exportDialogResult, null, null);
        this.mContext.mLogger.log("showOpenDialog end");
    }

    public void showImportDialog(String fileName) {
        this.mContext.mApplicationFileChooser.init("Open", new File(System.getProperty("user.home")), fileName, false);
        this.mContext.mApplicationFileChooser.addFilter("Elinchrom configuration file", true, "elconf");
        this.mContext.mLogger.log("showOpenDialog start");
        this.mContext.mApplicationFileChooser.showOpenDialog(this::importDialogResult, null, null);
        this.mContext.mLogger.log("showOpenDialog end");
    }

    public void showSavSelectVersion(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mContext.mApplicationFileChooser.init("Open", new File(System.getProperty("user.home")), "", false);
        this.mContext.mApplicationFileChooser.addFilter("Elinchrom firmware file", true, "elx", "elx2");
        this.mContext.mLogger.log("showOpenDialog start");
        this.mContext.mApplicationFileChooser.showOpenDialog(this::savSelectVersionResult, null, layoutViewUpdateListItem);
        this.mContext.mLogger.log("showOpenDialog end");
    }

    public void start(Stage primaryStage) {
        try {
            this.mContext.mLogger.log(System.getProperty("os.name"));
            this.mContext.mLogger.log(System.getProperty("os.version"));
            this.mContext.mLogger.log(this.mContext.mUtil.isMacOsCatalina() ? "isMacOsCatalina" : "not isMacOsCatalina");
            this.mContext.mLogger.log(this.mContext.mUtil.isMacOsBigSur() ? "isMacOsBigSur" : "not isMacOsBigSur");
            this.mContext.mLogger.log(this.mContext.mUtil.isMacOsMonterey() ? "isMacOsMonterey" : "not isMacOsMonterey");
            this.mContext.mLogger.log(this.mContext.mUtil.isMacOsVentura() ? "isMacOsVentura" : "not isMacOsVentura");
            this.mContext.mLogger.log(this.mContext.mUtil.isMacOsSonoma() ? "isMacOsSonoma" : "not isMacOsSonoma");
            this.mContext.mApplicationFileChooser.enable();
            this.mContext.mFileManager.initFolders();
            this.mContext.mFileManager.initCheckedNameFlashUnits();
            this.mContext.mFileManager.initManuallySortedUnits();
            this.mContext.mFileManager.initPreferencesFile();
            this.mContext.mRefreshMode = (byte)this.mContext.mStoredPreferences.lastUsedAutoRefreshMode;
            this.mContext.mSortedUpdates = new SortedCollection(this.mContext, this.mContext.mStoredPreferences.sortManually == 1);
            this.mContext.mSortedBridges = new SortedCollection(this.mContext, this.mContext.mStoredPreferences.sortManually == 1);
            this.mContext.mSortedLightingDevices = new SortedCollection(this.mContext, this.mContext.mStoredPreferences.sortManually == 1);
            this.mContext.mNavigationManager = new NavigationManager(this.mContext);
            this.mContext.mPauseTransition = new PauseTransition(Duration.millis((double)750.0));
            this.mContext.mLayoutPresenterSideMenu = new LayoutPresenterSideMenu(this.mContext);
            this.mContext.mLayoutPresenterMessages = new LayoutPresenterMessages(this.mContext);
            this.mContext.mLayoutPresenterUnits = new LayoutPresenterUnits(this.mContext);
            this.mContext.mLayoutPresenterScene = new LayoutPresenterScene(this.mContext);
            this.mContext.mLayoutPresenterSceneButtons = new LayoutPresenterSceneButtons(this.mContext);
            this.mContext.mLayoutPresenterSceneEmpty = new LayoutPresenterSceneEmpty(this.mContext);
            this.mContext.mLayoutPresenterSceneSave = new LayoutPresenterSceneSave(this.mContext);
            this.mContext.mLayoutPresenterSceneSaveNew = new LayoutPresenterSceneSaveNew(this.mContext);
            this.mContext.mLayoutPresenterSceneSaveAs = new LayoutPresenterSceneSaveAs(this.mContext);
            this.mContext.mLayoutPresenterSceneHasContent = new LayoutPresenterSceneHasContent(this.mContext);
            this.mContext.mLayoutPresenterSceneList = new LayoutPresenterSceneList(this.mContext);
            this.mContext.mLayoutPresenterSceneDetail = new LayoutPresenterSceneDetail(this.mContext);
            this.mContext.mLayoutPresenterUpdate = new LayoutPresenterUpdate(this.mContext);
            this.mContext.mLayoutPresenterUpdateList = new LayoutPresenterUpdateList(this.mContext);
            this.mContext.mLayoutPresenterUpdateDetail = new LayoutPresenterUpdateDetail(this.mContext);
            this.mContext.mLayoutPresenterChannel = new LayoutPresenterChannel(this.mContext);
            this.mContext.mLayoutPresenterSettings = new LayoutPresenterSettings(this.mContext);
            this.mContext.mLayoutPresenterHelp = new LayoutPresenterHelp(this.mContext);
            this.mContext.mLayoutPresenterHelpLinks = new LayoutPresenterHelpLinks(this.mContext);
            this.mContext.mLayoutPresenterHelpUpdateList = new LayoutPresenterHelpUpdateList(this.mContext);
            this.mContext.mLayoutPresenterHelpUpdateDetail = new LayoutPresenterHelpUpdateDetail(this.mContext);
            this.mContext.mOnScreenLayoutPresenter = this.mContext.mLayoutPresenterChannel;
            this.mContext.mLayoutNodeRoot = new StackPane();
            this.mContext.mLayoutNodeRoot.getStyleClass().add((Object)"night-theme");
            this.mContext.mLayoutNodeRoot.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
            this.mContext.mLayoutNodeRoot.setPrefSize(1920.0, 1017.0);
            this.mContext.mLayoutNodeRoot.setOnKeyReleased(this::onKeyUpdate);
            this.mContext.mLayoutNodeBackground = new StackPane();
            this.mContext.mLayoutNodeRoot.getChildren().add((Object)this.mContext.mLayoutNodeBackground);
            this.mContext.mScrollView = new ScrollPane();
            this.mContext.mScrollView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
            this.mContext.mScrollView.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.mContext.mScrollView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
            this.mContext.mLayoutNodeDisplay = new GridPane();
            ColumnConstraints columnDisplaySideNavigation = new ColumnConstraints(256.0, 256.0, 256.0, Priority.NEVER, HPos.LEFT, false);
            ColumnConstraints columnDisplayMain = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.CENTER, true);
            this.mContext.mLayoutNodeDisplay.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnDisplaySideNavigation, columnDisplayMain});
            RowConstraints rowDisplay = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
            this.mContext.mLayoutNodeDisplay.getRowConstraints().addAll((Object[])new RowConstraints[]{rowDisplay});
            this.mContext.mLayoutNodeSideNavigation = new StackPane();
            this.mContext.mLayoutNodeDisplay.add((Node)this.mContext.mLayoutNodeSideNavigation, 0, 0);
            this.mContext.mLayoutNodeDisplayMain = new StackPane();
            GridPane.setFillWidth((Node)this.mContext.mLayoutNodeDisplayMain, (Boolean)true);
            GridPane.setFillHeight((Node)this.mContext.mLayoutNodeDisplayMain, (Boolean)true);
            this.mContext.mLayoutNodeDisplay.add((Node)this.mContext.mLayoutNodeDisplayMain, 1, 0);
            this.mContext.mLayoutNodeRoot.getChildren().add((Object)this.mContext.mLayoutNodeDisplay);
            Scene primaryScene = new Scene((Parent)this.mContext.mLayoutNodeRoot);
            primaryScene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/css/root.css").toExternalForm());
            primaryScene.widthProperty().addListener(this::onChangeSceneWidth);
            primaryScene.heightProperty().addListener(this::onChangeSceneHeight);
            this.mContext.mPrimaryStage = primaryStage;
            this.mContext.mPrimaryStage.setScene(primaryScene);
            this.mContext.mPrimaryStage.setTitle("Elinchrom Studio 2.0");
            this.mContext.mPrimaryStage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResource("/images/app_logo.png").toExternalForm()));
            this.mContext.mPrimaryStage.setOnCloseRequest(this::onWindowClose);
            this.mContext.mPrimaryStage.setResizable(true);
            this.mContext.mPrimaryStage.xProperty().addListener(this::onChangeWindowX);
            this.mContext.mPrimaryStage.yProperty().addListener(this::onChangeWindowY);
            this.mContext.mPrimaryStage.widthProperty().addListener(this::onChangeWindowWidth);
            this.mContext.mPrimaryStage.heightProperty().addListener(this::onChangeWindowHeight);
            if (this.mContext.mStoredPreferences.windowWidth != 0 && this.mContext.mStoredPreferences.windowHeight != 0) {
                this.mContext.mPrimaryStage.setWidth((double)this.mContext.mStoredPreferences.windowWidth);
                this.mContext.mPrimaryStage.setHeight((double)this.mContext.mStoredPreferences.windowHeight);
                this.mContext.mPrimaryStage.setX((double)this.mContext.mStoredPreferences.windowX);
                this.mContext.mPrimaryStage.setY((double)this.mContext.mStoredPreferences.windowY);
            } else {
                this.mContext.mPrimaryStage.centerOnScreen();
                this.mContext.mPrimaryStage.setMaximized(true);
            }
            if (this.mContext.mModuleManagerSdk.factory() != 0) {
                throw new Exception("Could not find the Elinchrom SDK.");
            }
            this.mContext.mModuleManagerSdk.valueSetByte(42, this.mContext.mStoredPreferences.bridgeAutoOff == 0 ? (byte)0 : 1);
            this.mContext.mModuleManagerSdk.valueSetByte(43, (byte)(this.mContext.mStoredPreferences.bridgeAutoOff & 0xFF));
            this.mContext.mOpThreadCore.init();
            this.mContext.mOpThreadUi.init();
            this.mContext.mOpThreadCore.enqueueMediumPriorityTask(new TaskInit(this.mContext, 0, 0L, 0L));
            this.mContext.mOpThreadCore.start();
            this.mContext.mSplashDialog = new SplashDialog(this.mContext);
            this.mContext.mSplashDialog.start();
            this.mContext.mApplicationFileChooser.close();
            this.mContext.mSplashDialog.show();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void stop() {
        try {
            if (this.mContext != null) {
                this.mContext.mOpThreadCore.reset();
                this.mContext.mOpThreadUi.reset();
                this.mContext.mSortedUpdates.clear();
                this.mContext.mSortedBridges.clear();
                this.mContext.mSortedLightingDevices.clear();
            }
            Thread.sleep(1500L);
            super.stop();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        System.exit(0);
    }
}

