/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.SortableComponent;
import com.elinchrom.software.Unit_Prototype_Json;

public abstract class BridgeDevice
implements SortableComponent<BridgeDevice> {
    public Context mContext = null;
    public ElinchromDevice mElinchromDevice = null;
    public long mNoAnswerTimestamp = 0L;
    public boolean mIsUnresponsive = false;
    public boolean mIsHidden = false;
    public byte mCurrentChannel = 0;
    public byte mSignalStrength = 0;
    public byte mPeriodicProgress = 0;

    public BridgeDevice(Context context, ElinchromDevice elinchromDevice) {
        this.mContext = context;
        this.mElinchromDevice = elinchromDevice;
    }

    @Override
    public int compareTo(BridgeDevice other) {
        return Integer.valueOf(this.getConnectionType()).compareTo(other.getConnectionType());
    }

    public boolean equals(Object other) {
        return other instanceof BridgeDevice && this.mElinchromDevice.mDeviceId == ((BridgeDevice)other).mElinchromDevice.mDeviceId && this.getConnectionType() == ((BridgeDevice)other).getConnectionType();
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public ElinchromDevice getElinchromDevice() {
        return this.mElinchromDevice;
    }

    protected String cleanName(String rawName) {
        Unit_Prototype_Json unit_Prototype_Json = this.mContext.mUnitPrototypes.get(this.mElinchromDevice.getProductId());
        String cleanName = rawName.replace("EL-Skyport BT", "EL-Skyport");
        cleanName = cleanName.replace("EL-Skyport Bluetooth", "EL-Skyport");
        return cleanName;
    }

    public String getBaseName() {
        return this.getName().replaceFirst("#.*", "");
    }

    public abstract int getConnectionType();

    public String getFriendlyNameString() {
        return this.getBaseName();
    }

    public String getName() {
        return this.cleanName(this.mContext.mUtil.convertUtf8BytesToString(this.mElinchromDevice.valueGet(70)));
    }

    public String getSkyportHexaId() {
        return "00";
    }

    public String getSkyportIntegerId() {
        return "0";
    }
}

