/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.JsonHelpContents;
import com.elinchrom.software.JsonHelpFirmwareUpdate;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.LayoutViewUpdateListItem;
import java.net.URL;
import java.util.Arrays;

public class ComponentUpdatable {
    public Context mContext = null;
    ElinchromDevice mElinchromDevice = null;
    LayoutViewUpdateListItem mLayoutViewUpdateListItem = null;
    public String mFirmwareVersionLatest = null;
    public int mNumberOfBoards = 0;

    public ComponentUpdatable(Context context, ElinchromDevice elinchromDevice) {
        this.mContext = context;
        this.mElinchromDevice = elinchromDevice;
        URL imageUrl = elinchromDevice.getImageUrl();
        JsonNewsFirmware jsonNewsFirmware = this.mContext.mFileDocumentFirmwareNews.getFirmwareNews(elinchromDevice.getProductName());
        this.mNumberOfBoards = jsonNewsFirmware.firmwares.length;
        this.mFirmwareVersionLatest = this.mContext.mUtil.getLatestFirmwareVersion(jsonNewsFirmware);
        for (JsonHelpFirmwareUpdate jsonHelpFirmwareUpdate : this.mContext.mFileDocumentFirmwareNews.mJsonFirmwareNews.help_firmware_update) {
            if (!Arrays.asList(jsonHelpFirmwareUpdate.product_names).contains(elinchromDevice.getProductName())) continue;
            JsonHelpContents jsonHelpContents = this.mContext.mFileDocumentFirmwareNews.getFirmwareHelpContents(jsonHelpFirmwareUpdate.help_content_id);
            this.mLayoutViewUpdateListItem = new LayoutViewUpdateListItem(this.mContext, this.mElinchromDevice, jsonHelpFirmwareUpdate, jsonNewsFirmware, jsonHelpContents, imageUrl);
            break;
        }
        if (this.mLayoutViewUpdateListItem == null) {
            this.mLayoutViewUpdateListItem = new LayoutViewUpdateListItem(this.mContext, this.mElinchromDevice, null, jsonNewsFirmware, null, imageUrl);
        }
    }

    public LayoutViewUpdateListItem getLayoutViewUpdate() {
        return this.mLayoutViewUpdateListItem;
    }
}

