/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileType;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileDocument {
    public Context mContext;
    public FileType mFileType = null;
    public boolean mIsEof = false;

    public FileDocument(Context context) {
        this.mContext = context;
    }

    public void discard() {
        this.mFileType.discard();
    }

    public void discardTemporaryData() {
        this.mFileType.discardTemporaryData();
    }

    public byte[] getAllBytes() {
        byte[] contentBytes = new byte[]{};
        try {
            contentBytes = new byte[(int)this.getFileSize()];
            DataInputStream dataInputStream = new DataInputStream(this.getInputStream());
            dataInputStream.readFully(contentBytes);
            IOUtils.closeQuietly(dataInputStream);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return contentBytes;
    }

    public File getFile() {
        return this.mFileType.getFile();
    }

    public String getFileName() {
        return this.mFileType.getFileName();
    }

    public long getFileSize() {
        return this.mFileType.getFileSize();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.mFileType.getOutputStream();
    }

    public InputStream getInputStream() throws IOException {
        return this.mFileType.getInputStream();
    }

    public boolean isEof() {
        return this.mIsEof;
    }

    public void setFileType(FileType fileType) {
        this.mFileType = fileType;
    }

    public void swapTo(String destinationPath) {
        this.mFileType.swapTo(destinationPath);
    }

    public boolean tryValidate() {
        return false;
    }
}

