/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfUnit;
import com.elinchrom.software.ElConfUnit10;
import com.elinchrom.software.ElConfVersion0x00000014;
import com.elinchrom.software.FileDocument;
import com.elinchrom.software.FileTypePrivate;
import com.elinchrom.software.Scene;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class FileDocumentElConf
extends FileDocument {
    public DataInputStream mDataInputStream;
    public long mReadSize = 0L;
    public long mFileSize = 0L;

    public FileDocumentElConf(Context context) {
        super(context);
    }

    public FileDocumentElConf fromElConfId(int elConfId) {
        this.setFileType(new FileTypePrivate(this.mContext, this.mContext.mFolderScenes + "id0x" + this.mContext.mUtil.byteArrayToHexString(this.mContext.mUtil.convertIntToByteArrayMSBFirst(elConfId)) + ".elconf"));
        return this;
    }

    public FileDocumentElConf fromLocalFile(File file) {
        this.setFileType(new FileTypePrivate(this.mContext, file));
        return this;
    }

    public FileDocumentElConf fromLocalPath(String fileName) {
        this.setFileType(new FileTypePrivate(this.mContext, fileName));
        return this;
    }

    public boolean parse() {
        boolean isValid;
        block14: {
            isValid = false;
            try {
                this.mFileSize = this.getFileSize();
                byte[] headerBytes = new byte[]{0, 0, 0, 0, 0, 0};
                this.mDataInputStream = new DataInputStream(this.getInputStream());
                this.mDataInputStream.readFully(headerBytes);
                if (this.mContext.mUtil.convertUtf8BytesToString(headerBytes).equals("ELCONF")) {
                    this.mReadSize = headerBytes.length;
                    for (int elConfId : this.mContext.mStoredPreferences.elConfIds) {
                        new FileDocumentElConf(this.mContext).fromElConfId(elConfId).discard();
                    }
                    this.mContext.mStoredPreferences.elConfIds = new int[0];
                    boolean isItemValid = true;
                    while (isItemValid) {
                        long nextItemId = this.tryGetElConfNextItemId();
                        long nextItemSize = this.tryGetElConfNextItemSize();
                        byte[] dataBytes = this.tryGetElConfNextItemDataBytes(nextItemSize);
                        if (dataBytes != null) {
                            if (nextItemId == 20L) {
                                isValid = this.parseVersion0x00000014(dataBytes);
                                continue;
                            }
                            if (nextItemId < Integer.MIN_VALUE) continue;
                            OutputStream outputStream = null;
                            try {
                                FileDocumentElConf fileDocumentElConf = new FileDocumentElConf(this.mContext).fromElConfId((int)nextItemId);
                                outputStream = fileDocumentElConf.getOutputStream();
                                outputStream.write(dataBytes);
                                this.mContext.mStoredPreferences.elConfIds = this.mContext.mUtil.arrayAppendUnsignedOrdered(this.mContext.mStoredPreferences.elConfIds, (int)nextItemId);
                            }
                            catch (Throwable t) {
                                this.mContext.mLogger.printStackTrace(t);
                            }
                            IOUtils.closeQuietly(outputStream);
                            continue;
                        }
                        isItemValid = false;
                    }
                    this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                    break block14;
                }
                if (this.parseVersion0x0000000A()) {
                    isValid = true;
                } else {
                    this.mContext.mLogger.printStackTrace("Not an ELCONF file");
                }
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        if (this.mDataInputStream != null) {
            try {
                this.mDataInputStream.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        return isValid;
    }

    public boolean parseVersion0x0000000A() {
        boolean isValid = false;
        try {
            BufferedReader br;
            ElConfUnit10[] units;
            if (this.mFileType.getFile() != null && (units = this.mContext.mGson.fromJson((Reader)(br = new BufferedReader(new FileReader(this.mFileType.getFile()))), ElConfUnit10[].class)) != null) {
                ArrayList<ElConfUnit> elConfUnit20List = new ArrayList<ElConfUnit>();
                for (ElConfUnit10 unit10 : units) {
                    int productId = this.mContext.mUtil.tryFindUniqueProductIdFromSkyportId(unit10.mSkyportIdString);
                    ElConfUnit elConfUnit20 = new ElConfUnit();
                    elConfUnit20.skyport_id = unit10.mSkyportIdString;
                    elConfUnit20.product_id = (byte)(productId & 0xFF);
                    elConfUnit20.group = unit10.group;
                    elConfUnit20.friendly_name = unit10.friendly_name;
                    elConfUnit20.flash_power = unit10.flash_power;
                    elConfUnit20.head_on = unit10.head_on;
                    elConfUnit20.lamp_power_fstop = unit10.lamp_power_fstop;
                    elConfUnit20.lamp_mode = unit10.lamp_mode;
                    elConfUnit20.lamp_timer = unit10.lamp_timer;
                    elConfUnit20.lamp_power_percentage = unit10.lamp_power_percentage;
                    elConfUnit20.flash_mode_values = unit10.flash_mode_values;
                    elConfUnit20.photocell_mode = unit10.photocell_mode;
                    elConfUnit20.charge_mode = unit10.charge_mode;
                    elConfUnit20.audio_mode = unit10.audio_mode;
                    elConfUnit20.standby_mode = (byte)(unit10.unit_standby ? 1 : 0);
                    elConfUnit20.auto_off = unit10.auto_off;
                    elConfUnit20List.add(elConfUnit20);
                }
                if (elConfUnit20List.size() > 0) {
                    Scene destinationScene = new Scene(this.mContext, this.mFileType.getFile().getName());
                    if (destinationScene.exists()) {
                        destinationScene.mElConfScene.description = "";
                        destinationScene.deleteImages();
                    } else {
                        destinationScene.create();
                    }
                    destinationScene.mElConfScene.units = elConfUnit20List.toArray(new ElConfUnit[0]);
                    this.mContext.mStoredPreferences.lastUsedScene = destinationScene.getName();
                    this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                    isValid = true;
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return isValid;
    }

    public boolean parseVersion0x00000014(byte[] dataBytes) {
        boolean isValid = false;
        try {
            ElConfVersion0x00000014 elConfVersion0x00000014;
            this.mContext.mStoredPreferences.elConfVersion0x00000014 = elConfVersion0x00000014 = this.mContext.mGson.fromJson(this.mContext.mUtil.convertUtf8BytesToString(dataBytes), ElConfVersion0x00000014.class);
            this.mContext.mStoredPreferences.lastUsedScene = elConfVersion0x00000014.scenes.length > 0 ? elConfVersion0x00000014.scenes[0].name : "";
            isValid = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return isValid;
    }

    public byte[] tryGetElConfNextItemDataBytes(long nextItemSize) {
        byte[] result = null;
        try {
            if (!this.isEof() && nextItemSize > 0L) {
                byte[] dataBytes = new byte[(int)nextItemSize];
                this.mDataInputStream.readFully(dataBytes);
                this.mReadSize += (long)dataBytes.length;
                result = dataBytes;
            }
        }
        catch (EOFException eofException) {
            this.mContext.mLogger.printStackTrace(eofException);
            this.mIsEof = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }

    public long tryGetElConfNextItemId() {
        long result = 0L;
        try {
            if (!this.isEof()) {
                byte[] idBytes = new byte[]{0, 0, 0, 0};
                this.mDataInputStream.readFully(idBytes);
                this.mReadSize += (long)idBytes.length;
                result = this.mContext.mUtil.byteArrayToLongMSBFirst(idBytes);
            }
        }
        catch (EOFException eofException) {
            this.mIsEof = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }

    public long tryGetElConfNextItemSize() {
        long result = 0L;
        try {
            if (!this.isEof()) {
                byte[] sizeBytes = new byte[]{0, 0, 0, 0};
                this.mDataInputStream.readFully(sizeBytes);
                this.mReadSize += (long)sizeBytes.length;
                long nextItemSize = this.mContext.mUtil.byteArrayToLongMSBFirst(sizeBytes);
                if (nextItemSize <= this.mFileSize - this.mReadSize) {
                    result = nextItemSize;
                } else {
                    this.mContext.mLogger.printStackTrace("Bad ELCONF item size.");
                }
            }
        }
        catch (EOFException eofException) {
            this.mContext.mLogger.printStackTrace(eofException);
            this.mIsEof = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }
}

