/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FileDocument;
import com.elinchrom.software.FileDocumentPicture;
import com.elinchrom.software.FileTypeAsset;
import com.elinchrom.software.FileTypePrivate;
import com.elinchrom.software.FileTypeUrl;
import com.elinchrom.software.JsonFirmwareNews;
import com.elinchrom.software.JsonHelpContents;
import com.elinchrom.software.JsonHelpFirmwareUpdate;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.JsonNewsFirmwareFile;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.util.Arrays;

public class FileDocumentFirmwareNews
extends FileDocument {
    public JsonFirmwareNews mJsonFirmwareNews = null;

    public FileDocumentFirmwareNews(Context context) {
        super(context);
    }

    public void downloadImages() {
        for (JsonHelpFirmwareUpdate jsonHelpFirmwareUpdate : this.mJsonFirmwareNews.help_firmware_update) {
            JsonHelpContents jsonHelpContents = this.getFirmwareHelpContents(jsonHelpFirmwareUpdate.help_content_id);
            String updateModeImageName = jsonHelpContents.update_mode_image_name;
            File localUpdateModeImage = new File(this.mContext.mFolderImages + updateModeImageName);
            if (localUpdateModeImage.exists()) continue;
            FileDocumentPicture updateModeImage = new FileDocumentPicture(this.mContext).fromResources(updateModeImageName);
            if (updateModeImage.tryValidate()) {
                updateModeImage.swapTo(this.mContext.mFolderImages + updateModeImageName);
                continue;
            }
            updateModeImage = new FileDocumentPicture(this.mContext).fromUrl("https://services.elinchrom.com/image", updateModeImageName);
            if (!updateModeImage.tryValidate()) continue;
            updateModeImage.swapTo(this.mContext.mFolderImages + updateModeImageName);
        }
    }

    public FileDocumentFirmwareNews fromLocalFolder(String fileName) {
        this.setFileType(new FileTypePrivate(this.mContext, fileName));
        return this;
    }

    public FileDocumentFirmwareNews fromResources(String fileName) {
        this.setFileType(new FileTypeAsset(this.mContext, fileName));
        return this;
    }

    public FileDocumentFirmwareNews fromUrl(String sourceUrlPath, String fileName) {
        this.setFileType(new FileTypeUrl(this.mContext, sourceUrlPath, fileName));
        return this;
    }

    public JsonNewsFirmwareFile[] getFirmwareFiles(ElinchromDevice elinchromDevice) {
        JsonNewsFirmwareFile[] firmwareFiles = new JsonNewsFirmwareFile[]{};
        Unit_Prototype_Json unitPrototypeJson = this.mContext.mUnitPrototypes.get(elinchromDevice.getProductId());
        for (JsonNewsFirmware jsonNewsFirmware : this.mJsonFirmwareNews.firmware_news) {
            if (!Arrays.asList(jsonNewsFirmware.product_names).contains(unitPrototypeJson.Model_full_name)) continue;
            firmwareFiles = jsonNewsFirmware.firmwares;
            break;
        }
        return firmwareFiles;
    }

    public JsonNewsFirmware getFirmwareNews(String productName) {
        JsonNewsFirmware result = null;
        for (JsonNewsFirmware jsonNewsFirmware : this.mJsonFirmwareNews.firmware_news) {
            if (!Arrays.asList(jsonNewsFirmware.product_names).contains(productName)) continue;
            result = jsonNewsFirmware;
            break;
        }
        return result;
    }

    public JsonHelpContents getFirmwareHelpContents(String helpContentId) {
        JsonHelpContents result = null;
        for (JsonHelpContents jsonHelpContents : this.mJsonFirmwareNews.help_contents) {
            if (!jsonHelpContents.help_content_id.equals(helpContentId)) continue;
            result = jsonHelpContents;
            break;
        }
        return result;
    }

    public void getFirmwareHelpItems() {
    }

    public void getFirmwareHelpContents() {
    }

    @Override
    public boolean tryValidate() {
        boolean isValid = false;
        try {
            String json_data = this.mContext.mUtil.convertUtf8BytesToString(this.mFileType.getAllBytes());
            this.mJsonFirmwareNews = this.mContext.mGson.fromJson(json_data, JsonFirmwareNews.class);
            isValid = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return isValid;
    }
}

