/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileDocument;
import com.elinchrom.software.FileDocumentPicture;
import com.elinchrom.software.FileTypeAsset;
import com.elinchrom.software.FileTypePrivate;
import com.elinchrom.software.FileTypeUrl;
import com.elinchrom.software.JsonNewsFirmwareConnectionType;
import com.elinchrom.software.JsonSkyportUnits;
import com.elinchrom.software.Skyport_Command;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class FileDocumentSkyportUnits
extends FileDocument {
    public HashMap<Integer, Unit_Prototype_Json> mUnitPrototypes = new HashMap();
    public HashMap<String, Skyport_Command> mSkyportCommands = new HashMap();

    public FileDocumentSkyportUnits(Context context) {
        super(context);
    }

    public void downloadImages() {
        for (Unit_Prototype_Json unitPrototype : this.mUnitPrototypes.values()) {
            String imageName = unitPrototype.getImage_URL();
            File imageFile = new File(this.mContext.mFolderImages + imageName);
            if (imageFile.exists()) continue;
            FileDocumentPicture unitsPicture = new FileDocumentPicture(this.mContext).fromResources(imageName);
            if (unitsPicture.tryValidate()) {
                unitsPicture.swapTo(this.mContext.mFolderImages + imageName);
                continue;
            }
            unitsPicture = new FileDocumentPicture(this.mContext).fromUrl("https://services.elinchrom.com/image", imageName);
            if (!unitsPicture.tryValidate()) continue;
            unitsPicture.swapTo(this.mContext.mFolderImages + imageName);
        }
    }

    public FileDocumentSkyportUnits fromLocalFolder(String fileName) {
        this.setFileType(new FileTypePrivate(this.mContext, fileName));
        return this;
    }

    public FileDocumentSkyportUnits fromResources(String fileName) {
        this.setFileType(new FileTypeAsset(this.mContext, fileName));
        return this;
    }

    public FileDocumentSkyportUnits fromUrl(String sourceUrlPath, String fileName) {
        this.setFileType(new FileTypeUrl(this.mContext, sourceUrlPath, fileName));
        return this;
    }

    public int getFirmwareUpdteConnectionType(String productName) {
        Object url = null;
        int connectionType = 0;
        for (Unit_Prototype_Json unitPrototypeJson : this.mUnitPrototypes.values()) {
            if (!unitPrototypeJson.Model_full_name.equals(productName)) continue;
            for (Unit_Prototype_Json.Versioned_skyport_commands versionedSkyportCommands : unitPrototypeJson.Versioned_bootloader) {
                block12: for (JsonNewsFirmwareConnectionType jsonNewsFirmwareConnectionType : versionedSkyportCommands.Update_by) {
                    switch (jsonNewsFirmwareConnectionType.Connection) {
                        case "USB": {
                            connectionType = 1;
                            continue block12;
                        }
                        case "BLE": {
                            connectionType = 2;
                            continue block12;
                        }
                        case "SKYPORT": {
                            connectionType = 3;
                        }
                    }
                }
            }
        }
        return connectionType;
    }

    public URL getProductImage(String productName) {
        URL url = null;
        for (Unit_Prototype_Json unitPrototypeJson : this.mUnitPrototypes.values()) {
            if (!unitPrototypeJson.Model_full_name.equals(productName)) continue;
            try {
                url = new File(this.mContext.mFolderImages + unitPrototypeJson.Image_URL).toURI().toURL();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
            break;
        }
        return url;
    }

    @Override
    public boolean tryValidate() {
        boolean isValid = false;
        try {
            String json_data = this.mContext.mUtil.getJson(this.mFileType);
            JsonSkyportUnits obj = this.mContext.mGson.fromJson(json_data, JsonSkyportUnits.class);
            ArrayList<Unit_Prototype_Json> aux_unit_prototypes = new ArrayList<Unit_Prototype_Json>(Arrays.asList(obj.units_info));
            for (int i = 0; i < aux_unit_prototypes.size(); ++i) {
                Unit_Prototype_Json currentPrototype = aux_unit_prototypes.get(i);
                this.mUnitPrototypes.put(currentPrototype.getProduct_id(), currentPrototype);
            }
            ArrayList<Skyport_Command> aux_skyport_commands = new ArrayList<Skyport_Command>(Arrays.asList(obj.skyport_protocol));
            for (int i = 0; i < aux_skyport_commands.size(); ++i) {
                Skyport_Command currentCommand = aux_skyport_commands.get(i);
                currentCommand.setCmd_id_byte(this.mContext.mUtil);
                this.mSkyportCommands.put(currentCommand.getCmd_name(), currentCommand);
            }
            isValid = true;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return isValid;
    }
}

