/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileDocument;
import com.elinchrom.software.FileTypeAsset;
import com.elinchrom.software.FileTypePrivate;
import com.elinchrom.software.FileTypeUrl;
import com.elinchrom.software.JsonNewsSoftware;
import com.elinchrom.software.JsonSoftwareNews;

public class FileDocumentSoftwareNews
extends FileDocument {
    public JsonNewsSoftware mJsonNewsSoftware = null;

    public FileDocumentSoftwareNews(Context context) {
        super(context);
    }

    public FileDocumentSoftwareNews fromLocalFolder(String fileName) {
        this.setFileType(new FileTypePrivate(this.mContext, fileName));
        return this;
    }

    public FileDocumentSoftwareNews fromResources(String fileName) {
        this.setFileType(new FileTypeAsset(this.mContext, fileName));
        return this;
    }

    public FileDocumentSoftwareNews fromUrl(String sourceUrlPath, String fileName) {
        this.setFileType(new FileTypeUrl(this.mContext, sourceUrlPath, fileName));
        return this;
    }

    public boolean shouldDownloadNewSoftware() {
        return this.mJsonNewsSoftware != null && this.mContext.mUtil.isLowerThan("2.0.1317", this.mJsonNewsSoftware.software_version);
    }

    @Override
    public boolean tryValidate() {
        boolean isValid = false;
        try {
            String softwareName = "Elinchrom Studio for " + (this.mContext.mUtil.isWindows() ? "Windows" : "macOS");
            String json_data = this.mContext.mUtil.convertUtf8BytesToString(this.mFileType.getAllBytes());
            JsonSoftwareNews jsonSoftwareNews = this.mContext.mGson.fromJson(json_data, JsonSoftwareNews.class);
            for (JsonNewsSoftware jsonNewsSoftware : jsonSoftwareNews.software_news) {
                if (!jsonNewsSoftware.software_name.equals(softwareName)) continue;
                this.mJsonNewsSoftware = jsonNewsSoftware;
            }
            isValid = this.mJsonNewsSoftware != null;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return isValid;
    }
}

