/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class FileTypeAsset
extends FileType {
    public String mAssetFileName = null;
    public File mTemporaryFile = null;

    public FileTypeAsset(Context context, String assetFileName) {
        super(context);
        this.mAssetFileName = assetFileName;
    }

    @Override
    public long getFileSize() {
        long result = 0L;
        try {
            result = this.initTemporaryFile().length();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.initTemporaryFile());
    }

    protected File initTemporaryFile() throws IOException {
        InputStream inputStream = null;
        if (this.mTemporaryFile == null) {
            inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("elinchrom/" + this.mAssetFileName);
        }
        if (inputStream != null) {
            File temporaryFile = new File(this.mContext.mFolderTemporary + this.mAssetFileName + ".tmp");
            FileOutputStream fileOutputStream = new FileOutputStream(temporaryFile);
            IOUtils.copy(inputStream, (OutputStream)fileOutputStream);
            IOUtils.closeQuietly(fileOutputStream);
            IOUtils.closeQuietly(inputStream);
            this.mTemporaryFile = temporaryFile;
        }
        return this.mTemporaryFile;
    }

    @Override
    public boolean isValid() {
        try {
            this.initTemporaryFile();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return this.mTemporaryFile != null;
    }

    @Override
    public void swapTo(String destinationPath) {
        try {
            File destinationFile = new File(destinationPath);
            File temporaryFile = this.initTemporaryFile();
            destinationFile.delete();
            temporaryFile.renameTo(destinationFile);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }
}

