/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FileType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class FileTypeUrl
extends FileType {
    public URL mUrl = null;
    public String mFileName = null;
    public File mTemporaryFile = null;

    public FileTypeUrl(Context context, String urlPath, String fileName) {
        super(context);
        this.mFileName = fileName;
        try {
            URL url = new URL(urlPath + "/" + fileName);
            URI uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
            this.mUrl = uri.toURL();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void discardTemporaryData() {
        this.mTemporaryFile.delete();
    }

    @Override
    public long getFileSize() {
        long result = 0L;
        try {
            result = this.initTemporaryFile().length();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return result;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this.initTemporaryFile());
    }

    protected File initTemporaryFile() throws IOException {
        if (this.mTemporaryFile == null) {
            File temporaryFile = new File(this.mContext.mFolderTemporary + this.mFileName + ".tmp");
            FileUtils.copyURLToFile(this.mUrl, temporaryFile);
            this.mTemporaryFile = temporaryFile;
        }
        return this.mTemporaryFile;
    }

    @Override
    public boolean isValid() {
        try {
            this.initTemporaryFile();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return this.mTemporaryFile != null;
    }

    @Override
    public void swapTo(String destinationPath) {
        try {
            File destinationFile = new File(destinationPath);
            File temporaryFile = this.initTemporaryFile();
            destinationFile.delete();
            temporaryFile.renameTo(destinationFile);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }
}

