/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

public class FirmwareVersion {
    private final int _master;
    private final int _slave;
    private final int _ordinal;
    public int[] mBootloaderMajor = new int[]{0, 0};
    public int[] mBootloaderMinor = new int[]{0, 0};
    public int[] mFirmwareMajor = new int[]{0, 0};
    public int[] mFirmwareMinor = new int[]{0, 0};

    public FirmwareVersion(byte board_0_major, byte board_0_minor, byte board_1_major, byte board_1_minor) {
        this._master = (board_0_major & 0xFF) * 10 + board_0_minor & 0xFF;
        this._slave = (board_1_major & 0xFF) * 10 + board_1_minor & 0xFF;
        this.mFirmwareMajor[0] = this._master == 255 ? (byte)0 : board_0_major;
        this.mFirmwareMinor[0] = this._master == 255 ? (byte)0 : board_0_minor;
        this.mFirmwareMajor[1] = this._slave == 255 ? (byte)0 : board_0_minor;
        this.mFirmwareMinor[1] = this._slave == 255 ? (byte)0 : board_1_minor;
        this._ordinal = this.mFirmwareMajor[0] * 1000 + this.mFirmwareMinor[0];
    }

    public FirmwareVersion(byte master, byte slave) {
        this._master = master & 0xFF;
        this._slave = slave & 0xFF;
        this.mFirmwareMajor[0] = this._master == 255 ? 0 : (int)((float)master / 10.0f);
        this.mFirmwareMinor[0] = this._master == 255 ? 0 : master % 10;
        this.mFirmwareMajor[1] = this._slave == 255 ? 0 : (int)((float)slave / 10.0f);
        this.mFirmwareMinor[1] = this._slave == 255 ? 0 : slave % 10;
        this._ordinal = this.mFirmwareMajor[0] * 1000 + this.mFirmwareMinor[0];
    }

    public FirmwareVersion(byte version) {
        this(version, 0);
    }

    public FirmwareVersion(String version) {
        if (version.matches("\\d*\\.\\d*")) {
            String[] m_s = version.split("\\.");
            this._master = Integer.parseInt(m_s[0]);
            this._slave = Integer.parseInt(m_s[1]);
            this._ordinal = Integer.parseInt(m_s[0]) * 1000 + Integer.parseInt(m_s[1]);
        } else {
            this._master = 0;
            this._slave = 0;
            this._ordinal = 0;
        }
    }

    public boolean isBefore(FirmwareVersion another) {
        return this._ordinal < another._ordinal;
    }

    public boolean isAfter(FirmwareVersion another) {
        return this._ordinal > another._ordinal;
    }

    public byte getSlave() {
        return (byte)this._slave;
    }

    public byte getMaster() {
        return (byte)this._master;
    }

    public String getString() {
        if (this.mFirmwareMajor[1] > 0 && this._slave != 255) {
            return "" + this.mFirmwareMajor[0] + this.mFirmwareMinor[0] + "." + this.mFirmwareMajor[1] + this.mFirmwareMinor[1];
        }
        if (this._master != 255) {
            return this.mFirmwareMajor[0] + "." + this.mFirmwareMinor[0];
        }
        return "0.0";
    }
}

