/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnitCategoryContinuousLight;

public class FlashDeviceContinuousLight
extends FlashDevice {
    public FlashDeviceContinuousLight(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
        this.mFeatureList[5] = 4;
        this.mFeatureList[6] = 0;
        this.mFeatureList[7] = 0;
        this.mFeatureList[9] = 0;
        this.mFeatureList[10] = 0;
        this.mFeatureList[12] = 0;
        this.mPowerTitle = "Video light";
        this.mLampTitle = "Power";
        this.mLayoutViewUnit = new LayoutViewUnitCategoryContinuousLight(context, this.mElinchromDevice);
    }

    @Override
    public byte[] getCheckedLampPowerValuesA(int lampAPower) {
        int roundedLampPowerA = (int)Math.round((double)lampAPower / 100.0);
        return this.checkPowerBoundsModLamp(roundedLampPowerA, 0);
    }

    @Override
    public byte[] getCheckedLampPowerValuesForFreeMode(int lampPowerIncrement) {
        byte lampPowerValue = (byte)Math.ceil((double)this.getLamp_power_percentage() / 100.0 * (double)this.getMax_lamp_power() + (double)lampPowerIncrement);
        return this.checkPowerBoundsModLamp(lampPowerValue, 0);
    }

    @Override
    public byte[] getCheckedLampPowerValuesForPropMode() {
        return this.getCheckedLampPowerValuesForFreeMode(0);
    }

    @Override
    public void setLampPowerValues(byte[] lampPowerValues) {
        float lampPowerPercent = (float)lampPowerValues[0] / (float)this.getMax_lamp_power() * 100.0f;
        byte checkedLampPowerPercent = this.checkPowerBoundsContinuousLightPercent((byte)lampPowerPercent);
        this.setLamp_power_percentage(checkedLampPowerPercent);
    }

    @Override
    public int getLampPowerMinusA() {
        int minusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getContinuousLightLampPower(), this.getMax_lamp_power()));
            minusLampPower = lampPower - this.getMin_lamp_power();
        }
        return minusLampPower;
    }

    @Override
    public int getLampPowerMinusB() {
        return 0;
    }

    @Override
    public int getLampPowerPlusA() {
        int plusLampPower = 0;
        if (this.isHeadAOn()) {
            int lampPower = Math.max(this.getMin_lamp_power(), Math.min(this.getContinuousLightLampPower(), this.getMax_lamp_power()));
            plusLampPower = this.getMax_lamp_power() - lampPower;
        }
        return plusLampPower;
    }

    @Override
    public int getLampPowerPlusB() {
        return 0;
    }

    @Override
    public boolean isSelectedPower(boolean nothingSelected) {
        return false;
    }

    @Override
    public boolean isHeadAOn() {
        return true;
    }

    @Override
    public boolean isHeadBOn() {
        return false;
    }
}

