/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnitCategoryPowerPack;

public class FlashDevicePowerPack
extends FlashDevice {
    public FlashDevicePowerPack(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
        this.mFeatureList[0] = 0;
        this.mFeatureList[1] = 1;
        this.mFeatureList[6] = 1;
        this.mFeatureList[13] = 0;
        if (this.mElinchromDevice.getProductId() == 14 || this.mElinchromDevice.getProductId() == 12 || this.mElinchromDevice.getProductId() == 13) {
            this.mFeatureList[4] = 1;
        } else {
            this.mFeatureList[4] = 0;
            this.mFeatureList[5] = 3;
        }
        this.mPowerTitle = "Total power";
        this.mRecyclingModeLabels = new String[]{"Eco", "Fast"};
        this.mRecyclingModePosition = new int[]{1, 0, 1, 1};
        this.mRecyclingModeValues = new byte[]{1, 0};
        this.mLayoutViewUnit = new LayoutViewUnitCategoryPowerPack(context, this.mElinchromDevice);
    }

    @Override
    public boolean areAllHeadsOn() {
        return this.getHead_on() == 3;
    }

    @Override
    public byte[] getClippedFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsMain(flashPowerValues);
    }

    @Override
    public byte[] getClippedLampPowerValuesFromFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsModLamp(flashPowerValues[0], flashPowerValues[0]);
    }

    @Override
    public byte[] getFlash_power_values() {
        return this.computeHeadsValues(this.readNative(3)[0]);
    }

    @Override
    public byte getHead_on() {
        if (this.mElinchromDevice.getProductId() == 14 || this.mElinchromDevice.getProductId() == 12 || this.mElinchromDevice.getProductId() == 13) {
            return super.getHead_on();
        }
        return 3;
    }

    @Override
    public byte getHead_plugged() {
        if (this.mElinchromDevice.getProductId() == 14 || this.mElinchromDevice.getProductId() == 12 || this.mElinchromDevice.getProductId() == 13) {
            return super.getHead_plugged();
        }
        return 3;
    }

    @Override
    public byte getHeads_ratio() {
        if (this.mElinchromDevice.getProductId() == 17 || this.mElinchromDevice.getProductId() == 19) {
            return 2;
        }
        return 1;
    }

    @Override
    public byte getMaxFlashPowerHeadA() {
        return this.isHeadBOn() ? (byte)65 : 75;
    }

    @Override
    public byte getMaxFlashPowerHeadB() {
        return this.isHeadAOn() ? (byte)65 : 75;
    }

    @Override
    public byte getMinFlashPowerHeadA() {
        return this.isHeadBOn() ? (byte)15 : 25;
    }

    @Override
    public byte getMinFlashPowerHeadB() {
        return this.isHeadAOn() ? (byte)15 : 25;
    }

    @Override
    public void setLamp_power_fstop(byte lamp_a_fstop, byte lamp_b_fstop) {
        if ((this.getHead_on() & 3) == 2) {
            this.sendNative(7, new byte[]{lamp_b_fstop, lamp_b_fstop});
        } else {
            this.sendNative(7, new byte[]{lamp_a_fstop, lamp_b_fstop});
        }
    }
}

