/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutViewUnitCategorySingleRatio;

public class FlashDeviceSingleRatio
extends FlashDevice {
    public FlashDeviceSingleRatio(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
        this.mFeatureList[1] = 1;
        this.mFeatureList[5] = 2;
        this.mFeatureList[7] = 0;
        this.mFeatureList[8] = 1;
        if (this.mElinchromDevice.getProductId() == 56) {
            this.mFeatureList[11] = 1;
            this.mFlashesPerSecondLabels = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};
            this.mFlashesPerSecondValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8};
            this.mFlashesPerSecondPosition = new int[]{0, 0, 1, 2, 3, 4, 5, 6, 7};
        }
        this.mPowerTitle = "Total power";
        this.mRecyclingModeLabels = new String[]{"Eco", "Fast"};
        this.mRecyclingModePosition = new int[]{1, 0, 1, 1};
        this.mRecyclingModeValues = new byte[]{1, 0};
        this.mLayoutViewUnit = new LayoutViewUnitCategorySingleRatio(context, this.mElinchromDevice);
    }

    @Override
    public boolean areAllHeadsOn() {
        return this.getHead_on() == 3;
    }

    @Override
    public byte[] getClippedFlashPowerValues(int[] flashPowerValues) {
        return this.checkPowerBoundsMain(flashPowerValues);
    }

    @Override
    public byte[] getFlash_power_values() {
        return this.computeHeadsValues(this.readNative(3)[0]);
    }

    @Override
    public byte getHead_on() {
        return this.readNative(6)[1];
    }

    @Override
    public byte getMaxFlashPowerHeadA() {
        return this.isHeadBOn() ? (byte)(this.getMax_flash_power() - 6) : this.getMax_flash_power();
    }

    @Override
    public byte getMaxFlashPowerHeadB() {
        return (byte)(this.getMax_flash_power() - 16);
    }

    @Override
    public byte getMaxFlashPowerMain() {
        return !this.isHeadAOn() && this.isHeadBOn() ? (byte)(this.getMax_flash_power() - 16) : this.getMax_flash_power();
    }

    @Override
    public byte getMinFlashPowerHeadA() {
        return (byte)(this.getMin_flash_power() + 10);
    }

    @Override
    public byte getMinFlashPowerMain() {
        return !this.isHeadAOn() && this.isHeadBOn() ? this.getMin_flash_power() : (byte)(this.getMin_flash_power() + 16);
    }

    @Override
    public void setFlash_power_values(byte[] flash_power) {
        this.setFlash_power(flash_power[0], (byte)0, (byte)0);
    }

    @Override
    public void setLamp_mode_mode(int lamp_mode_mode) {
        if (this.mElinchromDevice.getProductId() == 56 || this.mElinchromDevice.getProductId() == 21 || this.mElinchromDevice.getProductId() == 22) {
            byte lampMode = this.getLamp_mode();
            if (lamp_mode_mode == 0) {
                this.setLamp_mode((byte)(lampMode & 0x7E));
            } else {
                this.setLamp_mode((byte)(lampMode & 0x70 | 0xD));
            }
        } else {
            super.setLamp_mode_mode(lamp_mode_mode);
        }
    }
}

