/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.GestureHandler;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.util.Duration;

public class GestureHandlerLongPress
extends GestureHandler {
    public boolean mIsLongPress = false;
    public EventHandler<MouseEvent> mOnLongPress;

    public GestureHandlerLongPress(Context context, LayoutWidgetIcon button, EventHandler<MouseEvent> onClick, EventHandler<MouseEvent> onLongPress) {
        super(context, button, onClick);
        this.mOnLongPress = onLongPress;
    }

    @Override
    public void handle(MouseEvent mouseEvent) {
        try {
            switch (mouseEvent.getEventType().getName()) {
                case "MOUSE_PRESSED": {
                    this.mButton.onPressed(true);
                    this.mContext.mPauseTransition.setOnFinished(actionEvent -> {
                        try {
                            this.mOnLongPress.handle((Event)mouseEvent);
                            this.mIsLongPress = true;
                            Platform.runLater(this::waitForLongPress);
                        }
                        catch (Throwable exception) {
                            this.mContext.mLogger.printStackTrace(exception);
                        }
                    });
                    this.waitForLongPress();
                    break;
                }
                case "MOUSE_CLICKED": {
                    this.mContext.mPauseTransition.stop();
                    this.mButton.onPressed(false);
                    if (!this.mIsLongPress) {
                        this.mOnClick.handle((Event)mouseEvent);
                    }
                    this.mIsLongPress = false;
                    break;
                }
                case "MOUSE_EXITED": {
                    this.mContext.mPauseTransition.stop();
                    this.mButton.onPressed(false);
                    this.mIsLongPress = false;
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void waitForLongPress() {
        try {
            this.mContext.mPauseTransition.playFrom(Duration.ZERO);
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }
}

