/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.UnitView;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;

public abstract class LayoutPresenter {
    public Context mContext;
    protected LayoutView mLayoutView = null;
    public Pane mDarkMask = null;

    public LayoutPresenter(Context context) {
        this.mContext = context;
        this.mDarkMask = new Pane();
        this.mDarkMask.setStyle("-fx-background-color: rgba(0, 0, 0, 0.72);");
        StackPane.setMargin((Node)this.mDarkMask, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
    }

    public void agree() {
        this.mContext.mStoredPreferences.shareData = 1;
        this.mContext.mStoredPreferences.needRefreshSharing = 1;
        this.mContext.mStoredPreferences.showAgreementMessage = 0;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mUtil.initSharing();
    }

    public void close(int state, int arg) {
        switch (state) {
            case 2: {
                Platform.exit();
                break;
            }
            case 4: {
                if (this.mContext.mStoredPreferences.showAutoRefreshOffMessage == arg) break;
                this.mContext.mStoredPreferences.showAutoRefreshOffMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 5: {
                if (this.mContext.mStoredPreferences.showAutoRefreshOnMessage == arg) break;
                this.mContext.mStoredPreferences.showAutoRefreshOnMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 7: {
                if (this.mContext.mStoredPreferences.showLoadSceneMessage == arg) break;
                this.mContext.mStoredPreferences.showLoadSceneMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 9: 
            case 10: {
                if (this.mContext.mStoredPreferences.showReplaceSceneMessage == arg) break;
                this.mContext.mStoredPreferences.showReplaceSceneMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 11: {
                if (this.mContext.mStoredPreferences.showDeleteSceneMessage == arg) break;
                this.mContext.mStoredPreferences.showDeleteSceneMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 12: {
                if (this.mContext.mStoredPreferences.showRemoveSceneImageMessage == arg) break;
                this.mContext.mStoredPreferences.showRemoveSceneImageMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 13: {
                if (this.mContext.mStoredPreferences.showFirmwareUpdateMessage == arg) break;
                this.mContext.mStoredPreferences.showFirmwareUpdateMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 14: {
                if (this.mContext.mStoredPreferences.showFindUnitsMessage == arg) break;
                this.mContext.mStoredPreferences.showFindUnitsMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
            case 15: {
                if (this.mContext.mStoredPreferences.showAccessTransmitterProMessage == arg) break;
                this.mContext.mStoredPreferences.showAccessTransmitterProMessage = arg;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                break;
            }
        }
    }

    public void disableDarkMask() {
        if (this.mContext.mLayoutNodeDisplayMain.getChildren().size() > 1) {
            this.mContext.mLayoutNodeDisplayMain.getChildren().remove(1);
        }
        this.mContext.mLayoutPresenterSideMenu.disableDarkMask();
    }

    public void disagree() {
        this.mContext.mStoredPreferences.shareData = 0;
        this.mContext.mStoredPreferences.needRefreshSharing = 1;
        this.mContext.mStoredPreferences.showAgreementMessage = 0;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mUtil.initSharing();
    }

    protected void displayLampMode(FlashDevice flashUnit, int lampMode) {
        this.getUnitView(flashUnit).displayLampMode(lampMode);
        this.getUnitView(flashUnit).displayLampPower(switch (lampMode) {
            case 0 -> new byte[]{0, 0};
            case 2 -> flashUnit.getCheckedLampPowerValuesForPropMode();
            default -> flashUnit.getCheckedLampPowerValuesForFreeMode(0);
        });
    }

    public void enableDarkMask() {
        this.disableDarkMask();
        this.mContext.mLayoutNodeDisplayMain.getChildren().add(1, (Object)this.mDarkMask);
        this.mContext.mLayoutPresenterSideMenu.enableDarkMask();
    }

    public void enableModLampFreeIfNeeded(FlashDevice flashUnit) {
        if ((flashUnit.getLamp_mode() & 0xF) != 3) {
            this.displayLampMode(flashUnit, 3);
            flashUnit.setLamp_mode_mode(3);
        }
    }

    public LayoutView getLayoutView() {
        return this.mLayoutView;
    }

    public UnitView getUnitView(FlashDevice flashUnit) {
        return null;
    }

    public boolean isOnScreen() {
        return this.equals(this.mContext.mOnScreenLayoutPresenter);
    }

    public void onBackPressed() {
    }

    public void onCannotOpenTransmitterPro() {
        if (this.mContext.mUtil.isMacOsCatalina() || this.mContext.mUtil.isMacOsBigSur() || this.mContext.mUtil.isMacOsMonterey()) {
            this.mContext.mLayoutPresenterMessages.displayAccessTransmitterProMessageIfNeeded(this);
        }
    }

    public void onChangeWindowSize(int width, int height) {
    }

    public void onClose(int state, int arg) {
        this.mContext.mCurrentLayoutPresenter = this;
        this.close(state, arg);
    }

    public void onFeedback() {
        this.mContext.mUtil.openWebpageFeedback();
    }

    public void onNo(int state, int arg) {
        this.mContext.mCurrentLayoutPresenter = this;
        switch (state) {
            case 1: {
                this.mContext.mOpThreadUi.enqueueTask(new TaskInit(this.mContext, 4, 0L, 0L));
                this.mContext.mOpThreadCore.enqueueMediumPriorityTask(new TaskInit(this.mContext, 3, 0L, 0L));
                break;
            }
            case 3: {
                this.disagree();
                break;
            }
        }
        this.close(state, arg);
    }

    public void onPrivacy() {
        this.mContext.mUtil.openWebpagePrivacy();
    }

    public void onYes(int state, int arg) {
        this.onYes(state, arg, "", 0);
    }

    public void onYes(int state, int arg, String name, int elConfImageId) {
        this.mContext.mCurrentLayoutPresenter = this;
        switch (state) {
            case 1: {
                this.mContext.mLayoutPresenterMessages.downloadSoftware();
                break;
            }
            case 3: {
                this.agree();
                break;
            }
            case 7: {
                this.mContext.mLayoutPresenterScene.onLoad(name);
                break;
            }
            case 11: {
                this.mContext.mLayoutPresenterSceneHasContent.deleteScene(name);
                break;
            }
            case 12: {
                this.mContext.mLayoutPresenterSceneHasContent.onDeletePicture(name, elConfImageId);
                break;
            }
            case 14: {
                this.mContext.mLayoutPresenterUpdate.onFindUnits();
                break;
            }
        }
        this.close(state, arg);
    }

    public void onYes(int state, int arg, String sourceName, String destinationName) {
        this.mContext.mCurrentLayoutPresenter = this;
        switch (state) {
            case 9: {
                this.mContext.mLayoutPresenterSceneDetail.changeName(sourceName, destinationName);
                break;
            }
            case 10: {
                this.mContext.mLayoutPresenterSceneSave.addScene(destinationName);
                break;
            }
        }
        this.close(state, arg);
    }

    public void present(Pane parentView) {
        try {
            this.mContext.mOnScreenLayoutPresenter = this;
            this.mLayoutView.initIfNeeded();
            parentView.getChildren().clear();
            parentView.getChildren().add(0, (Object)this.mLayoutView.getViewNode());
            this.onChangeWindowSize(this.mContext.mSceneWidth, this.mContext.mSceneHeight);
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void setLayoutView(LayoutView layoutView) {
        this.mLayoutView = layoutView;
    }

    public void setSizeSmall(int width, int minWidth) {
        this.mContext.mLayoutNodeDisplay.setMinWidth((double)minWidth);
        this.mContext.mLayoutNodeDisplay.setPrefWidth(-1.0);
        this.mContext.mLayoutNodeDisplay.setMaxWidth(Double.MAX_VALUE);
        if (width < minWidth) {
            this.mContext.mScrollView.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        } else {
            this.mContext.mScrollView.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        }
        this.mContext.mLayoutNodeRoot.getChildren().removeAll((Object[])new Node[]{this.mContext.mScrollView, this.mContext.mLayoutNodeDisplay});
        this.mContext.mScrollView.setContent((Node)this.mContext.mLayoutNodeDisplay);
        this.mContext.mLayoutNodeRoot.getChildren().add(1, (Object)this.mContext.mScrollView);
    }

    public void setSizeSmall(int width, int minWidth, int maxWidth) {
        this.setSizeSmall(width, minWidth);
        this.mContext.mLayoutNodeDisplay.setMaxWidth((double)maxWidth);
    }

    public void setSizeBig() {
        this.mContext.mLayoutNodeDisplay.setMinSize(0.0, 0.0);
        this.mContext.mLayoutNodeDisplay.setPrefWidth(-1.0);
        this.mContext.mLayoutNodeDisplay.setMaxWidth(Double.MAX_VALUE);
        this.mContext.mScrollView.setContent(null);
        this.mContext.mLayoutNodeRoot.getChildren().removeAll((Object[])new Node[]{this.mContext.mScrollView, this.mContext.mLayoutNodeDisplay});
        this.mContext.mLayoutNodeRoot.getChildren().add(1, (Object)this.mContext.mLayoutNodeDisplay);
    }
}

