/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.BridgeDevice;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewChannel;
import com.elinchrom.software.LayoutViewChannelProgress;
import com.elinchrom.software.SortedDeviceItem;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Map;
import javafx.scene.layout.Pane;

public class LayoutPresenterChannel
extends LayoutPresenter {
    public int mState = 0;
    public LayoutViewChannelProgress mLayoutViewChannelProgress = new LayoutViewChannelProgress(this.mContext);
    public LayoutViewChannel mLayoutViewChannel = new LayoutViewChannel(this.mContext);
    public Pane mParentView = null;
    public BridgeDevice mBridgeDevice = null;
    protected Instant mDetectStartTime = null;
    protected Instant mHasBridgeTime = null;
    protected Instant mScanStartTime = null;
    protected boolean mIsFindUnits = false;
    protected boolean mDisplayUpdateMessage = false;

    public LayoutPresenterChannel(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewChannelProgress);
    }

    @Override
    public void agree() {
        super.agree();
        this.mContext.mAppMain.onReadyUi();
    }

    public void bridgeNext() {
        SortedDeviceItem bridgeItem = null;
        Iterator iterator = this.mContext.mSortedBridges.iterator();
        while (iterator.hasNext()) {
            bridgeItem = (SortedDeviceItem)iterator.next();
            if (!((BridgeDevice)bridgeItem.mSortedDevice).equals(this.mBridgeDevice)) continue;
            if (!iterator.hasNext()) break;
            bridgeItem = (SortedDeviceItem)iterator.next();
            break;
        }
        if (bridgeItem != null) {
            this.mBridgeDevice = (BridgeDevice)bridgeItem.mSortedDevice;
            this.setBridgeDevice(this.mBridgeDevice);
        }
    }

    public void bridgePrevious() {
        SortedDeviceItem resultItem = null;
        SortedDeviceItem previousItem = null;
        Object var3_3 = null;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedBridges) {
            if (((BridgeDevice)sortedDeviceItem.mSortedDevice).equals(this.mBridgeDevice)) {
                resultItem = previousItem;
                break;
            }
            previousItem = sortedDeviceItem;
        }
        if (resultItem != null) {
            this.mBridgeDevice = (BridgeDevice)resultItem.mSortedDevice;
            this.setBridgeDevice(this.mBridgeDevice);
        }
    }

    @Override
    public void disagree() {
        super.disagree();
        this.mContext.mAppMain.onReadyUi();
    }

    public void displayBatteryLevel(BridgeDevice bridgeDevice) {
        if (bridgeDevice != null && bridgeDevice.equals(this.mBridgeDevice) && bridgeDevice.mElinchromDevice.valueGetByte(45) == 1) {
            this.mLayoutViewChannel.displayBatteryLevel((int)(bridgeDevice.mElinchromDevice.valueGetLong(45) >> 8));
        }
    }

    public void displayBridgeFirmwareStatus(BridgeDevice bridgeDevice) {
        if (bridgeDevice != null && bridgeDevice.equals(this.mBridgeDevice)) {
            this.mLayoutViewChannel.displayBridgeFirmwareStatus(bridgeDevice.mElinchromDevice.isFirmwareVersionLatest(), this.mContext.mIsInternetAvailable);
        }
    }

    public void displayBridgeList() {
        this.mLayoutViewChannel.initIfNeeded();
        this.mLayoutViewChannel.displayBridgeList();
    }

    public void displaySignalStrength(BridgeDevice bridgeDevice, int signalStrength) {
        if (bridgeDevice != null && bridgeDevice.equals(this.mBridgeDevice)) {
            this.mLayoutViewChannel.displaySignalStrength(signalStrength);
        }
    }

    public void initHasBridgeView() {
        int lastUsedConnectionType = "USB".equals(this.mContext.mStoredPreferences.lastUsedBridgeConnection) ? 1 : 2;
        BridgeDevice selectedBridge = null;
        Iterator iterator = this.mContext.mSortedBridges.iterator();
        while (iterator.hasNext()) {
            BridgeDevice bridgeItem = (BridgeDevice)((SortedDeviceItem)iterator.next()).mSortedDevice;
            if (bridgeItem.getElinchromDevice().getSkyportId().equals(this.mContext.mStoredPreferences.lastUsedBridgeSkyportId) && bridgeItem.getConnectionType() == lastUsedConnectionType) {
                selectedBridge = bridgeItem;
                break;
            }
            if (bridgeItem.getElinchromDevice().getSkyportId().equals(this.mContext.mStoredPreferences.lastUsedBridgeSkyportId)) {
                selectedBridge = bridgeItem;
                continue;
            }
            if (selectedBridge != null || !bridgeItem.equals(this.mBridgeDevice)) continue;
            selectedBridge = bridgeItem;
        }
        this.mBridgeDevice = selectedBridge == null ? (BridgeDevice)((SortedDeviceItem)this.mContext.mSortedBridges.iterator().next()).mSortedDevice : selectedBridge;
        this.setLayoutView(this.mLayoutViewChannel);
        if (this.isOnScreen()) {
            super.present(this.mParentView);
        } else {
            this.mLayoutView.initIfNeeded();
        }
        this.setBridgeDevice(this.mBridgeDevice);
        this.mLayoutViewChannel.displaySkyportChannel(this.mContext.mStoredPreferences.lastUsedSkyportChannel);
        this.mLayoutViewChannel.displayHasBridge();
    }

    public void initNoBridgeView() {
        this.setLayoutView(this.mLayoutViewChannel);
        super.present(this.mParentView);
        this.mLayoutViewChannel.displayNoBridge();
    }

    public void initProgressView(int maxProgress) {
        this.mLayoutViewChannelProgress.mLayoutWidgetProgressBar.setMaximum(maxProgress);
        this.mLayoutViewChannelProgress.mLayoutWidgetProgressBar.setProgress(0.0f);
        this.setLayoutView(this.mLayoutViewChannelProgress);
        super.present(this.mParentView);
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1280 || height < 945) {
            this.setSizeSmall(width, 1265);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.mLayoutViewChannel.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mLayoutViewChannel.setSizeBig();
        }
    }

    public void onDestroy() {
        this.mContext.mOpThreadCore.reset();
        this.mContext.mOpThreadUi.reset();
        this.mContext.mUpdates.clear();
        this.mContext.mSortedUpdates.clear();
        this.mContext.mBridges.clear();
        this.mContext.mSortedBridges.clear();
        this.mContext.mLightingDevices.clear();
        this.mBridgeDevice = null;
        this.mContext.mBridgeDevice = null;
        this.mContext.mNextBridgeDevice = null;
        for (ElinchromDevice elinchromDevice : this.mContext.mElinchromDevices.values()) {
            elinchromDevice.free();
        }
        this.mContext.mElinchromDevices.clear();
    }

    public void onDetect() {
        this.mLayoutViewChannelProgress.setProgressTitle("Detecting");
        this.mIsFindUnits = false;
        this.mDisplayUpdateMessage = true;
        this.startDetect();
    }

    public void onFindUnits(int channelIndex) {
        this.mIsFindUnits = true;
        this.mDisplayUpdateMessage = true;
        this.startScan(channelIndex);
    }

    public void onScan(int channelIndex) {
        this.mIsFindUnits = false;
        this.mDisplayUpdateMessage = true;
        this.startScan(channelIndex + 1);
    }

    public void onRefreshUpdates() {
        this.mLayoutViewChannelProgress.setProgressTitle("Scanning");
        this.mIsFindUnits = true;
        this.mDisplayUpdateMessage = false;
        if (this.mContext.mBridgeDevice != null && this.mContext.mModuleManagerSdk.valueGetByte(38) != 0) {
            this.scan(this.mContext.mBridgeDevice.mElinchromDevice.mDeviceId);
        } else {
            this.startDetect();
        }
    }

    public void onScanUpdateAfterStop() {
        this.mContext.mOpThreadCore.reset();
        this.mContext.mOpThreadUi.reset();
        this.mContext.mUpdates.clear();
        this.mContext.mSortedUpdates.clear();
        this.mContext.mBridges.clear();
        this.mContext.mSortedBridges.clear();
        this.mContext.mLightingDevices.clear();
        this.mContext.mSortedLightingDevices.clear();
        this.mContext.mLayoutPresenterUnits.clear();
        this.mContext.mLayoutPresenterUnits.mLayoutViewUnits.initIfNeeded();
        this.mContext.mLayoutPresenterUnits.mLayoutViewUnits.mFlashUnitsView.getChildren().clear();
        this.mContext.mLayoutPresenterUpdateList.mLayoutViewUpdateList.initIfNeeded();
        this.mContext.mLayoutPresenterUpdateList.mLayoutViewUpdateList.mScrollContentPane.getChildren().clear();
        this.mContext.mLogger.log("DEBUG: Start freeing devices.");
        this.mContext.mIsFreeing = true;
        Iterator<Map.Entry<Long, ElinchromDevice>> entrySetIterator = this.mContext.mElinchromDevices.entrySet().iterator();
        while (entrySetIterator.hasNext()) {
            ElinchromDevice elinchromDevice = entrySetIterator.next().getValue();
            if (this.mContext.mNextBridgeDevice != null && elinchromDevice.mDeviceId == this.mContext.mNextBridgeDevice.mElinchromDevice.mDeviceId && elinchromDevice.valueGetByte(62) == 1) {
                if (elinchromDevice.valueGetByte(57) == 1 && elinchromDevice.valueGetByte(66) != 0 && elinchromDevice.valueGetByte(66) == this.mContext.mModuleManagerSdk.valueGetByte(38)) continue;
                this.mContext.mModuleManagerSdk.enqueueRxTxTask(6, 4, 0L, 0L, elinchromDevice.mDeviceId);
                continue;
            }
            if (this.mContext.mNextBridgeDevice != null && elinchromDevice.mDeviceId == this.mContext.mNextBridgeDevice.mElinchromDevice.mDeviceId && elinchromDevice.valueGetByte(62) == 2) {
                this.mContext.mModuleManagerSdk.enqueueRxTxTask(6, 5, 0L, 0L, elinchromDevice.mDeviceId);
                continue;
            }
            if (elinchromDevice.valueGetByte(57) == 1 && elinchromDevice.valueGetByte(66) != 0 && elinchromDevice.valueGetByte(66) == this.mContext.mModuleManagerSdk.valueGetByte(38)) {
                this.mContext.mModuleManagerSdk.enqueueRxTxTask(7, 3, 0L, 0L, elinchromDevice.mDeviceId);
                continue;
            }
            this.mContext.mModuleManagerSdk.enqueueRxTxTask(6, 3, 0L, 0L, elinchromDevice.mDeviceId);
            entrySetIterator.remove();
        }
        for (Map.Entry<Long, ElinchromDevice> entry : this.mContext.mElinchromDevices.entrySet()) {
            ElinchromDevice elinchromDevice = entry.getValue();
            this.mContext.mOpHandlerUi.insertUnit(elinchromDevice);
        }
        if (this.mContext.mNextBridgeDevice != null) {
            this.mContext.mNextBridgeDevice.mElinchromDevice.mSignalCheckTimeUsb = Instant.now().minus(Duration.ofSeconds(10L));
            this.mContext.mNextBridgeDevice.mElinchromDevice.mSignalCheckTimeBle = Instant.now().minus(Duration.ofSeconds(10L));
            this.mContext.mNextBridgeDevice.mElinchromDevice.mSignalCheckTimeSkyport = Instant.now().minus(Duration.ofSeconds(10L));
        }
        this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 20, 0L, 0L, 0L);
        this.mContext.mBridgeDevice = this.mContext.mNextBridgeDevice;
    }

    public void onTabFirmwareUpdate() {
        if (this.mContext.mSortedBridges.size() > 0) {
            this.mLayoutViewChannel.displayFirmwareUpdateHasBridge();
        } else {
            this.mLayoutViewChannel.displayFirmwareUpdateNoBridge();
        }
    }

    public void onTabStudioControl() {
        if (this.mContext.mSortedBridges.size() > 0) {
            this.mLayoutViewChannel.displayStudioControlHasBridge();
        } else {
            this.mLayoutViewChannel.displayStudioControlNoBridge();
        }
    }

    public void onFirmwareStatus() {
        this.mContext.mLayoutClickUpdatesListener.onTouch();
        this.mContext.mLayoutPresenterUpdate.displayUpdateWithDetails(this.mBridgeDevice.getElinchromDevice().mComponentUpdatable.getLayoutViewUpdate());
    }

    @Override
    public void present(Pane parentView) {
        super.present(parentView);
        this.mContext.mCurrentLayoutPresenter = this;
        this.mParentView = parentView;
        if (this.mState == 5 || this.mState == 8) {
            this.initHasBridgeView();
        }
    }

    public void refresh(int arg) {
        switch (this.mState) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                this.mLayoutViewChannelProgress.mLayoutWidgetProgressBar.increment(this.mContext.mOpDelayCore);
                if (this.mContext.mSortedBridges.size() > 0) {
                    this.mContext.mLayoutPresenterSideMenu.disableDarkMask();
                    this.initHasBridgeView();
                    this.mState = 5;
                    if (this.mIsFindUnits) {
                        this.mContext.mLayoutClickUpdatesListener.onTouch();
                    }
                    if (!this.mIsFindUnits || !this.mDisplayUpdateMessage) break;
                    this.mContext.mLayoutPresenterMessages.displayFirmwareUpdateMessage(this.mContext.mLayoutPresenterUpdate);
                    break;
                }
                if (!Instant.now().isAfter(this.mDetectStartTime.plus(Duration.ofSeconds(7L)))) break;
                this.mContext.mLayoutPresenterSideMenu.disableDarkMask();
                this.initNoBridgeView();
                this.mState = 4;
                if (this.mIsFindUnits) {
                    this.mContext.mLayoutClickUpdatesListener.onTouch();
                }
                if (!this.mIsFindUnits || !this.mDisplayUpdateMessage) break;
                this.mContext.mLayoutPresenterMessages.displayFirmwareUpdateMessage(this.mContext.mLayoutPresenterUpdate);
                break;
            }
            case 4: {
                if (this.mContext.mSortedBridges.size() <= 0) break;
                this.initHasBridgeView();
                this.mState = 5;
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.mLayoutViewChannelProgress.mLayoutWidgetProgressBar.increment(this.mContext.mOpDelayCore);
                break;
            }
            case 7: {
                this.mLayoutViewChannelProgress.mLayoutWidgetProgressBar.increment(this.mContext.mOpDelayCore);
                if (this.mContext.mSortedLightingDevices.size() > 0) {
                    if (!Instant.now().isAfter(this.mScanStartTime.plus(Duration.ofSeconds(5L)))) break;
                    this.mState = 8;
                    this.initHasBridgeView();
                    this.mContext.mLayoutPresenterSideMenu.disableDarkMask();
                    if (this.mIsFindUnits) {
                        this.mContext.mLayoutClickUpdatesListener.onTouch();
                    }
                    if (this.mIsFindUnits && this.mDisplayUpdateMessage) {
                        this.mContext.mLayoutPresenterMessages.displayFirmwareUpdateMessage(this.mContext.mLayoutPresenterUpdate);
                    }
                    if (this.mIsFindUnits) break;
                    this.mContext.mLayoutClickUnitsListener.onTouch();
                    this.mContext.mLayoutPresenterMessages.displayRefreshModeMessage(this.mContext.mLayoutPresenterUnits);
                    break;
                }
                if (!Instant.now().isAfter(this.mScanStartTime.plus(Duration.ofSeconds(15L)))) break;
                this.mState = 8;
                this.initHasBridgeView();
                this.mContext.mLayoutPresenterSideMenu.disableDarkMask();
                if (this.mIsFindUnits) {
                    this.mContext.mLayoutClickUpdatesListener.onTouch();
                }
                if (this.mIsFindUnits && this.mDisplayUpdateMessage) {
                    this.mContext.mLayoutPresenterMessages.displayFirmwareUpdateMessage(this.mContext.mLayoutPresenterUpdate);
                }
                if (this.mIsFindUnits) break;
                this.mContext.mLayoutClickUnitsListener.onTouch();
                this.mContext.mLayoutPresenterMessages.displayRefreshModeMessage(this.mContext.mLayoutPresenterUnits);
                break;
            }
            case 8: {
                break;
            }
        }
    }

    public void scan(long bridgeDeviceId) {
        this.mState = 6;
        this.initProgressView(20000);
        this.mContext.mLayoutPresenterUpdate.mHasNewFirmwareSav = null;
        this.mContext.mLayoutPresenterSideMenu.enableDarkMask();
        this.mContext.mModuleManagerSdk.enqueueRxTxTask(7, 0, 0L, 0L, bridgeDeviceId);
        this.mScanStartTime = Instant.now();
    }

    public void setBridgeDevice(BridgeDevice bridgeDevice) {
        this.mLayoutViewChannel.setBridgeDevice(bridgeDevice);
        if (bridgeDevice.equals(this.mContext.mBridgeDevice)) {
            this.displayBatteryLevel(bridgeDevice);
            this.displayBridgeFirmwareStatus(bridgeDevice);
        }
    }

    public void showDownloadBar() {
        this.mState = 1;
    }

    public void showProgress() {
        this.mLayoutViewChannelProgress.showProgress();
    }

    public void startDetect() {
        this.mContext.mLayoutPresenterSideMenu.displaySkyportChannel(0);
        this.mState = 3;
        this.mContext.mLayoutPresenterUpdate.mHasNewFirmwareSav = null;
        this.mContext.mLayoutPresenterSideMenu.enableDarkMask();
        this.mDetectStartTime = Instant.now();
        this.mContext.mOpThreadCore.reset();
        this.mContext.mOpThreadUi.reset();
        this.mContext.mUpdates.clear();
        this.mContext.mSortedUpdates.clear();
        this.mContext.mBridges.clear();
        this.mContext.mSortedBridges.clear();
        this.mContext.mLightingDevices.clear();
        this.mContext.mSortedLightingDevices.clear();
        this.mContext.mLayoutPresenterUnits.clear();
        this.mContext.mLayoutPresenterUnits.onChangeWindowSize(this.mContext.mSceneWidth, this.mContext.mSceneHeight);
        this.mContext.mLayoutPresenterUpdate.displayUpdates();
        this.mContext.mLayoutPresenterSideMenu.displayHasUpdates();
        this.displayBridgeList();
        this.mBridgeDevice = null;
        this.mContext.mBridgeDevice = null;
        this.mContext.mNextBridgeDevice = null;
        for (ElinchromDevice elinchromDevice : this.mContext.mElinchromDevices.values()) {
            elinchromDevice.free();
        }
        this.mContext.mElinchromDevices.clear();
        this.mContext.mLogger.log("DEBUG: Start freeing all devices.");
        this.mContext.mIsFreeingAll = true;
        this.mContext.mModuleManagerSdk.enqueueRxTxTask(4, 7, 0L, 0L, 0L);
        this.initProgressView(7000);
    }

    public void startScan(int channelIndex) {
        this.mContext.mBridgeDevice = null;
        this.mContext.mNextBridgeDevice = this.mBridgeDevice;
        this.mLayoutViewChannelProgress.setProgressTitle("Scanning");
        this.mContext.mLayoutPresenterSideMenu.displaySkyportChannel(channelIndex);
        this.mContext.mModuleManagerSdk.valueSetByte(38, (byte)channelIndex);
        if (this.mContext.mNextBridgeDevice != null) {
            this.mBridgeDevice.mElinchromDevice.valueSetByte(62, (byte)this.mBridgeDevice.getConnectionType());
            this.mContext.mStoredPreferences.lastUsedBridgeSkyportId = this.mContext.mNextBridgeDevice.mElinchromDevice.getSkyportId();
            this.mContext.mStoredPreferences.lastUsedBridgeConnection = this.mContext.mNextBridgeDevice.getConnectionType() == 1 ? "USB" : "BLE";
        }
        this.mContext.mStoredPreferences.lastUsedSkyportChannel = channelIndex;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        if (channelIndex == 0) {
            this.startDetect();
        } else {
            this.scan(this.mBridgeDevice == null ? 0L : this.mBridgeDevice.mElinchromDevice.mDeviceId);
        }
    }
}

