/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewMessage;
import com.elinchrom.software.LayoutViewMessageAccessTransmitterPro;
import com.elinchrom.software.LayoutViewMessageAgreement;
import com.elinchrom.software.LayoutViewMessageDeleteScene;
import com.elinchrom.software.LayoutViewMessageDownloadSoftware;
import com.elinchrom.software.LayoutViewMessageFindUnits;
import com.elinchrom.software.LayoutViewMessageInstallSoftware;
import com.elinchrom.software.LayoutViewMessageLoadScene;
import com.elinchrom.software.LayoutViewMessageRefreshMode;
import com.elinchrom.software.LayoutViewMessageRemoveSceneImage;
import com.elinchrom.software.LayoutViewMessageReplaceScene;
import com.elinchrom.software.LayoutViewMessageUpdateFirmware;
import java.net.MalformedURLException;
import java.net.URL;
import javafx.scene.layout.Pane;

public class LayoutPresenterMessages
extends LayoutPresenter {
    public LayoutPresenter mParentPresenter = null;
    public Pane mParentView = null;
    public LayoutViewMessage mLayoutViewMessage = null;
    public LayoutViewMessageAccessTransmitterPro mLayoutViewMessageAccessTransmitterPro = null;
    public LayoutViewMessageAgreement mLayoutViewMessageAgreement = null;
    public LayoutViewMessageDownloadSoftware mLayoutViewMessageDownloadSoftware = null;
    public LayoutViewMessageInstallSoftware mLayoutViewMessageInstallSoftware = null;
    public LayoutViewMessageUpdateFirmware mLayoutViewMessageUpdateFirmware = null;
    public LayoutViewMessageRefreshMode mLayoutViewMessageRefreshMode = null;
    public LayoutViewMessageDeleteScene mLayoutViewMessageDeleteScene = null;
    public LayoutViewMessageFindUnits mLayoutViewMessageFindUnits = null;
    public LayoutViewMessageLoadScene mLayoutViewMessageLoadScene = null;
    public LayoutViewMessageReplaceScene mLayoutViewMessageReplaceScene = null;
    public LayoutViewMessageRemoveSceneImage mLayoutViewMessageRemoveSceneImage = null;
    public int mLastRefreshModeMessageId = 0;

    public LayoutPresenterMessages(Context context) {
        super(context);
        this.mLayoutViewMessageAccessTransmitterPro = new LayoutViewMessageAccessTransmitterPro(context);
        this.mLayoutViewMessageAgreement = new LayoutViewMessageAgreement(context);
        this.mLayoutViewMessageDownloadSoftware = new LayoutViewMessageDownloadSoftware(context);
        this.mLayoutViewMessageInstallSoftware = new LayoutViewMessageInstallSoftware(context);
        this.mLayoutViewMessageRefreshMode = new LayoutViewMessageRefreshMode(context);
        this.mLayoutViewMessageFindUnits = new LayoutViewMessageFindUnits(context);
        this.mLayoutViewMessageUpdateFirmware = new LayoutViewMessageUpdateFirmware(context);
        this.mLayoutViewMessageLoadScene = new LayoutViewMessageLoadScene(context);
        this.mLayoutViewMessageDeleteScene = new LayoutViewMessageDeleteScene(context);
        this.mLayoutViewMessageReplaceScene = new LayoutViewMessageReplaceScene(context);
        this.mLayoutViewMessageRemoveSceneImage = new LayoutViewMessageRemoveSceneImage(context);
    }

    public void detachFromParentView() {
        try {
            if (this.mParentView.getChildren().size() > 2) {
                this.mParentView.getChildren().remove(2);
            }
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public boolean displayAccessTransmitterProMessageIfNeeded(LayoutPresenter parentPresenter) {
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageAccessTransmitterPro, null, this.mContext.mStoredPreferences.showAccessTransmitterProMessage == 1);
    }

    public boolean displayAgreementMessageIfNeeded(LayoutPresenter parentPresenter) {
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageAgreement, null, this.mContext.mStoredPreferences.showAgreementMessage == 1);
    }

    public boolean displayDeleteSceneMessageIfNeeded(LayoutPresenter parentPresenter, String sourceScene) {
        this.mLayoutViewMessageDeleteScene.setMessageData(sourceScene);
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageDeleteScene, null, this.mContext.mStoredPreferences.showDeleteSceneMessage == 1);
    }

    public boolean displayDownloadSoftwareMessage(LayoutPresenter parentPresenter) {
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageDownloadSoftware, null, true);
    }

    public boolean displayFindUnitsMessageIfNeeded(LayoutPresenter parentPresenter) {
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageFindUnits, null, this.mContext.mStoredPreferences.showFindUnitsMessage == 1);
    }

    public boolean displayInstallSoftwareMessage(LayoutPresenter parentPresenter) {
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageInstallSoftware, null, true);
    }

    public boolean displayLoadSceneMessageIfNeeded(LayoutPresenter parentPresenter, String sourceScene) {
        this.mLayoutViewMessageLoadScene.setMessageData(sourceScene);
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageLoadScene, null, this.mContext.mStoredPreferences.showLoadSceneMessage == 1);
    }

    public boolean displayMessageIfNeeded(LayoutPresenter parentPresenter, LayoutViewMessage layoutViewMessage, String title, boolean isMessageShown) {
        if (isMessageShown) {
            this.mParentPresenter = parentPresenter;
            this.mLayoutViewMessage = layoutViewMessage;
            this.present((Pane)this.mContext.mLayoutNodeRoot);
            this.mLayoutViewMessage.setTitle(title);
        }
        return isMessageShown;
    }

    public void displayRefreshModeMessage(LayoutPresenter parentPresenter) {
        if (this.mContext.mModuleManagerSdk.valueGetByte(46) == 1) {
            if (this.mContext.mStoredPreferences.showAutoRefreshOnMessage == 1 && this.mLastRefreshModeMessageId != 5) {
                this.mLayoutViewMessageRefreshMode.setMessageId(5);
                this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageRefreshMode, "Auto-refresh", true);
            }
            this.mLastRefreshModeMessageId = 5;
        } else {
            if (this.mContext.mStoredPreferences.showAutoRefreshOffMessage == 1 && this.mLastRefreshModeMessageId != 4) {
                this.mLayoutViewMessageRefreshMode.setMessageId(4);
                this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageRefreshMode, "Manual-refresh", true);
            }
            this.mLastRefreshModeMessageId = 4;
        }
    }

    public void displayFirmwareUpdateMessage(LayoutPresenter parentPresenter) {
        this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageUpdateFirmware, null, this.mContext.mStoredPreferences.showFirmwareUpdateMessage == 1);
    }

    public boolean displayRemoveSceneImageMessageIfNeeded(LayoutPresenter parentPresenter, String sourceScene, int elConfImageId) {
        this.mLayoutViewMessageRemoveSceneImage.setMessageData(sourceScene);
        this.mLayoutViewMessageRemoveSceneImage.setMessageData(elConfImageId);
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageRemoveSceneImage, null, this.mContext.mStoredPreferences.showRemoveSceneImageMessage == 1);
    }

    public boolean displayReplaceSceneMessageIfNeeded(LayoutPresenter parentPresenter, int messageId, String sourceScene, String destinationName) {
        this.mLayoutViewMessageReplaceScene.setMessageId(messageId);
        this.mLayoutViewMessageReplaceScene.setMessageData(sourceScene, destinationName);
        return this.displayMessageIfNeeded(parentPresenter, this.mLayoutViewMessageReplaceScene, null, this.mContext.mStoredPreferences.showReplaceSceneMessage == 1);
    }

    public void downloadSoftware() {
        try {
            URL url = new URL(this.mContext.mFileDocumentSoftwareNews.mJsonNewsSoftware.download_url);
            this.mContext.mUtil.openWebpage(url);
        }
        catch (MalformedURLException malformedUrlException) {
            this.mContext.mLogger.printStackTrace(malformedUrlException);
        }
        this.displayInstallSoftwareMessage(this.mParentPresenter);
    }

    @Override
    public void onBackPressed() {
        this.detachFromParentView();
        this.mParentPresenter.onClose(this.mLayoutViewMessage.mMessageId, 1);
    }

    @Override
    public void onClose(int state, int arg) {
        this.detachFromParentView();
        this.mParentPresenter.onClose(state, arg);
    }

    @Override
    public void onFeedback() {
        this.mContext.mUtil.openWebpageFeedback();
    }

    @Override
    public void onNo(int state, int arg) {
        this.detachFromParentView();
        this.mParentPresenter.onNo(state, arg);
    }

    @Override
    public void onPrivacy() {
        this.mContext.mUtil.openWebpagePrivacy();
    }

    @Override
    public void onYes(int state, int arg, String sourceName, String destinationName) {
        this.detachFromParentView();
        this.mParentPresenter.onYes(state, arg, sourceName, destinationName);
    }

    @Override
    public void onYes(int state, int arg, String name, int elConfImageId) {
        this.detachFromParentView();
        this.mParentPresenter.onYes(state, arg, name, elConfImageId);
    }

    @Override
    public void present(Pane parentView) {
        this.mParentView = parentView;
        this.detachFromParentView();
        try {
            this.mLayoutViewMessage.initIfNeeded();
            this.mLayoutViewMessage.setIsDoNotShowAgainChecked(false);
            parentView.getChildren().add((Object)this.mLayoutViewMessage.getViewNode());
            this.mContext.mCurrentLayoutPresenter = this;
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void restoreMessages() {
        this.mLayoutViewMessage = null;
    }
}

