/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewSceneDetail;
import com.elinchrom.software.Scene;

public class LayoutPresenterSceneDetail
extends LayoutPresenter {
    public LayoutViewSceneDetail mLayoutViewSceneDetail = new LayoutViewSceneDetail(this.mContext);

    public LayoutPresenterSceneDetail(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewSceneDetail);
    }

    public void changeName(String sourceName, String destinationName) {
        this.changeName(new Scene(this.mContext, sourceName), destinationName);
    }

    protected void changeName(Scene sourceScene, String destinationName) {
        new Scene(this.mContext, destinationName).deleteImages();
        Scene movedScene = sourceScene.moveTo(destinationName);
        this.mContext.mStoredPreferences.lastUsedScene = movedScene.getName();
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mLayoutPresenterSideMenu.displayScenes();
        this.mContext.mLayoutPresenterSceneHasContent.displayScenesWithDetail(movedScene.mElConfScene);
    }

    public void displaySceneListItem(ElConfScene elConfScene) {
        this.mLayoutViewSceneDetail.displayElConfScene(elConfScene);
    }

    public void displaySignalStrength(ElinchromDevice elinchromDevice, int signalStrength) {
        if (this.mLayoutViewSceneDetail.isInitialized()) {
            this.mLayoutViewSceneDetail.displaySignalStrength(elinchromDevice, signalStrength);
        }
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1780 || height < 945) {
            this.setSizeSmall(width, 1780, 1780);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.mContext.mLayoutPresenterSceneList.mLayoutViewSceneList.setSizeSmall();
            this.mLayoutViewSceneDetail.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mContext.mLayoutPresenterSceneList.mLayoutViewSceneList.setSizeBig();
            this.mLayoutViewSceneDetail.setSizeBig();
        }
    }

    public void onSceneDescription(ElConfScene elConfScene, String sceneDescription) {
        Scene sourceScene = new Scene(this.mContext, elConfScene.name);
        if (sourceScene.exists() && !sourceScene.mElConfScene.description.equals(sceneDescription)) {
            sourceScene.mElConfScene.description = sceneDescription;
            sourceScene.store();
            this.mContext.mLayoutPresenterSceneHasContent.displayScenesWithDetail(elConfScene);
        }
    }

    public void onSceneName(ElConfScene elConfScene, String destinationName) {
        Scene sourceScene;
        if (!elConfScene.name.equals(destinationName) && (sourceScene = new Scene(this.mContext, elConfScene.name)).exists()) {
            Scene destinationScene = new Scene(this.mContext, destinationName);
            if (!destinationScene.exists()) {
                this.changeName(sourceScene, destinationName);
            } else if (!this.mContext.mLayoutPresenterMessages.displayReplaceSceneMessageIfNeeded(this.mContext.mCurrentLayoutPresenter, 9, sourceScene.mElConfScene.name, destinationName)) {
                this.changeName(sourceScene, destinationName);
            }
        }
    }

    public void onAddPicture(ElConfScene elConfScene) {
        this.enableDarkMask();
        this.mContext.mAppMain.showChoosePictureDialog(elConfScene);
    }
}

