/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfImage;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.FileDocumentPicture;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewSceneHasContent;
import com.elinchrom.software.Scene;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import javafx.scene.image.Image;
import javafx.scene.layout.Pane;
import org.apache.commons.io.IOUtils;

public class LayoutPresenterSceneHasContent
extends LayoutPresenter {
    public Pane mParentView = null;
    public LayoutViewSceneHasContent mLayoutViewSceneHasContent = new LayoutViewSceneHasContent(this.mContext);

    public LayoutPresenterSceneHasContent(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewSceneHasContent);
    }

    public void deleteScene(String sceneName) {
        this.deleteScene(new Scene(this.mContext, sceneName));
    }

    public void deleteScene(ElConfScene elConfScene) {
        this.deleteScene(new Scene(this.mContext, elConfScene.name));
    }

    public void deleteScene(Scene deleteScene) {
        deleteScene.delete();
        this.mContext.mStoredPreferences.lastUsedScene = "";
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mLayoutPresenterSideMenu.displayScenes();
        this.mContext.mLayoutPresenterScene.present(this.mParentView);
    }

    public void displayScenes() {
        this.mLayoutViewSceneHasContent.disableDeleteScene();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayMain.setMouseTransparent(false);
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayRight.setMouseTransparent(true);
        this.mContext.mLayoutPresenterSceneList.present((Pane)this.mLayoutViewSceneHasContent.mLayoutNodeDisplayMain, false);
        this.mContext.mLayoutPresenterSceneList.displayMark(null);
    }

    public void displayScenesWithDetail(ElConfScene elConfScene) {
        this.mLayoutViewSceneHasContent.enableDeleteScene(elConfScene);
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayRight.getChildren().clear();
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayMain.setMouseTransparent(true);
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayLeft.setMouseTransparent(false);
        this.mLayoutViewSceneHasContent.mLayoutNodeDisplayRight.setMouseTransparent(false);
        this.mContext.mLayoutPresenterSceneList.present((Pane)this.mLayoutViewSceneHasContent.mLayoutNodeDisplayLeft, false);
        this.mContext.mLayoutPresenterSceneDetail.present((Pane)this.mLayoutViewSceneHasContent.mLayoutNodeDisplayRight);
        this.mContext.mLayoutPresenterSceneList.displayMark(elConfScene);
        this.mContext.mLayoutPresenterSceneDetail.displaySceneListItem(elConfScene);
    }

    public void displayButtons() {
        this.mContext.mLayoutPresenterSceneButtons.present((Pane)this.mLayoutViewSceneHasContent.mContainerButtons);
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1280 || height < 945) {
            this.setSizeSmall(width, 1280, 1280);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.mContext.mLayoutPresenterSceneList.mLayoutViewSceneList.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mContext.mLayoutPresenterSceneList.mLayoutViewSceneList.setSizeBig();
        }
    }

    public void onDeleteScene(ElConfScene elConfScene) {
        if (elConfScene != null && !this.mContext.mLayoutPresenterMessages.displayDeleteSceneMessageIfNeeded(this.mContext.mLayoutPresenterScene, elConfScene.name)) {
            this.deleteScene(elConfScene);
        }
    }

    public void onDeletePicture(String sceneName, int elConfImageId) {
        Scene displayedScene = new Scene(this.mContext, sceneName);
        this.removeSceneImage(displayedScene, elConfImageId);
    }

    public void onDeletePicture(ElConfScene elConfScene, int elConfImageId) {
        Scene displayedScene = new Scene(this.mContext, elConfScene.name);
        this.removeSceneImage(displayedScene, elConfImageId);
    }

    public void openPicture(ElConfScene elConfScene, File to_open) {
        if (to_open != null && elConfScene != null) {
            Scene displayedScene = new Scene(this.mContext, elConfScene.name);
            FileDocumentPicture fileDocumentPicture = new FileDocumentPicture(this.mContext).fromLocalFolder(to_open.getAbsolutePath());
            Image image = fileDocumentPicture.getImage();
            if (displayedScene.exists() && image != null) {
                int id;
                long longId;
                long freeMediaId = 0x80000000L;
                long highestUsedMediaId = freeMediaId - 1L;
                int[] nArray = this.mContext.mStoredPreferences.elConfIds;
                int n = nArray.length;
                for (int i = 0; i < n && ((longId = (long)(id = nArray[i]) & 0xFFFFFFFFL) < 0x80000000L || longId < highestUsedMediaId + 2L); ++i) {
                    if (longId < 0x80000000L) continue;
                    highestUsedMediaId = longId;
                    freeMediaId = longId + 1L;
                }
                if (freeMediaId >= Integer.MIN_VALUE && freeMediaId <= 0xFFFFFFFFL) {
                    ElConfImage elConfImage = new ElConfImage();
                    elConfImage.id = (int)freeMediaId;
                    elConfImage.format = this.mContext.mUtil.mimeTypeToFileFormat(fileDocumentPicture.mMimeType);
                    elConfImage.name = fileDocumentPicture.getFileName();
                    InputStream input = null;
                    FileOutputStream fileOutputStream = null;
                    try {
                        input = fileDocumentPicture.getInputStream();
                        File elConfMediaFile = new File(this.mContext.mFolderScenes + "id0x" + this.mContext.mUtil.byteArrayToHexString(this.mContext.mUtil.convertIntToByteArrayMSBFirst((int)freeMediaId)) + ".elconf");
                        fileOutputStream = new FileOutputStream(elConfMediaFile, false);
                        IOUtils.copyLarge(input, fileOutputStream);
                        displayedScene.mElConfScene.images = this.mContext.mUtil.arrayAppend(displayedScene.mElConfScene.images, elConfImage);
                        this.mContext.mStoredPreferences.elConfIds = this.mContext.mUtil.arrayAppendUnsignedOrdered(this.mContext.mStoredPreferences.elConfIds, (int)freeMediaId);
                        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
                    }
                    catch (Throwable t) {
                        this.mContext.mLogger.printStackTrace(t);
                    }
                    IOUtils.closeQuietly(input);
                    IOUtils.closeQuietly(fileOutputStream);
                    this.displayScenesWithDetail(elConfScene);
                }
            }
        }
    }

    @Override
    public void present(Pane parentView) {
        super.present(parentView);
        this.mParentView = parentView;
        this.displayScenes();
        this.displayButtons();
    }

    public void removeSceneImage(Scene displayedScene, int elConfImageId) {
        displayedScene.deleteImage(elConfImageId);
        displayedScene.store();
        this.displayScenesWithDetail(displayedScene.mElConfScene);
    }
}

