/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.ElConfUnit;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewSceneSave;
import com.elinchrom.software.Scene;
import com.elinchrom.software.SortedDeviceItem;
import java.util.ArrayList;
import javafx.scene.layout.Pane;

public class LayoutPresenterSceneSave
extends LayoutPresenter {
    public boolean mIsFromUnits = false;
    public Pane mParentView = null;
    public LayoutPresenter mParentPresenter = null;
    public LayoutViewSceneSave mLayoutViewSceneSave = new LayoutViewSceneSave(this.mContext);

    public LayoutPresenterSceneSave(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewSceneSave);
    }

    public void addScene(String newSceneName) {
        Scene destinationScene = new Scene(this.mContext, newSceneName);
        if (destinationScene.exists()) {
            destinationScene.mElConfScene.description = "";
            destinationScene.deleteImages();
        } else {
            destinationScene.create();
        }
        this.storeElConfUnits(destinationScene);
        this.mContext.mLayoutPresenterSideMenu.displayScenes();
    }

    public void displaySaveAs() {
        this.mLayoutViewSceneSave.displaySaveAs();
        this.mContext.mLayoutPresenterSceneSaveAs.present((Pane)this.mLayoutViewSceneSave.mContainerView);
    }

    public void displaySaveNew() {
        this.mLayoutViewSceneSave.displaySaveNew();
        this.mContext.mLayoutPresenterSceneSaveNew.present((Pane)this.mLayoutViewSceneSave.mContainerView);
    }

    protected ElConfUnit[] getCurrentElConfUnits(Scene sourceScene) {
        ArrayList<String> elConfSkyportIds = new ArrayList<String>();
        ArrayList<ElConfUnit> elConfUnits = new ArrayList<ElConfUnit>();
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
            ElinchromDevice elinchromDevice = sortedDeviceItem.getElinchromDevice();
            FlashDevice flashUnit = elinchromDevice.mComponentLighting;
            ElConfUnit elConfUnit = new ElConfUnit();
            elConfUnit.skyport_id = elinchromDevice.getSkyportId();
            elConfUnit.product_id = (byte)(elinchromDevice.getProductId() & 0xFF);
            elConfUnit.group = flashUnit.getGroup();
            elConfUnit.friendly_name = flashUnit.getFriendlyNameString();
            elConfUnit.flash_power = flashUnit.getFlash_power_values();
            elConfUnit.head_on = flashUnit.getHead_on();
            elConfUnit.lamp_power_fstop = flashUnit.getLamp_power_fstop_values();
            elConfUnit.lamp_mode = flashUnit.getLamp_mode();
            elConfUnit.lamp_timer = flashUnit.getLamp_timer();
            elConfUnit.lamp_power_percentage = flashUnit.getLamp_power_percentage();
            elConfUnit.flash_mode_values = flashUnit.getFlash_mode_values();
            elConfUnit.photocell_mode = flashUnit.getPhotocell_mode();
            elConfUnit.charge_mode = flashUnit.getCharge_mode();
            elConfUnit.audio_mode = flashUnit.getAudio_mode();
            elConfUnit.standby_mode = flashUnit.isUnit_standby() ? (byte)1 : 0;
            elConfUnit.auto_off = flashUnit.getAuto_off();
            elConfUnits.add(elConfUnit);
            elConfSkyportIds.add(elConfUnit.skyport_id);
        }
        if (sourceScene.exists()) {
            for (ElConfUnit elConfUnit : sourceScene.mElConfScene.units) {
                if (elConfSkyportIds.contains(elConfUnit.skyport_id)) continue;
                elConfUnits.add(elConfUnit);
                elConfSkyportIds.add(elConfUnit.skyport_id);
            }
        }
        return elConfUnits.toArray(new ElConfUnit[0]);
    }

    public void onCancel() {
        if (this.mIsFromUnits) {
            this.mParentPresenter.present(this.mParentView);
        } else {
            this.mContext.mLayoutClickSceneListener.onTouch();
        }
    }

    public void onSaveAs(ElConfScene elConfScene) {
        Scene sourceScene = new Scene(this.mContext, elConfScene.name);
        if (sourceScene.exists()) {
            this.storeElConfUnits(sourceScene, sourceScene);
        }
    }

    public void onSaveNew(String newSceneName) {
        Scene sourceScene = new Scene(this.mContext, newSceneName);
        if (!sourceScene.exists()) {
            this.addScene(newSceneName);
        } else if (!this.mContext.mLayoutPresenterMessages.displayReplaceSceneMessageIfNeeded(this.mContext.mCurrentLayoutPresenter, 10, "", newSceneName)) {
            this.addScene(newSceneName);
        }
    }

    public void onTabSaveAs() {
        this.displaySaveAs();
    }

    public void onTabSaveNew() {
        this.displaySaveNew();
    }

    @Override
    public void present(Pane parentView) {
        this.present(parentView, false);
    }

    public void present(Pane parentView, boolean isFromUnits) {
        this.mIsFromUnits = isFromUnits;
        this.mParentView = parentView;
        this.mParentPresenter = this.mContext.mCurrentLayoutPresenter;
        super.present(this.mParentView);
        if (this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes.length > 0) {
            this.displaySaveAs();
        } else {
            this.displaySaveNew();
        }
    }

    protected void storeElConfUnits(Scene destinationScene) {
        this.storeElConfUnits(new Scene(this.mContext), destinationScene);
    }

    protected void storeElConfUnits(Scene sourceScene, Scene destinationScene) {
        destinationScene.mElConfScene.units = this.getCurrentElConfUnits(sourceScene);
        this.mContext.mStoredPreferences.lastUsedScene = destinationScene.getName();
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        if (this.mIsFromUnits) {
            this.mParentPresenter.present(this.mParentView);
        } else {
            this.mContext.mLayoutPresenterSceneHasContent.present(this.mParentView);
            this.mContext.mLayoutPresenterSceneHasContent.displayScenesWithDetail(destinationScene.mElConfScene);
        }
    }
}

