/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewSettings;
import com.elinchrom.software.SortedCollection;
import javafx.scene.layout.Pane;

public class LayoutPresenterSettings
extends LayoutPresenter {
    public LayoutViewSettings mLayoutViewSettings = new LayoutViewSettings(this.mContext);

    public LayoutPresenterSettings(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewSettings);
    }

    @Override
    public void disagree() {
        super.disagree();
        this.mContext.mLayoutClickSettingsListener.onTouch();
    }

    public void displayInstallId(String installId) {
        this.mLayoutViewSettings.displayInstallId(installId);
    }

    public void displayShareData(boolean isShareData) {
        this.mLayoutViewSettings.displayShareData(isShareData);
    }

    public void onChangeBridgeAutoOff(int bridgeAutoOffMinutes) {
        this.mContext.mStoredPreferences.bridgeAutoOff = bridgeAutoOffMinutes;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mModuleManagerSdk.valueSetByte(42, this.mContext.mStoredPreferences.bridgeAutoOff == 0 ? (byte)0 : 1);
        this.mContext.mModuleManagerSdk.valueSetByte(43, (byte)(this.mContext.mStoredPreferences.bridgeAutoOff & 0xFF));
    }

    public void onChangeSortedAlphabetically(boolean isSortedAlphabetically) {
        this.mContext.mStoredPreferences.sortManually = isSortedAlphabetically ? 0 : 1;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
        this.mContext.mSortedLightingDevices = new SortedCollection(this.mContext, !isSortedAlphabetically);
        this.mContext.mLayoutPresenterUnits.sortUnits();
        this.mContext.mLayoutPresenterUnits.displayUnits();
    }

    public void onChangeSharedData(boolean isSharedData) {
        if (isSharedData) {
            this.mContext.mStoredPreferences.showAgreementMessage = 1;
            this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
            this.mContext.mLayoutPresenterMessages.displayAgreementMessageIfNeeded(this);
        } else {
            this.mContext.mStoredPreferences.shareData = 0;
            this.mContext.mStoredPreferences.needRefreshSharing = 1;
            this.mContext.mStoredPreferences.showAgreementMessage = 0;
            this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
            this.mContext.mUtil.initSharing();
        }
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1280 || height < 945) {
            this.setSizeSmall(width, 1265);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.mLayoutViewSettings.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mLayoutViewSettings.setSizeBig();
        }
    }

    public void onRestoreMessages() {
        this.mContext.mLayoutPresenterMessages.restoreMessages();
        this.mContext.mStoredPreferences.showAutoRefreshOnMessage = 1;
        this.mContext.mStoredPreferences.showAutoRefreshOffMessage = 1;
        this.mContext.mStoredPreferences.showLoadSceneMessage = 1;
        this.mContext.mStoredPreferences.showReplaceSceneMessage = 1;
        this.mContext.mStoredPreferences.showDeleteSceneMessage = 1;
        this.mContext.mStoredPreferences.showRemoveSceneImageMessage = 1;
        this.mContext.mStoredPreferences.showFirmwareUpdateMessage = 1;
        this.mContext.mStoredPreferences.showFindUnitsMessage = 1;
        this.mContext.mStoredPreferences.showAccessTransmitterProMessage = 1;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
    }

    @Override
    public void present(Pane parentView) {
        super.present(parentView);
        this.mContext.mCurrentLayoutPresenter = this;
        this.displayInstallId(this.mContext.mStoredPreferences.installId);
        this.displayShareData(this.mContext.mStoredPreferences.shareData == 1);
    }
}

