/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewSideMenu;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.SortedDeviceItem;
import javafx.scene.layout.Pane;

public class LayoutPresenterSideMenu
extends LayoutPresenter {
    public LayoutViewSideMenu mLayoutViewSideMenu;
    public LayoutWidgetIcon mHiglightedNavigationButton = null;
    public Pane mParentView = null;

    public LayoutPresenterSideMenu(Context context) {
        super(context);
        this.mLayoutViewSideMenu = new LayoutViewSideMenu(context);
        this.setLayoutView(this.mLayoutViewSideMenu);
    }

    @Override
    public void disableDarkMask() {
        if (this.mParentView.getChildren().size() > 1) {
            this.mParentView.getChildren().remove(1);
        }
    }

    public void displayHasUpdates() {
        boolean hasUpdates = false;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedUpdates) {
            hasUpdates |= !sortedDeviceItem.getElinchromDevice().isFirmwareVersionLatest();
        }
        this.mLayoutViewSideMenu.displayHasUpdates(hasUpdates);
    }

    public void displayScenes() {
        this.mLayoutViewSideMenu.displayScenes(this.mContext.mStoredPreferences.elConfVersion0x00000014.scenes);
    }

    public void displaySignalStrength(int signalStrength) {
        this.mLayoutViewSideMenu.displaySignalStrength(signalStrength);
    }

    public void displaySkyportChannel(int skyportChannel) {
        this.mLayoutViewSideMenu.displaySkyportChannel(skyportChannel);
    }

    @Override
    public void enableDarkMask() {
        this.disableDarkMask();
        this.mParentView.getChildren().add(1, (Object)this.mLayoutViewSideMenu.getDarkMask());
    }

    public void highlight(LayoutWidgetIcon sourceButton) {
        if (this.mHiglightedNavigationButton != null) {
            this.mHiglightedNavigationButton.setTint("FFFFFF");
        }
        sourceButton.setTint("21b894");
        this.setHighlighted(sourceButton);
    }

    public void onGroupIndent() {
        this.mLayoutViewSideMenu.onGroupIndent();
        this.mContext.mLayoutClickGroup1Listener.onGroupEnable();
        this.mContext.mLayoutClickGroup2Listener.onGroupEnable();
        this.mContext.mLayoutClickGroup3Listener.onGroupEnable();
        this.mContext.mLayoutClickGroup4Listener.onGroupEnable();
        this.mContext.mLayoutClickGroup1Listener.onGroupIndent();
        this.mContext.mLayoutClickGroup2Listener.onGroupIndent();
        this.mContext.mLayoutClickGroup3Listener.onGroupIndent();
        this.mContext.mLayoutClickGroup4Listener.onGroupIndent();
    }

    public void onGroupRestore() {
        this.mLayoutViewSideMenu.onGroupRestore();
        this.mContext.mLayoutClickGroup1Listener.onGroupRestore();
        this.mContext.mLayoutClickGroup2Listener.onGroupRestore();
        this.mContext.mLayoutClickGroup3Listener.onGroupRestore();
        this.mContext.mLayoutClickGroup4Listener.onGroupRestore();
        this.mContext.mLayoutClickGroup1Listener.onGroupDisable();
        this.mContext.mLayoutClickGroup2Listener.onGroupDisable();
        this.mContext.mLayoutClickGroup3Listener.onGroupDisable();
        this.mContext.mLayoutClickGroup4Listener.onGroupDisable();
    }

    public void setSideSizeBig() {
        this.mLayoutViewSideMenu.setSizeBig();
    }

    public void setSideSizeSmall() {
        this.mLayoutViewSideMenu.setSizeSmall();
    }

    @Override
    public void present(Pane parentView) {
        this.mParentView = parentView;
        super.present(this.mParentView);
        this.enableDarkMask();
    }

    public void refresh() {
    }

    public void setHighlighted(LayoutWidgetIcon higlightedNavigationButton) {
        this.mHiglightedNavigationButton = higlightedNavigationButton;
    }
}

