/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewUnit;
import com.elinchrom.software.LayoutViewUnits;
import com.elinchrom.software.SortedDeviceItem;
import com.elinchrom.software.UnitView;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class LayoutPresenterUnits
extends LayoutPresenter {
    public LayoutViewUnits mLayoutViewUnits = new LayoutViewUnits(this.mContext);
    public Pane mParentView = null;
    public float mMinFlashPower = 0.0f;
    public float mMaxFlashPower = 0.0f;
    public float mMinLampPower = 0.0f;
    public float mMaxLampPower = 0.0f;
    public int mNavigationSelected = 0;
    public int mMarginLeft = 22;
    public int mMarginRight = 22;

    public LayoutPresenterUnits(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewUnits);
    }

    public void activateRow(FlashDevice flashUnit) {
    }

    public void addUnit(FlashDevice flashUnit) {
        this.displayUnit(flashUnit);
        if (this.isOnScreen()) {
            this.onChangeWindowSize(this.mContext.mSceneWidth, this.mContext.mSceneHeight);
        }
    }

    public void clear() {
    }

    public void displayLabels() {
    }

    public void displayUnit(FlashDevice flashUnit) {
        this.mLayoutViewUnits.initIfNeeded();
        this.getUnitView(flashUnit).displayFriendlyName(flashUnit.getFriendlyNameString());
        this.getUnitView(flashUnit).displayHeadOn(flashUnit.getHead_on(), flashUnit.getHead_plugged());
        this.getUnitView(flashUnit).displayInteractionStatus(flashUnit.isUnit_standby(), flashUnit.getHead_on());
        this.getUnitView(flashUnit).displayStandbyMode(flashUnit.isUnit_standby());
        this.getUnitView(flashUnit).displayFlashPower(flashUnit.getFlash_power_values());
        this.displayLampMode(flashUnit, flashUnit.getLamp_mode_mode());
        this.getUnitView(flashUnit).displayGroup(flashUnit.getGroup());
        flashUnit.getLayoutViewUnit().displayAudioMode(flashUnit.getAudio_mode());
        flashUnit.getLayoutViewUnit().displayPhotocellMode(flashUnit.getPhotocell_mode());
        flashUnit.getLayoutViewUnit().displayRecyclingMode(flashUnit.getCharge_mode());
        flashUnit.getLayoutViewUnit().displayPowerRatio(flashUnit.getHeads_ratio());
        flashUnit.getLayoutViewUnit().displayFlashMode();
        flashUnit.getLayoutViewUnit().displayFirmwareVersion(flashUnit.mElinchromDevice.getFirmwareVersion());
        flashUnit.getLayoutViewUnit().displayFlashCounter(flashUnit.getFlash_counter(), flashUnit.mFlashSessionCount);
        flashUnit.getLayoutViewUnit().displayFirmwareStatus(flashUnit.mElinchromDevice.isFirmwareVersionLatest(), this.mContext.mIsInternetAvailable);
        this.onSelectionChange();
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1280 || height < 945) {
            this.setSizeSmall(width, 1265);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.updateMetrics();
            this.mLayoutViewUnits.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mLayoutViewUnits.setSizeBig();
        }
        this.displayUnits();
    }

    public void displayUnits() {
        int column = 0;
        int row = 0;
        this.updateMetrics();
        this.mLayoutViewUnits.initIfNeeded();
        this.mLayoutViewUnits.mFlashUnitsView.getChildren().clear();
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
            FlashDevice flashDevice = sortedDeviceItem.getElinchromDevice().mComponentLighting;
            if ((1 << flashDevice.getGroup() & this.mContext.mGroupSelected) == 0) continue;
            LayoutViewUnit layoutViewUnit = flashDevice.getLayoutViewUnit();
            layoutViewUnit.setMinSize(this.mContext.mColumnWidth, this.mContext.mRowHeight);
            layoutViewUnit.setPrefSize(this.mContext.mColumnWidth, this.mContext.mRowHeight);
            layoutViewUnit.setMaxSize(this.mContext.mColumnWidth, this.mContext.mRowHeight);
            GridPane.setConstraints((Node)layoutViewUnit, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets((double)(row * (this.mContext.mRowHeight + 14)), 0.0, 0.0, (double)(column * (this.mContext.mColumnWidth + 14) + 14)));
            this.mLayoutViewUnits.mFlashUnitsView.getChildren().add((Object)layoutViewUnit);
            if ((column = (column + 1) % this.mContext.mColumnsCount) != 0) continue;
            ++row;
        }
    }

    @Override
    public UnitView getUnitView(FlashDevice flashUnit) {
        return flashUnit.getLayoutViewUnit();
    }

    @Override
    public void onBackPressed() {
    }

    public void onChangeFlashModeDefault(ElinchromDevice elinchromDevice) {
        FlashDevice flashUnit = elinchromDevice.mComponentLighting;
        short[] flashMode = flashUnit.getFlash_mode_values();
        flashUnit.sendFlashMode((byte)0, (byte)flashMode[1], (byte)flashMode[2], (byte)flashMode[3], flashMode[4], flashMode[5], (byte)flashMode[6], flashMode[7]);
    }

    public void onChangeFlashModeDelay(ElinchromDevice elinchromDevice, String delayString) {
        short delay_interval;
        FlashDevice flashUnit = elinchromDevice.mComponentLighting;
        short[] flashMode = flashUnit.getFlash_mode_values();
        try {
            delay_interval = Short.parseShort(delayString);
        }
        catch (Throwable t) {
            delay_interval = 1;
        }
        flashUnit.sendFlashMode((byte)2, (byte)flashMode[1], (byte)flashMode[2], (byte)flashMode[3], flashMode[4], delay_interval, (byte)flashMode[6], flashMode[7]);
    }

    public void onChangeFlashModeSequence(ElinchromDevice elinchromDevice, String sequenceTimeoutString, int unitAddressPosition, int totalUnitsPosition) {
        short seq_timeout;
        FlashDevice flashUnit = elinchromDevice.mComponentLighting;
        short[] flashMode = flashUnit.getFlash_mode_values();
        try {
            seq_timeout = Short.parseShort(sequenceTimeoutString);
        }
        catch (Throwable t) {
            seq_timeout = 100;
        }
        byte seq_address = flashUnit.mUnitAddressValues[unitAddressPosition];
        byte seq_units = flashUnit.mTotalUnitsValues[totalUnitsPosition];
        if (seq_address > seq_units) {
            seq_address = seq_units;
        }
        flashUnit.sendFlashMode((byte)1, (byte)flashMode[1], seq_address, seq_units, seq_timeout, flashMode[5], (byte)flashMode[6], flashMode[7]);
    }

    public void onChangeFlashModeStrobo(ElinchromDevice elinchromDevice, String durationString, int flashesPerSecondPosition) {
        short strobo_duration;
        FlashDevice flashUnit = elinchromDevice.mComponentLighting;
        short[] flashMode = flashUnit.getFlash_mode_values();
        try {
            strobo_duration = Short.parseShort(durationString);
        }
        catch (Throwable t) {
            strobo_duration = 500;
        }
        byte strobo_freq = flashUnit.mFlashesPerSecondValues[flashesPerSecondPosition];
        flashUnit.sendFlashMode((byte)3, (byte)flashMode[1], (byte)flashMode[2], (byte)flashMode[3], flashMode[4], flashMode[5], strobo_freq, strobo_duration);
    }

    public void onChangeFlashPower(ElinchromDevice elinchromDevice, int mainPower) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.getClippedFlashPowerValues(new int[]{mainPower, flashPowerValues[1], flashPowerValues[2]});
        this.getUnitView(componentLighting).displayFlashPower(checkedFlashPower);
        componentLighting.setFlash_power_values(checkedFlashPower);
    }

    public void onChangeHeadAElStop(ElinchromDevice elinchromDevice, int flashAPower) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.checkPowerBoundsHeadA(new int[]{flashPowerValues[0], flashAPower, flashPowerValues[2]});
        this.getUnitView(componentLighting).displayFlashPower(checkedFlashPower);
        componentLighting.setFlash_power_values(checkedFlashPower);
    }

    public void onChangeHeadBElStop(ElinchromDevice elinchromDevice, int flashBPower) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        int[] flashPowerValues = componentLighting.getMainPowerValues();
        byte[] checkedFlashPower = componentLighting.checkPowerBoundsHeadB(new int[]{flashPowerValues[0], flashPowerValues[1], flashBPower});
        this.getUnitView(componentLighting).displayFlashPower(checkedFlashPower);
        componentLighting.setFlash_power_values(checkedFlashPower);
    }

    public void onChangeLampA(ElinchromDevice elinchromDevice, int lampAPower) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        byte[] checkedLampPowerValues = componentLighting.getCheckedLampPowerValuesA(lampAPower);
        this.getUnitView(componentLighting).displayLampPower(checkedLampPowerValues);
        this.enableModLampFreeIfNeeded(componentLighting);
        componentLighting.setLampPowerValues(checkedLampPowerValues);
    }

    public void onChangeLampB(ElinchromDevice elinchromDevice, int lampAPower) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        byte[] checkedLampPowerValues = componentLighting.getCheckedLampPowerValuesB(lampAPower);
        this.getUnitView(componentLighting).displayLampPower(checkedLampPowerValues);
        this.enableModLampFreeIfNeeded(componentLighting);
        componentLighting.setLampPowerValues(checkedLampPowerValues);
    }

    public void onChangeLampMode(ElinchromDevice elinchromDevice, int lampMode) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        this.getUnitView(componentLighting).displayLampMode(lampMode);
        componentLighting.setLamp_mode_mode(lampMode);
    }

    public void onChangeLampPowerIncrement(ElinchromDevice elinchromDevice, int lampPowerIncrement) {
        FlashDevice componentLighting = elinchromDevice.mComponentLighting;
        byte[] checkedLampPowerValues = componentLighting.getCheckedLampPowerValuesForFreeMode(lampPowerIncrement);
        this.getUnitView(componentLighting).displayLampPower(checkedLampPowerValues);
        this.enableModLampFreeIfNeeded(componentLighting);
        componentLighting.setLampPowerValues(checkedLampPowerValues);
    }

    public void onDragMove(Long unitId) {
    }

    public void onDragStop() {
    }

    public void onFirmwareStatus(ElinchromDevice elinchromDevice) {
        this.mContext.mLayoutClickUpdatesListener.onTouch();
        this.mContext.mLayoutPresenterUpdate.displayUpdateWithDetails(elinchromDevice.mComponentUpdatable.getLayoutViewUpdate());
    }

    public void onGroupActivated(int activatedGroup) {
    }

    public void onGroupDeActivated() {
    }

    public void onHeadSwitch(ElinchromDevice elinchromDevice, boolean isHeadAOn, boolean isHeadBOn) {
        elinchromDevice.mComponentLighting.setHead_on((byte)((isHeadAOn ? 1 : 0) | (isHeadBOn ? 2 : 0)));
    }

    public void onPositionActivated(FlashDevice sourceFlashUnit, FlashDevice destinationFlashUnit) {
    }

    public void onPositionDeActivated(FlashDevice sourceFlashUnit, FlashDevice destinationFlashUnit) {
    }

    public void onRefresh() {
        if (this.mContext.mRefreshMode == 0) {
            byte periodicTarget = (byte)(this.mContext.mModuleManagerSdk.valueGetByte(44) + 1);
            this.mContext.mModuleManagerSdk.valueSetByte(44, periodicTarget);
        }
    }

    public void onSelectionChange() {
        this.mLayoutViewUnits.onSelectionChange();
    }

    public void onSave() {
        this.mContext.mLayoutPresenterSceneSave.present(this.mParentView, true);
    }

    public void onToggleAutoRefresh() {
        this.mContext.mRefreshMode = this.mContext.mRefreshMode == 1 ? (byte)0 : 1;
        this.mLayoutViewUnits.displayRefreshMode(this.mContext.mRefreshMode);
        this.mContext.mModuleManagerSdk.valueSetByte(46, this.mContext.mRefreshMode);
        if (this.mContext.mRefreshMode == 1) {
            this.mContext.mLayoutPresenterMessages.displayRefreshModeMessage(this);
        }
        this.mContext.mStoredPreferences.lastUsedAutoRefreshMode = this.mContext.mRefreshMode;
        this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
    }

    public void onUnitAudio(ElinchromDevice elinchromDevice, boolean isChecked) {
        elinchromDevice.mComponentLighting.setAudio_mode(isChecked ? (byte)1 : 0);
    }

    public void onUnitPhotocell(ElinchromDevice elinchromDevice, byte photocellMode) {
        elinchromDevice.mComponentLighting.setPhotocell_mode(photocellMode);
    }

    public void onUnitStandby(ElinchromDevice elinchromDevice, boolean isChecked) {
        elinchromDevice.mComponentLighting.setUnit_standby(isChecked);
    }

    @Override
    public void present(Pane parentView) {
        this.mParentView = parentView;
        super.present(parentView);
        this.mContext.mCurrentLayoutPresenter = this;
        this.mLayoutViewUnits.displayTitle(this.mContext.mGroupTitle);
        this.mLayoutViewUnits.displayRefreshMode(this.mContext.mRefreshMode);
        if (this.mNavigationSelected != this.mContext.mGroupSelected) {
            this.mNavigationSelected = this.mContext.mGroupSelected;
            this.displayUnits();
        }
        this.activateRow(null);
    }

    public void setMargins(int marginLeft, int marginRight) {
        this.mMarginLeft = marginLeft;
        this.mMarginRight = marginRight;
    }

    public void sortUnits() {
        this.mContext.mSortedLightingDevices.clear();
        this.mContext.mSortedLightingDevices.addAll(this.mContext.mLightingDevices);
    }

    public void updateMetrics() {
        int lightingDeviceCount = 0;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
            lightingDeviceCount += (1 << sortedDeviceItem.getElinchromDevice().mComponentLighting.getGroup() & this.mContext.mGroupSelected) != 0 ? 1 : 0;
        }
        int windowWidth = (int)Math.floor(this.mContext.mPrimaryStage.getScene().widthProperty().getValue()) - (this.mContext.mSceneWidth <= 1280 ? 285 : 270);
        int n = 330;
        this.mContext.mColumnsCount = (int)Math.max(1.0, Math.floor((double)windowWidth / (double)n));
        int windowHeight = (int)Math.floor(this.mContext.mPrimaryStage.getScene().heightProperty().getValue()) - (this.mContext.mUtil.isWindows() ? 146 : 133);
        int cellHeightMin = 431;
        int rowsCount = (int)Math.max(2.0, Math.floor((double)windowHeight / (double)cellHeightMin));
        this.mContext.mRowsCount = (int)Math.ceil((double)lightingDeviceCount / (double)this.mContext.mColumnsCount);
        if (this.mContext.mSceneWidth < 1280 || this.mContext.mSceneHeight < 945) {
            this.mContext.mRowHeight = cellHeightMin - 14;
            this.mContext.mColumnWidth = n - 14;
        } else {
            this.mContext.mRowHeight = (int)Math.max((double)cellHeightMin, Math.floor((double)windowHeight / (double)rowsCount)) - 14;
            this.mContext.mColumnWidth = (int)Math.max((double)n, Math.floor((double)windowWidth / Math.max((double)this.mContext.mColumnsCount, 2.0))) - 14;
        }
    }
}

