/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.LayoutPresenter;
import com.elinchrom.software.LayoutViewUpdateList;
import com.elinchrom.software.LayoutViewUpdateListItem;
import com.elinchrom.software.SortedDeviceItem;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;

public class LayoutPresenterUpdateList
extends LayoutPresenter {
    public LayoutViewUpdateList mLayoutViewUpdateList = new LayoutViewUpdateList(this.mContext);

    public LayoutPresenterUpdateList(Context context) {
        super(context);
        this.setLayoutView(this.mLayoutViewUpdateList);
    }

    public void addUnit(ElinchromDevice flashUnit) {
        this.displayUpdate(flashUnit);
        this.displayUpdates();
    }

    public void displayMark(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        for (Node node : this.mLayoutViewUpdateList.mScrollContentPane.getChildren()) {
            if (!(node instanceof LayoutViewUpdateListItem)) continue;
            ((LayoutViewUpdateListItem)node).displayMark(false);
        }
        if (layoutViewUpdateListItem != null) {
            layoutViewUpdateListItem.displayMark(true);
        }
    }

    public void displayStartedUpdate(ElinchromDevice flashUnit) {
        LayoutViewUpdateListItem layoutViewUpdateListItem = flashUnit.mComponentUpdatable.getLayoutViewUpdate();
        layoutViewUpdateListItem.displayUpdateConnectionType(flashUnit.valueGetByte(61));
        layoutViewUpdateListItem.displayStartedFirmwareStatus("Queued");
        layoutViewUpdateListItem.displayMark(false);
        layoutViewUpdateListItem.displayId(flashUnit.getSkyportId());
        layoutViewUpdateListItem.displayImage(flashUnit.getImageUrl());
        layoutViewUpdateListItem.displayName(flashUnit.getFriendlyName());
    }

    public void presentStartedExtract(ElinchromDevice elinchromDevice) {
        if (elinchromDevice.valueGetByte(60) == 3) {
            this.mLayoutViewUpdateList.mScrollContentPane.getChildren().clear();
            LayoutViewUpdateListItem layoutViewUnit = elinchromDevice.mComponentUpdatable.getLayoutViewUpdate();
            layoutViewUnit.setMinHeight(72.0);
            layoutViewUnit.setPrefHeight(72.0);
            layoutViewUnit.setMaxHeight(72.0);
            GridPane.setConstraints((Node)layoutViewUnit, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            GridPane.setFillWidth((Node)layoutViewUnit, (Boolean)true);
            this.displayStartedUpdate(elinchromDevice);
            this.mLayoutViewUpdateList.mScrollContentPane.getChildren().add((Object)layoutViewUnit);
        }
    }

    public void displayStartedUpdates() {
        int row = 0;
        this.mLayoutViewUpdateList.mScrollContentPane.getChildren().clear();
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedUpdates) {
            ElinchromDevice elinchromDevice = sortedDeviceItem.getElinchromDevice();
            LayoutViewUpdateListItem layoutViewUnit = elinchromDevice.mComponentUpdatable.getLayoutViewUpdate();
            if (!layoutViewUnit.mHasNewFirmware || elinchromDevice.valueGetByte(60) != 3 || !layoutViewUnit.mIsSelected) continue;
            layoutViewUnit.setMinHeight(72.0);
            layoutViewUnit.setPrefHeight(72.0);
            layoutViewUnit.setMaxHeight(72.0);
            GridPane.setConstraints((Node)layoutViewUnit, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER, (Insets)new Insets((double)(row * 86), 0.0, 0.0, 0.0));
            GridPane.setFillWidth((Node)layoutViewUnit, (Boolean)true);
            this.displayStartedUpdate(elinchromDevice);
            this.mLayoutViewUpdateList.mScrollContentPane.getChildren().add((Object)layoutViewUnit);
            ++row;
        }
    }

    public void displayUpdate(ElinchromDevice flashUnit) {
        LayoutViewUpdateListItem layoutViewUpdateListItem = flashUnit.mComponentUpdatable.getLayoutViewUpdate();
        layoutViewUpdateListItem.initIfNeeded();
        layoutViewUpdateListItem.displayUpdateConnectionType(flashUnit.valueGetByte(61));
        layoutViewUpdateListItem.displayFirmwareStatus(this.mContext.mIsInternetAvailable && !flashUnit.isFirmwareVersionLatest());
        layoutViewUpdateListItem.displayFirmwareUpdateMode(flashUnit.valueGetByte(60) == 3);
        layoutViewUpdateListItem.displayId(flashUnit.getSkyportId());
        layoutViewUpdateListItem.displayImage(flashUnit.getImageUrl());
        layoutViewUpdateListItem.displayName(flashUnit.getFriendlyName());
    }

    public void displayUpdates() {
        int row = 0;
        this.mLayoutViewUpdateList.initIfNeeded();
        this.mLayoutViewUpdateList.mScrollContentPane.getChildren().clear();
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedUpdates) {
            ElinchromDevice elinchromDevice = sortedDeviceItem.getElinchromDevice();
            LayoutViewUpdateListItem layoutViewUnit = elinchromDevice.mComponentUpdatable.getLayoutViewUpdate();
            if (!this.mContext.mShowAllUpdateUnits && elinchromDevice.isFirmwareVersionLatest()) continue;
            layoutViewUnit.setMinHeight(72.0);
            layoutViewUnit.setPrefHeight(72.0);
            layoutViewUnit.setMaxHeight(72.0);
            GridPane.setConstraints((Node)layoutViewUnit, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER, (Insets)new Insets((double)(row * 86), 0.0, 0.0, 0.0));
            GridPane.setFillWidth((Node)layoutViewUnit, (Boolean)true);
            layoutViewUnit.initIfNeeded();
            this.displayUpdate(elinchromDevice);
            layoutViewUnit.setIsSav(this.mContext.mModuleManagerSdk.valueGetByte(48) == 1);
            this.mLayoutViewUpdateList.mScrollContentPane.getChildren().add((Object)layoutViewUnit);
            ++row;
        }
    }

    @Override
    public void onChangeWindowSize(int width, int height) {
        if (width < 1280 || height < 945) {
            this.setSizeSmall(width, 1280, 1280);
            this.mContext.mLayoutPresenterSideMenu.setSideSizeSmall();
            this.mLayoutViewUpdateList.setSizeSmall();
        } else {
            this.setSizeBig();
            this.mContext.mLayoutPresenterSideMenu.setSideSizeBig();
            this.mLayoutViewUpdateList.setSizeBig();
        }
    }

    @Override
    public void present(Pane parentView) {
        super.present(parentView);
        this.displayUpdates();
    }

    public void presentStartedUpdates(Pane parentView) {
        super.present(parentView);
        this.displayStartedUpdates();
    }

    public void presentStartedExtract(Pane parentView, ElinchromDevice elinchromDevice) {
        super.present(parentView);
        this.presentStartedExtract(elinchromDevice);
    }
}

