/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.BridgeDevice;
import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.SortedDeviceItem;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewChannel
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public boolean mIsFirmwareUpdate = false;
    public GridPane mViewBridge = null;
    public GridPane mViewStudioControlNoBridge = null;
    public GridPane mViewStudioControlHasBridge = null;
    public GridPane mViewFirmwareUpdateNoBridge = null;
    public GridPane mViewFirmwareUpdateHasBridge = null;
    public ComboBox<String> mChoiceChannelStudioControl = null;
    public ComboBox<String> mChoiceChannelFirmwareUpdateHasBridge = null;
    public ComboBox<String> mChoiceChannelFirmwareUpdateNoBridge = null;
    public Text mTextBoxBridgeName = null;
    public TextFlow mTextContainerBridgeName = null;
    public LayoutWidgetIcon mBridgeConnectionIcon = null;
    public LayoutWidgetIcon mIconSignal = null;
    public LayoutWidgetIcon mBridgeBatteryIcon = null;
    public LayoutWidgetIcon mButtonFindUnitsNoBridge = null;
    public LayoutWidgetIcon mButtonFindUnitsHasBridge = null;
    public ImageView mImageBridge = null;
    public Text mTextBoxUnitIdValue = null;
    public Pane mUnitIdContainer = null;
    public Text mTextBoxFirmwareStatus = null;
    public LayoutWidgetIcon mFirmwareMark = null;
    public TextFlow mTextContainerFirmwareStatus = null;
    public LayoutWidgetIcon mIconArrowLeft = null;
    public LayoutWidgetIcon mIconArrowRight = null;
    public LayoutWidgetIcon mButtonTabStudioControl = null;
    public LayoutWidgetIcon mButtonTabFirmwareUpdate = null;
    public LayoutWidgetIcon mToolbarButtonDetect = null;

    public LayoutViewChannel(Context context) {
        this.mContext = context;
    }

    public void displayBridgeList() {
        this.mContext.mLogger.log("displayBridgeList count: " + this.mContext.mSortedBridges.size());
        boolean hasPrevious = false;
        boolean hasNext = false;
        boolean isAfter = false;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedBridges) {
            if (this.mContext.mLayoutPresenterChannel.mBridgeDevice != null && this.mContext.mLayoutPresenterChannel.mBridgeDevice.equals(sortedDeviceItem.mSortedDevice)) {
                isAfter = true;
                continue;
            }
            if (isAfter) {
                hasNext = true;
                continue;
            }
            hasPrevious = true;
        }
        this.mIconArrowLeft.setIndex(hasPrevious ? 1 : 0);
        this.mIconArrowRight.setIndex(hasNext ? 1 : 0);
    }

    protected void displayDetectButton(boolean isDetectButtonVisible) {
        if (this.mToolbarButtonDetect != null) {
            this.mToolbarButtonDetect.setVisible(isDetectButtonVisible);
        }
    }

    public void displayBridgeFirmwareStatus(boolean isFirmwareVersionLatest, boolean isInternetAvailable) {
        this.mTextBoxFirmwareStatus.setText(isInternetAvailable ? "Your firmware is up to date" : "No Internet");
        this.mFirmwareMark.setVisible(isInternetAvailable && !isFirmwareVersionLatest);
        this.mTextBoxFirmwareStatus.setVisible(!isInternetAvailable || isFirmwareVersionLatest);
    }

    public void displayFirmwareUpdateNoBridge() {
        this.mIsFirmwareUpdate = true;
        this.hideAll();
        this.displayDetectButton(true);
        this.mButtonTabFirmwareUpdate.setBackgroundTint("FFFFFF");
        this.mViewFirmwareUpdateNoBridge.setVisible(true);
    }

    public void displayFirmwareUpdateHasBridge() {
        this.mIsFirmwareUpdate = true;
        this.hideAll();
        this.displayDetectButton(true);
        this.mButtonTabFirmwareUpdate.setBackgroundTint("FFFFFF");
        this.onValueChangedChannelFirmwareUpdateHasBridge(null);
        this.mViewFirmwareUpdateHasBridge.setVisible(true);
    }

    public void displayHasBridge() {
        if (this.mIsFirmwareUpdate) {
            this.displayFirmwareUpdateHasBridge();
        } else {
            this.displayStudioControlHasBridge();
        }
    }

    public void displayNoBridge() {
        if (this.mIsFirmwareUpdate) {
            this.displayFirmwareUpdateNoBridge();
        } else {
            this.displayStudioControlNoBridge();
        }
    }

    public void displaySkyportChannel(int channel) {
        int selectedChannelForStudioControl = Math.max(1, Math.min(channel, 20));
        int selectedChannelForFirmwareUpdate = Math.max(0, Math.min(channel, 20));
        this.mChoiceChannelStudioControl.getSelectionModel().select(selectedChannelForStudioControl - 1);
        this.mChoiceChannelFirmwareUpdateHasBridge.getSelectionModel().select(selectedChannelForFirmwareUpdate);
    }

    public void displaySignalStrength(int signalStrength) {
        int previousIndex = this.mIconSignal.getIndex();
        int newIndex = signalStrength < (previousIndex == 0 ? 30 : 20) ? 0 : (signalStrength < (previousIndex == 1 ? 55 : 45) ? 1 : (signalStrength < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mIconSignal.setIndex(newIndex);
        }
    }

    public void displayBatteryLevel(int batteryLevel) {
        int previousIndex = this.mBridgeBatteryIcon.getIndex();
        int newIndex = batteryLevel < (previousIndex == 0 ? 30 : 20) ? 0 : (batteryLevel < (previousIndex == 1 ? 55 : 45) ? 1 : (batteryLevel < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mBridgeBatteryIcon.setIndex(newIndex);
        }
        this.mBridgeBatteryIcon.setVisible(true);
    }

    public void displayStudioControlNoBridge() {
        this.mIsFirmwareUpdate = false;
        this.hideAll();
        this.mButtonTabStudioControl.setBackgroundTint("FFFFFF");
        this.mViewStudioControlNoBridge.setVisible(true);
    }

    public void displayStudioControlHasBridge() {
        this.mIsFirmwareUpdate = false;
        this.hideAll();
        this.displayDetectButton(true);
        this.mButtonTabStudioControl.setBackgroundTint("FFFFFF");
        this.mViewStudioControlHasBridge.getChildren().add((Object)this.mViewBridge);
        this.mViewStudioControlHasBridge.setVisible(true);
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    public void hideAll() {
        this.initIfNeeded();
        this.displayDetectButton(false);
        this.mButtonTabStudioControl.setBackgroundTint("707070");
        this.mButtonTabFirmwareUpdate.setBackgroundTint("707070");
        this.mViewStudioControlNoBridge.setVisible(false);
        this.mViewStudioControlHasBridge.setVisible(false);
        this.mViewStudioControlHasBridge.getChildren().remove((Object)this.mViewBridge);
        this.mViewFirmwareUpdateNoBridge.setVisible(false);
        this.mViewFirmwareUpdateHasBridge.setVisible(false);
        this.mViewFirmwareUpdateHasBridge.getChildren().remove((Object)this.mViewBridge);
    }

    @Override
    public void init() {
        ColumnConstraints column100 = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        column100.setPercentWidth(100.0);
        RowConstraints row100 = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row100.setPercentHeight(100.0);
        Pane bridgeContainer = new Pane();
        bridgeContainer.setPrefSize(240.0, 154.0);
        bridgeContainer.setStyle("-fx-background-color:#FFFFFF;-fx-background-insets:0px;-fx-background-radius:3px 3px;");
        GridPane.setConstraints((Node)bridgeContainer, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mTextBoxBridgeName = new Text("");
        this.mTextBoxBridgeName.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextBoxBridgeName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mTextContainerBridgeName = new TextFlow();
        this.mTextContainerBridgeName.setPrefHeight(45.0);
        this.mTextContainerBridgeName.getChildren().add((Object)this.mTextBoxBridgeName);
        this.mContext.mUtil.setTextBaseline(this.mTextContainerBridgeName, this.mTextBoxBridgeName, 25.0);
        GridPane.setConstraints((Node)this.mTextContainerBridgeName, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        List<String> imageConnection = Arrays.asList("day_connection_usb.svg", "day_connection_ble.svg");
        this.mBridgeConnectionIcon = this.mContext.mUtil.factoryIconSet(24, 24, imageConnection, 0);
        this.mBridgeConnectionIcon.setTranslateX(-99.0);
        this.mBridgeConnectionIcon.setTranslateY(56.0);
        GridPane.setConstraints((Node)this.mBridgeConnectionIcon, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        List<String> imageSignal = Arrays.asList("day_signal_0.svg", "day_signal_1.svg", "day_signal_2.svg", "day_signal_3.svg");
        this.mIconSignal = this.mContext.mUtil.factoryIconSet(24, 24, imageSignal, 0);
        this.mIconSignal.setTranslateX(-73.0);
        this.mIconSignal.setTranslateY(56.0);
        GridPane.setConstraints((Node)this.mIconSignal, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        List<String> imageBattery = Arrays.asList("day_battery_0.svg", "day_battery_1.svg", "day_battery_2.svg", "day_battery_3.svg");
        this.mBridgeBatteryIcon = this.mContext.mUtil.factoryIconSet(24, 24, imageBattery, 0);
        this.mBridgeBatteryIcon.setTranslateX(-73.0);
        this.mBridgeBatteryIcon.setTranslateY(81.0);
        GridPane.setConstraints((Node)this.mBridgeBatteryIcon, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mImageBridge = new ImageView();
        this.mImageBridge.setFitWidth(100.0);
        this.mImageBridge.setFitHeight(100.0);
        this.mImageBridge.setPreserveRatio(true);
        this.mImageBridge.setSmooth(true);
        this.mImageBridge.setTranslateY(31.0);
        GridPane.setConstraints((Node)this.mImageBridge, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Text textBoxUnitIdLabel = new Text("Unit ID");
        textBoxUnitIdLabel.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        textBoxUnitIdLabel.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow textContainerUnitIdLabel = new TextFlow();
        textContainerUnitIdLabel.setPrefHeight(50.0);
        textContainerUnitIdLabel.getChildren().add((Object)textBoxUnitIdLabel);
        this.mContext.mUtil.setTextBaseline(textContainerUnitIdLabel, textBoxUnitIdLabel, 30.0);
        this.mTextBoxUnitIdValue = new Text("");
        this.mTextBoxUnitIdValue.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextBoxUnitIdValue.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow textContainerUnitIdValue = new TextFlow();
        textContainerUnitIdValue.setPrefHeight(50.0);
        textContainerUnitIdValue.getChildren().add((Object)this.mTextBoxUnitIdValue);
        this.mContext.mUtil.setTextBaseline(textContainerUnitIdValue, this.mTextBoxUnitIdValue, 55.0);
        this.mUnitIdContainer = new Pane();
        this.mUnitIdContainer.setPrefSize(50.0, 75.0);
        this.mUnitIdContainer.setTranslateX(88.0);
        this.mUnitIdContainer.setTranslateY(43.0);
        this.mUnitIdContainer.getChildren().addAll((Object[])new Node[]{textContainerUnitIdLabel, textContainerUnitIdValue});
        GridPane.setConstraints((Node)this.mUnitIdContainer, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mTextBoxFirmwareStatus = new Text(this.mContext.mIsInternetAvailable ? "Your firmware is up to date" : "No Internet");
        this.mTextBoxFirmwareStatus.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextBoxFirmwareStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        this.mTextContainerFirmwareStatus = new TextFlow();
        this.mTextContainerFirmwareStatus.setPrefHeight(50.0);
        this.mTextContainerFirmwareStatus.getChildren().add((Object)this.mTextBoxFirmwareStatus);
        GridPane.setConstraints((Node)this.mTextContainerFirmwareStatus, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(141.0 - this.mTextBoxFirmwareStatus.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mFirmwareMark = new LayoutWidgetIcon(this.mContext, -1.0, 50.0, null, "firmware_mark.svg", 3.5, "A new firmware is available", 16.0, this.mContext.mFontRegular, 10.5, this.mContext.mDayActivatedColor);
        this.mFirmwareMark.setOnMouseClicked(this::onTouchFirmwareStatus);
        GridPane.setConstraints((Node)this.mFirmwareMark, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(111.0, 0.0, 0.0, 0.0));
        List<String> imageArrowLeft = Arrays.asList("night_arrow_left_disabled.svg", "night_arrow_left_activated.svg");
        this.mIconArrowLeft = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowLeft, 0);
        this.mIconArrowLeft.setTranslateX(-189.0);
        this.mIconArrowLeft.setTranslateY(67.0);
        this.mIconArrowLeft.setOnMouseClicked(this::onTouchBridgePrevious);
        GridPane.setConstraints((Node)this.mIconArrowLeft, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        List<String> imageArrowRight = Arrays.asList("night_arrow_right_disabled.svg", "night_arrow_right_activated.svg");
        this.mIconArrowRight = this.mContext.mUtil.factoryIconSet(22, 22, imageArrowRight, 0);
        this.mIconArrowRight.setTranslateX(189.0);
        this.mIconArrowRight.setTranslateY(67.0);
        this.mIconArrowRight.setOnMouseClicked(this::onTouchBridgeNext);
        GridPane.setConstraints((Node)this.mIconArrowRight, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mViewBridge = new GridPane();
        this.mViewBridge.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewBridge.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        this.mViewBridge.getChildren().addAll((Object[])new Node[]{bridgeContainer, this.mTextContainerBridgeName, this.mBridgeConnectionIcon, this.mIconSignal, this.mBridgeBatteryIcon, this.mImageBridge, this.mUnitIdContainer, this.mTextContainerFirmwareStatus, this.mFirmwareMark, this.mIconArrowLeft, this.mIconArrowRight});
        GridPane.setConstraints((Node)this.mViewBridge, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        Text textNoSceneTitle = new Text("No bridge module found");
        textNoSceneTitle.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textNoSceneTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 21.0));
        TextFlow boxNoSceneTitle = new TextFlow();
        boxNoSceneTitle.getChildren().add((Object)textNoSceneTitle);
        GridPane.setConstraints((Node)boxNoSceneTitle, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(94.0 - textNoSceneTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
        Pane lineSpacer = new Pane();
        lineSpacer.setPrefSize(540.0, 1.0);
        lineSpacer.setStyle("-fx-background-color:rgb(51,54,59);");
        GridPane.setConstraints((Node)lineSpacer, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(126.0, 0.0, 0.0, 0.0));
        Text textNoSceneBody = new Text("Turn on Bluetooth and the bridge module, then press the Detect button");
        textNoSceneBody.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textNoSceneBody.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxNoSceneBody = new TextFlow();
        boxNoSceneBody.getChildren().add((Object)textNoSceneBody);
        GridPane.setConstraints((Node)boxNoSceneBody, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(169.0 - textNoSceneBody.getBaselineOffset(), 0.0, 0.0, 0.0));
        LayoutWidgetIcon buttonDetect = this.mContext.mUtil.factoryButton(90, 32, "background_button_green_narrow.svg", null, 0.0, "Detect", 24, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonDetect.setOnMouseClicked(this::onTouchDetect);
        GridPane.setConstraints((Node)buttonDetect, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(95.0, 0.0, 0.0, 0.0));
        this.mViewStudioControlNoBridge = new GridPane();
        this.mViewStudioControlNoBridge.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewStudioControlNoBridge.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        this.mViewStudioControlNoBridge.getChildren().addAll((Object[])new Node[]{boxNoSceneTitle, lineSpacer, boxNoSceneBody, buttonDetect});
        GridPane.setFillHeight((Node)this.mViewStudioControlNoBridge, (Boolean)true);
        GridPane.setConstraints((Node)this.mViewStudioControlNoBridge, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        RowConstraints rowTitle = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTitle.setPercentHeight(19.0);
        RowConstraints rowChannel = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowChannel.setPercentHeight(21.0);
        RowConstraints rowBridges = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.BOTTOM, false);
        rowBridges.setPercentHeight(42.0);
        RowConstraints rowButton = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.BOTTOM, false);
        rowButton.setPercentHeight(18.0);
        Text labelStudioTitle = new Text("Skyport channel");
        labelStudioTitle.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        labelStudioTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 28.0));
        TextFlow boxStudioTitle = new TextFlow();
        boxStudioTitle.getChildren().add((Object)labelStudioTitle);
        GridPane.setConstraints((Node)boxStudioTitle, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - labelStudioTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mChoiceChannelStudioControl = new ComboBox();
        this.mChoiceChannelStudioControl.getItems().addAll((Collection)IntStream.rangeClosed(1, 20).mapToObj(Integer::toString).collect(Collectors.toList()));
        this.mChoiceChannelStudioControl.setPrefSize(112.0, 32.0);
        this.mChoiceChannelStudioControl.getStyleClass().add((Object)"rounded");
        this.mChoiceChannelStudioControl.getSelectionModel().select(0);
        GridPane.setConstraints(this.mChoiceChannelStudioControl, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        LayoutWidgetIcon buttonScan = new LayoutWidgetIcon(this.mContext, 90.0, 32.0, "background_button_green_narrow.svg", "Scan", this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonScan.setOnMouseClicked(this::onTouchScan);
        GridPane.setConstraints((Node)buttonScan, (int)0, (int)3, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        this.mViewStudioControlHasBridge = new GridPane();
        this.mViewStudioControlHasBridge.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewStudioControlHasBridge.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTitle, rowChannel, rowBridges, rowButton});
        this.mViewStudioControlHasBridge.getChildren().addAll((Object[])new Node[]{boxStudioTitle, this.mChoiceChannelStudioControl, this.mViewBridge, buttonScan});
        GridPane.setFillHeight((Node)this.mViewStudioControlHasBridge, (Boolean)true);
        GridPane.setConstraints((Node)this.mViewStudioControlHasBridge, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        Text labelUpdateTitleNoBridge = new Text("Skyport channel");
        labelUpdateTitleNoBridge.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        labelUpdateTitleNoBridge.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 28.0));
        TextFlow boxUpdateTitleNoBridge = new TextFlow();
        boxUpdateTitleNoBridge.getChildren().add((Object)labelUpdateTitleNoBridge);
        GridPane.setConstraints((Node)boxUpdateTitleNoBridge, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - labelUpdateTitleNoBridge.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mChoiceChannelFirmwareUpdateNoBridge = new ComboBox();
        this.mChoiceChannelFirmwareUpdateNoBridge.getItems().add((Object)"USB only");
        this.mChoiceChannelFirmwareUpdateNoBridge.setPrefSize(112.0, 32.0);
        this.mChoiceChannelFirmwareUpdateNoBridge.getStyleClass().add((Object)"rounded");
        this.mChoiceChannelFirmwareUpdateNoBridge.getSelectionModel().select(0);
        GridPane.setConstraints(this.mChoiceChannelFirmwareUpdateNoBridge, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        this.mButtonFindUnitsNoBridge = new LayoutWidgetIcon(this.mContext, 134.0, 32.0, "background_button_green_wide.svg", "Find units", this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonFindUnitsNoBridge.setOnMouseClicked(this::onTouchFindUnitsNoBridge);
        GridPane.setConstraints((Node)this.mButtonFindUnitsNoBridge, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER);
        this.mViewFirmwareUpdateNoBridge = new GridPane();
        this.mViewFirmwareUpdateNoBridge.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewFirmwareUpdateNoBridge.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTitle, rowChannel, rowBridges, rowButton});
        this.mViewFirmwareUpdateNoBridge.getChildren().addAll((Object[])new Node[]{boxUpdateTitleNoBridge, this.mChoiceChannelFirmwareUpdateNoBridge, this.mButtonFindUnitsNoBridge});
        GridPane.setFillHeight((Node)this.mViewFirmwareUpdateNoBridge, (Boolean)true);
        GridPane.setConstraints((Node)this.mViewFirmwareUpdateNoBridge, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        Text labelUpdateTitleHasBridge = new Text("Skyport channel");
        labelUpdateTitleHasBridge.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        labelUpdateTitleHasBridge.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 28.0));
        TextFlow boxUpdateTitleHasBridge = new TextFlow();
        boxUpdateTitleHasBridge.getChildren().add((Object)labelUpdateTitleHasBridge);
        GridPane.setConstraints((Node)boxUpdateTitleHasBridge, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(30.0 - labelUpdateTitleHasBridge.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mChoiceChannelFirmwareUpdateHasBridge = new ComboBox();
        this.mChoiceChannelFirmwareUpdateHasBridge.getItems().add((Object)"USB only");
        this.mChoiceChannelFirmwareUpdateHasBridge.getItems().addAll((Collection)IntStream.rangeClosed(1, 20).mapToObj(Integer::toString).collect(Collectors.toList()));
        this.mChoiceChannelFirmwareUpdateHasBridge.setPrefSize(112.0, 32.0);
        this.mChoiceChannelFirmwareUpdateHasBridge.getStyleClass().add((Object)"rounded");
        this.mChoiceChannelFirmwareUpdateHasBridge.getSelectionModel().select(1);
        this.mChoiceChannelFirmwareUpdateHasBridge.setOnAction(this::onValueChangedChannelFirmwareUpdateHasBridge);
        GridPane.setConstraints(this.mChoiceChannelFirmwareUpdateHasBridge, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        this.mButtonFindUnitsHasBridge = new LayoutWidgetIcon(this.mContext, 134.0, 32.0, "background_button_green_wide.svg", "Find units", this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonFindUnitsHasBridge.setOnMouseClicked(this::onTouchFindUnitsHasBridge);
        GridPane.setConstraints((Node)this.mButtonFindUnitsHasBridge, (int)0, (int)3, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
        this.mViewFirmwareUpdateHasBridge = new GridPane();
        this.mViewFirmwareUpdateHasBridge.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column100});
        this.mViewFirmwareUpdateHasBridge.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTitle, rowChannel, rowBridges, rowButton});
        this.mViewFirmwareUpdateHasBridge.getChildren().addAll((Object[])new Node[]{boxUpdateTitleHasBridge, this.mChoiceChannelFirmwareUpdateHasBridge, this.mButtonFindUnitsHasBridge});
        GridPane.setFillHeight((Node)this.mViewFirmwareUpdateHasBridge, (Boolean)true);
        GridPane.setConstraints((Node)this.mViewFirmwareUpdateHasBridge, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTop.setPercentHeight(28.0);
        RowConstraints rowMiddle = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowMiddle.setPercentHeight(47.0);
        RowConstraints rowBottom = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.BOTTOM, false);
        rowBottom.setPercentHeight(25.0);
        this.mToolbarButtonDetect = new LayoutWidgetIcon(this.mContext, 50.0, "Detect", this.mContext.mFontRegular, 14.0, this.mContext.mNightActivatedColor);
        this.mToolbarButtonDetect.setOnMouseClicked(this::onTouchDetect);
        this.mToolbarButtonDetect.setVisible(false);
        GridPane.setConstraints((Node)this.mToolbarButtonDetect, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        Parent logo = this.mContext.mUtil.loadImageNode("night_logo_display.svg");
        logo.setTranslateY(72.0);
        GridPane.setConstraints((Node)logo, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        HashMap<String, String> imageTabs = new HashMap<String, String>();
        imageTabs.put("707070", "night_background_tab_enabled.svg");
        imageTabs.put("FFFFFF", "night_background_tab_activated.svg");
        this.mButtonTabStudioControl = this.mContext.mUtil.factoryButton(312, 50, imageTabs, "Studio control", this.mContext.mFontRegular, 28.0, "FFFFFF");
        this.mButtonTabStudioControl.setTranslateX(-181.0);
        this.mButtonTabStudioControl.setTranslateY(178.0);
        this.mButtonTabStudioControl.setOnMouseClicked(this::onTouchTabStudioControl);
        GridPane.setConstraints((Node)this.mButtonTabStudioControl, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mButtonTabFirmwareUpdate = this.mContext.mUtil.factoryButton(312, 50, imageTabs, "Firmware update", this.mContext.mFontRegular, 28.0, "707070");
        this.mButtonTabFirmwareUpdate.setTranslateX(181.0);
        this.mButtonTabFirmwareUpdate.setTranslateY(178.0);
        this.mButtonTabFirmwareUpdate.setOnMouseClicked(this::onTouchTabFirmwareUpdate);
        GridPane.setConstraints((Node)this.mButtonTabFirmwareUpdate, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Parent imageWaves = this.mContext.mUtil.loadImageNode("waves.svg");
        GridPane.setConstraints((Node)imageWaves, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonFeedback = new LayoutWidgetIcon(this.mContext, 50.0, "Feedback", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonFeedback.setOnMouseClicked(this::onTouchFeedback);
        GridPane.setConstraints((Node)buttonFeedback, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        Text textBoxNote = new Text("Only normal Skyport sync mode is supported.");
        textBoxNote.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textBoxNote.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow textContainerNote = new TextFlow();
        textContainerNote.setPrefHeight(50.0);
        textContainerNote.getChildren().add((Object)textBoxNote);
        this.mContext.mUtil.setTextBaseline(textContainerNote, textBoxNote, 30.0);
        GridPane.setConstraints((Node)textContainerNote, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonPrivacy = new LayoutWidgetIcon(this.mContext, 50.0, "Privacy", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonPrivacy.setOnMouseClicked(this::onTouchPrivacy);
        GridPane.setConstraints((Node)buttonPrivacy, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.getStyleClass().add((Object)"night-theme");
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowMiddle, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mToolbarButtonDetect, logo, this.mButtonTabStudioControl, this.mButtonTabFirmwareUpdate, this.mViewStudioControlNoBridge, this.mViewStudioControlHasBridge, this.mViewFirmwareUpdateNoBridge, this.mViewFirmwareUpdateHasBridge, imageWaves, buttonFeedback, textContainerNote, buttonPrivacy});
        StackPane.setAlignment((Node)this, (Pos)Pos.TOP_CENTER);
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchBridgeNext(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.bridgeNext();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchBridgePrevious(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.bridgePrevious();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchDetect(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onDetect();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFeedback(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onFeedback();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFindUnitsHasBridge(MouseEvent event) {
        try {
            int channelIndex = this.mChoiceChannelFirmwareUpdateHasBridge.getSelectionModel().getSelectedIndex();
            this.mContext.mLayoutPresenterChannel.onFindUnits(channelIndex);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFindUnitsNoBridge(MouseEvent event) {
        try {
            int channelIndex = this.mChoiceChannelFirmwareUpdateNoBridge.getSelectionModel().getSelectedIndex();
            this.mContext.mLayoutPresenterChannel.onFindUnits(channelIndex);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchFirmwareStatus(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onFirmwareStatus();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabFirmwareUpdate(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onTabFirmwareUpdate();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPrivacy(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onPrivacy();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchScan(MouseEvent event) {
        try {
            int channelIndex = this.mChoiceChannelStudioControl.getSelectionModel().getSelectedIndex();
            this.mContext.mLayoutPresenterChannel.onScan(channelIndex);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabStudioControl(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterChannel.onTabStudioControl();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onValueChangedChannelFirmwareUpdateHasBridge(ActionEvent event) {
        try {
            boolean isUsbOnly;
            this.mViewFirmwareUpdateHasBridge.getChildren().removeAll((Object[])new Node[]{this.mViewBridge, this.mButtonFindUnitsHasBridge});
            boolean bl = isUsbOnly = this.mChoiceChannelFirmwareUpdateHasBridge.getSelectionModel().getSelectedIndex() == 0;
            if (isUsbOnly) {
                GridPane.setConstraints((Node)this.mButtonFindUnitsHasBridge, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                this.mViewFirmwareUpdateHasBridge.getChildren().addAll((Object[])new Node[]{this.mButtonFindUnitsHasBridge});
            } else {
                GridPane.setConstraints((Node)this.mButtonFindUnitsHasBridge, (int)0, (int)3, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(9.0, 0.0, 0.0, 0.0));
                this.mViewFirmwareUpdateHasBridge.getChildren().addAll((Object[])new Node[]{this.mViewBridge, this.mButtonFindUnitsHasBridge});
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void setBridgeDevice(BridgeDevice bridgeDevice) {
        Unit_Prototype_Json unit_Prototype_Json = this.mContext.mUnitPrototypes.get(bridgeDevice.mElinchromDevice.getProductId());
        if (unit_Prototype_Json != null) {
            try {
                URL url = new File(this.mContext.mFolderImages + unit_Prototype_Json.getImage_URL()).toURI().toURL();
                this.mImageBridge.setImage(new Image(url.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                this.mContext.mLogger.printStackTrace(malformedURLException);
            }
        }
        this.mTextBoxBridgeName.setText(bridgeDevice.mElinchromDevice.getProductName());
        this.mTextBoxUnitIdValue.setText(bridgeDevice.mElinchromDevice.getSkyportId());
        this.mBridgeConnectionIcon.setIndex(bridgeDevice.getConnectionType() == 2 ? 1 : 0);
        this.mIconSignal.setIndex(3);
        this.mBridgeBatteryIcon.setVisible(false);
        this.mTextBoxFirmwareStatus.setText("");
        this.mFirmwareMark.setVisible(false);
        this.displayBridgeList();
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        this.setPrefHeight(945.0);
        this.setMaxHeight(945.0);
    }

    public void setSizeBig() {
        this.setPrefHeight(-1.0);
        this.setMaxHeight(Double.MAX_VALUE);
    }
}

