/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.LayoutWidgetProgressBar;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewChannelProgress
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public Text mProgressTitle = null;
    public LayoutWidgetProgressBar mLayoutWidgetProgressBar = null;
    public LayoutWidgetIcon mButtonFeedback = null;
    public LayoutWidgetIcon mButtonPrivacy = null;

    public LayoutViewChannelProgress(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTop.setPercentHeight(28.0);
        RowConstraints rowTitle = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTitle.setPercentHeight(47.0);
        RowConstraints rowBottom = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowBottom.setPercentHeight(25.0);
        this.mProgressTitle = new Text("Downloading");
        this.mProgressTitle.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mProgressTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 21.0));
        TextFlow boxProgressTitle = new TextFlow();
        boxProgressTitle.getChildren().add((Object)this.mProgressTitle);
        this.mContext.mUtil.setTextBaseline(boxProgressTitle, this.mProgressTitle, 108.0);
        GridPane.setConstraints((Node)boxProgressTitle, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mLayoutWidgetProgressBar = new LayoutWidgetProgressBar(this.mContext, 0.0f, 4.0f, 687, 4, this.mContext.mColorGroup[4]);
        this.mLayoutWidgetProgressBar.setTranslateY(212.0);
        GridPane.setConstraints((Node)this.mLayoutWidgetProgressBar, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Parent imageWaves = this.mContext.mUtil.loadImageNode("waves.svg");
        GridPane.setConstraints((Node)imageWaves, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        this.mButtonFeedback = new LayoutWidgetIcon(this.mContext, 50.0, "Feedback", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        this.mButtonFeedback.setOnMouseClicked(this::onTouchFeedback);
        GridPane.setConstraints((Node)this.mButtonFeedback, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        this.mButtonPrivacy = new LayoutWidgetIcon(this.mContext, 50.0, "Privacy", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        this.mButtonPrivacy.setOnMouseClicked(this::onTouchPrivacy);
        GridPane.setConstraints((Node)this.mButtonPrivacy, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowTitle, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{boxProgressTitle, this.mLayoutWidgetProgressBar, imageWaves, this.mButtonFeedback, this.mButtonPrivacy});
        this.mProgressTitle.setVisible(false);
        this.mLayoutWidgetProgressBar.setVisible(false);
        this.mButtonFeedback.setVisible(false);
        this.mButtonPrivacy.setVisible(false);
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchFeedback(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterChannel.onFeedback();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPrivacy(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterChannel.onPrivacy();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setProgressTitle(String progressTitle) {
        this.mProgressTitle.setText(progressTitle);
    }

    public void showProgress() {
        this.mProgressTitle.setVisible(true);
        this.mLayoutWidgetProgressBar.setVisible(true);
        this.mButtonFeedback.setVisible(true);
        this.mButtonPrivacy.setVisible(true);
    }
}

