/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import java.util.HashMap;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewHelp
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public LayoutWidgetIcon mTabHelpUpdate = null;
    public LayoutWidgetIcon mTabHelpLinks = null;
    public StackPane mLayoutNodeDisplayMain = null;
    public StackPane mLayoutNodeDisplayLeft = null;
    public StackPane mLayoutNodeDisplayRight = null;

    public LayoutViewHelp(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    public void displayHelpUpdate() {
        this.mTabHelpUpdate.setBackgroundTint("FFFFFF");
        this.mTabHelpLinks.setBackgroundTint("707070");
        this.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutNodeDisplayRight.getChildren().clear();
    }

    public void displayHelpLinks() {
        this.mTabHelpUpdate.setBackgroundTint("707070");
        this.mTabHelpLinks.setBackgroundTint("FFFFFF");
        this.mLayoutNodeDisplayMain.getChildren().clear();
        this.mLayoutNodeDisplayLeft.getChildren().clear();
        this.mLayoutNodeDisplayRight.getChildren().clear();
    }

    @Override
    public void init() {
        GridPane.setFillHeight((Node)this, (Boolean)true);
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints(136.0, 136.0, 136.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowMiddle = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
        RowConstraints rowBottom = new RowConstraints(65.0, 65.0, 65.0, Priority.NEVER, VPos.BOTTOM, false);
        HashMap<String, String> imageTabs = new HashMap<String, String>();
        imageTabs.put("707070", "night_background_tab_enabled.svg");
        imageTabs.put("FFFFFF", "night_background_tab_activated.svg");
        this.mTabHelpUpdate = this.mContext.mUtil.factoryButton(312, 50, imageTabs, "Firmware update", this.mContext.mFontRegular, 28.0, "FFFFFF");
        this.mTabHelpUpdate.setTranslateX(-181.0);
        this.mTabHelpUpdate.setOnMouseClicked(this::onTouchTabHelpUpdate);
        GridPane.setConstraints((Node)this.mTabHelpUpdate, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(34.0, 0.0, 0.0, 0.0));
        this.mTabHelpLinks = this.mContext.mUtil.factoryButton(312, 50, imageTabs, "Support links", this.mContext.mFontRegular, 28.0, "707070");
        this.mTabHelpLinks.setTranslateX(181.0);
        this.mTabHelpLinks.setOnMouseClicked(this::onTouchTabHelpLinks);
        GridPane.setConstraints((Node)this.mTabHelpLinks, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(34.0, 0.0, 0.0, 0.0));
        this.mLayoutNodeDisplayMain = new StackPane();
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayMain, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayMain, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayMain, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        this.mLayoutNodeDisplayLeft = new StackPane();
        this.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayLeft, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayLeft, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayLeft, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        this.mLayoutNodeDisplayRight = new StackPane();
        this.mLayoutNodeDisplayRight.setMouseTransparent(true);
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayRight, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayRight, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayRight, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        LayoutWidgetIcon buttonFeedback = new LayoutWidgetIcon(this.mContext, 50.0, "Feedback", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonFeedback.setOnMouseClicked(this::onTouchFeedback);
        GridPane.setConstraints((Node)buttonFeedback, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        Text textBoxNote = new Text("Elinchrom Studio 2.0 build 1317");
        textBoxNote.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textBoxNote.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow textContainerNote = new TextFlow();
        textContainerNote.setPrefHeight(50.0);
        textContainerNote.getChildren().add((Object)textBoxNote);
        this.mContext.mUtil.setTextBaseline(textContainerNote, textBoxNote, 30.0);
        GridPane.setConstraints((Node)textContainerNote, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonPrivacy = new LayoutWidgetIcon(this.mContext, 50.0, "Privacy", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonPrivacy.setOnMouseClicked(this::onTouchPrivacy);
        GridPane.setConstraints((Node)buttonPrivacy, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowMiddle, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mTabHelpUpdate, this.mTabHelpLinks, this.mLayoutNodeDisplayMain, this.mLayoutNodeDisplayLeft, this.mLayoutNodeDisplayRight, buttonFeedback, textContainerNote, buttonPrivacy});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchFeedback(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onFeedback();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPrivacy(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onPrivacy();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabHelpUpdate(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterHelp.onTabHelpUpdate();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchTabHelpLinks(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterHelp.onTabHelpLinks();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

