/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.JsonHelpFirmwareUpdateText;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutViewHelpUpdateListItem;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewHelpUpdateDetail
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public ScrollPane mHelpUpdateDetailScrollView = null;
    public GridPane mScrollContentPane = null;
    public ImageView mImageProduct = null;
    public ImageView mHelpUpdateImage = null;
    public Text mTextProductName = null;
    public Text mTextReleaseNote = null;
    public Text mHelpUpdateTitle = null;
    public Text mHelpUpdateText = null;
    public String mReleaseNoteUrl = null;
    public String mUpdateModeFaqUrl = null;

    public LayoutViewHelpUpdateDetail(Context context) {
        this.mContext = context;
    }

    public void displayHelpUpdateListItem(LayoutViewHelpUpdateListItem layoutViewHelpUpdateListItem) {
        URL url = null;
        this.mReleaseNoteUrl = layoutViewHelpUpdateListItem.mJsonNewsFirmware.release_note_url;
        this.mUpdateModeFaqUrl = layoutViewHelpUpdateListItem.mJsonHelpContents.update_mode_faq_url;
        this.mTextProductName.setText(layoutViewHelpUpdateListItem.mJsonHelpFirmwareUpdate.title_of_help_item);
        this.mHelpUpdateTitle.setText(layoutViewHelpUpdateListItem.mJsonHelpContents.update_mode_title);
        for (JsonHelpFirmwareUpdateText jsonHelpFirmwareUpdateText : layoutViewHelpUpdateListItem.mJsonHelpContents.update_mode_texts) {
            if (!Arrays.asList(jsonHelpFirmwareUpdateText.operationg_systems).contains(this.mContext.mUtil.isWindows() ? "WINDOWS" : "MACOS")) continue;
            this.mHelpUpdateText.setText(jsonHelpFirmwareUpdateText.update_mode_text);
            break;
        }
        if (!layoutViewHelpUpdateListItem.mJsonHelpContents.update_mode_image_name.equals("")) {
            try {
                url = new File(this.mContext.mFolderImages + layoutViewHelpUpdateListItem.mJsonHelpContents.update_mode_image_name).toURI().toURL();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        if (url != null) {
            this.mHelpUpdateImage.setImage(new Image(url.toString()));
        } else {
            this.mHelpUpdateImage.setImage(null);
        }
        if (layoutViewHelpUpdateListItem.mImageUrl != null) {
            this.mImageProduct.setImage(new Image(layoutViewHelpUpdateListItem.mImageUrl.toString()));
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().addAll((Object[])new String[]{"day-theme"});
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, true);
        column.setPercentWidth(100.0);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row.setPercentHeight(100.0);
        ColumnConstraints columnLeftMargin = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnCenter = new ColumnConstraints(632.0, 632.0, 632.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnRightMargin = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.LEFT, false);
        RowConstraints rowTitle = new RowConstraints(128.0, 128.0, 128.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowNote = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowImage = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowMargin = new RowConstraints(50.0, 50.0, 50.0, Priority.NEVER, VPos.TOP, false);
        this.mImageProduct = new ImageView();
        this.mImageProduct.setFitWidth(100.0);
        this.mImageProduct.setFitHeight(100.0);
        this.mImageProduct.setPreserveRatio(true);
        this.mImageProduct.setSmooth(true);
        GridPane.setConstraints((Node)this.mImageProduct, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM);
        this.mTextProductName = new Text("Transmitter Pro for Canon");
        this.mTextProductName.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextProductName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 28.0));
        TextFlow boxProductName = new TextFlow();
        boxProductName.setTextAlignment(TextAlignment.LEFT);
        boxProductName.setPrefHeight(99.0);
        boxProductName.setMaxHeight(99.0);
        boxProductName.setTranslateX(125.0);
        boxProductName.getChildren().add((Object)this.mTextProductName);
        this.mContext.mUtil.setTextBaseline(boxProductName, this.mTextProductName, 74.0);
        GridPane.setConstraints((Node)boxProductName, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mTextReleaseNote = new Text("Release note");
        this.mTextReleaseNote.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextReleaseNote.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxReleaseNote = new TextFlow();
        boxReleaseNote.setTextAlignment(TextAlignment.LEFT);
        boxReleaseNote.setPrefHeight(128.0);
        boxReleaseNote.setMaxHeight(128.0);
        boxReleaseNote.setTranslateX(125.0);
        boxReleaseNote.getChildren().add((Object)this.mTextReleaseNote);
        boxReleaseNote.setOnMouseClicked(this::onTouchReleaseNote);
        this.mContext.mUtil.setTextBaseline(boxReleaseNote, this.mTextReleaseNote, 99.0);
        GridPane.setConstraints((Node)boxReleaseNote, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mHelpUpdateTitle = new Text("Firmware update using USB");
        this.mHelpUpdateTitle.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mHelpUpdateTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.0));
        TextFlow boxHelpUpdateTitle = new TextFlow();
        boxHelpUpdateTitle.setTextAlignment(TextAlignment.LEFT);
        boxHelpUpdateTitle.setPrefHeight(72.0);
        boxHelpUpdateTitle.setMaxHeight(72.0);
        boxHelpUpdateTitle.getChildren().add((Object)this.mHelpUpdateTitle);
        boxHelpUpdateTitle.setOnMouseClicked(this::onTouchHelpUpdateDescription);
        GridPane.setConstraints((Node)boxHelpUpdateTitle, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(40.0 - this.mHelpUpdateTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mHelpUpdateText = new Text("\u2022 Insert charged batteries into the Transmitter Pro.\n\u2022 Switch the Transmitter Pro OFF and connect it to the computer using a Mini USB cable.\n\u2022 In the Updates screen of the Elinchrom Studio, press the Find units button.\n\u2022 Check the box of the Transmitter Pro and press the Update button.");
        this.mHelpUpdateText.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mHelpUpdateText.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxHelpUpdateText = new TextFlow();
        boxHelpUpdateText.setTextAlignment(TextAlignment.LEFT);
        boxHelpUpdateText.setMinHeight(-1.0);
        boxHelpUpdateText.setPrefHeight(-1.0);
        boxHelpUpdateText.setMaxHeight(Double.MAX_VALUE);
        boxHelpUpdateText.setLineSpacing(25.0 - this.mHelpUpdateText.getFont().getSize() * 1.25);
        boxHelpUpdateText.getChildren().add((Object)this.mHelpUpdateText);
        GridPane.setConstraints((Node)boxHelpUpdateText, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(72.0 - this.mHelpUpdateText.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mHelpUpdateImage = new ImageView();
        this.mHelpUpdateImage.setFitWidth(512.0);
        this.mHelpUpdateImage.setPreserveRatio(true);
        this.mHelpUpdateImage.setSmooth(true);
        this.mHelpUpdateImage.setOnMouseClicked(this::onTouchHelpUpdateDescription);
        GridPane.setConstraints((Node)this.mHelpUpdateImage, (int)2, (int)2, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(25.0, 0.0, 0.0, 0.0));
        this.mScrollContentPane = new GridPane();
        this.mScrollContentPane.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 50px 0px 50px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        this.mScrollContentPane.setMinHeight(-1.0);
        this.mScrollContentPane.setPrefHeight(-1.0);
        this.mScrollContentPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeftMargin, columnLeft, columnCenter, columnRight, columnRightMargin});
        this.mScrollContentPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTitle, rowNote, rowImage, rowMargin});
        this.mScrollContentPane.getChildren().addAll((Object[])new Node[]{this.mImageProduct, boxProductName, boxReleaseNote, boxHelpUpdateTitle, boxHelpUpdateText, this.mHelpUpdateImage});
        GridPane.setConstraints((Node)this.mScrollContentPane, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER);
        this.mHelpUpdateDetailScrollView = new ScrollPane();
        this.mHelpUpdateDetailScrollView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mHelpUpdateDetailScrollView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mHelpUpdateDetailScrollView.setFitToWidth(true);
        this.mHelpUpdateDetailScrollView.setContent((Node)this.mScrollContentPane);
        GridPane.setConstraints((Node)this.mHelpUpdateDetailScrollView, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        GridPane.setFillHeight((Node)this.mHelpUpdateDetailScrollView, (Boolean)true);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchHelpUpdateDescription(MouseEvent event) {
        try {
            this.mContext.mUtil.openWebpage(new URL(this.mUpdateModeFaqUrl));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchReleaseNote(MouseEvent event) {
        try {
            this.mContext.mUtil.openWebpage(new URL(this.mReleaseNoteUrl));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            this.mHelpUpdateDetailScrollView.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView, this.mScrollContentPane});
            this.getChildren().add((Object)this.mScrollContentPane);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView, this.mScrollContentPane});
            this.mHelpUpdateDetailScrollView.setContent((Node)this.mScrollContentPane);
            this.getChildren().add((Object)this.mHelpUpdateDetailScrollView);
        }
    }
}

