/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutViewMessage;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewMessageAgreement
extends LayoutViewMessage {
    public LayoutViewMessageAgreement(Context context) {
        super(context);
        this.mMessageId = 3;
    }

    @Override
    public void init() {
        super.init();
        GridPane displayPane = new GridPane();
        displayPane.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        GridPane.setFillWidth((Node)displayPane, (Boolean)true);
        GridPane.setFillHeight((Node)displayPane, (Boolean)true);
        GridPane.setConstraints((Node)displayPane, (int)1, (int)0);
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTop.setPercentHeight(28.0);
        RowConstraints rowMiddle = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowMiddle.setPercentHeight(47.0);
        RowConstraints rowBottom = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowBottom.setPercentHeight(25.0);
        Parent logo = this.mContext.mUtil.loadImageNode("night_logo_display.svg");
        logo.setTranslateY(72.0);
        GridPane.setConstraints((Node)logo, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Text textBoxTitle = new Text("Help Elinchrom build better lighting gears");
        textBoxTitle.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textBoxTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 28.0));
        TextFlow textContainerTitle = new TextFlow();
        textContainerTitle.setPrefWidth(275.0);
        textContainerTitle.getChildren().add((Object)textBoxTitle);
        this.mContext.mUtil.setTextBaselineAndSpacing(textContainerTitle, textBoxTitle, 65.0, 32.0);
        GridPane.setConstraints((Node)textContainerTitle, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Text textBoxBody = new Text("We collect the state and usage of the products and services, to improve and propose new lighting products and software services that better fits your needs.\n\nYou can withdraw your consent at any time. See our privacy policy for details.");
        textBoxBody.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textBoxBody.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow textContainerBody = new TextFlow();
        textContainerBody.setPrefWidth(275.0);
        textContainerBody.getChildren().add((Object)textBoxBody);
        this.mContext.mUtil.setTextBaselineAndSpacing(textContainerBody, textBoxBody, 138.0, 21.0);
        GridPane.setConstraints((Node)textContainerBody, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonNo = this.mContext.mUtil.factoryButton(90, 32, "night_background_button_enabled_narrow.svg", "night_icon_cross_mark_enabled.svg", 24.0, "No", 45, this.mContext.mFontBold, 14.0, this.mContext.mNightEnabledColor);
        buttonNo.setTranslateX(-71.0);
        buttonNo.setTranslateY(328.0);
        buttonNo.setOnMouseClicked(this::onTouchNo);
        GridPane.setConstraints((Node)buttonNo, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonYes = this.mContext.mUtil.factoryButton(90, 32, "background_button_green_narrow.svg", "night_icon_check_mark_activated.svg", 24.0, "Yes", 45, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonYes.setTranslateX(71.0);
        buttonYes.setTranslateY(328.0);
        buttonYes.setOnMouseClicked(this::onTouchYes);
        GridPane.setConstraints((Node)buttonYes, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        Parent imageWaves = this.mContext.mUtil.loadImageNode("waves.svg");
        GridPane.setConstraints((Node)imageWaves, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonFeedback = new LayoutWidgetIcon(this.mContext, 50.0, "Feedback", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonFeedback.setOnMouseClicked(this::onTouchFeedback);
        GridPane.setConstraints((Node)buttonFeedback, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        LayoutWidgetIcon buttonPrivacy = new LayoutWidgetIcon(this.mContext, 50.0, "Privacy", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonPrivacy.setOnMouseClicked(this::onTouchPrivacy);
        GridPane.setConstraints((Node)buttonPrivacy, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        displayPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        displayPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowMiddle, rowBottom});
        displayPane.getChildren().addAll((Object[])new Node[]{logo, textContainerTitle, textContainerBody, buttonNo, buttonYes, imageWaves, buttonFeedback, buttonPrivacy});
        this.getChildren().addAll((Object[])new Node[]{displayPane});
    }
}

