/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfImage;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.FileDocumentPicture;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewSceneListItem
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public boolean mAsSaveTarget = false;
    public ElConfScene mElConfScene = null;
    public Text mTextSceneName = null;
    public Text mTextSceneInfo = null;
    public HBox mImageContainer = null;
    public LayoutWidgetIcon mLineMark = null;
    public double[] mInsetLeft = new double[3];

    public LayoutViewSceneListItem(Context context, boolean asSaveTarget) {
        this.mContext = context;
        this.mAsSaveTarget = asSaveTarget;
    }

    public void displayMark(boolean showMark) {
        this.mLineMark.setVisible(showMark);
    }

    public void displayElConfImages(ElConfImage[] elConfImages) {
        int index = 0;
        this.mImageContainer.getChildren().clear();
        for (ElConfImage elConfImage : elConfImages) {
            if (index++ >= 3) break;
            FileDocumentPicture fileDocumentPicture = new FileDocumentPicture(this.mContext).fromElConfImage(elConfImage);
            Image image = fileDocumentPicture.getImage();
            if (image == null) continue;
            ImageView sceneImage = new ImageView();
            sceneImage.setFitWidth(64.0);
            sceneImage.setFitHeight(64.0);
            sceneImage.setPreserveRatio(true);
            sceneImage.setSmooth(true);
            sceneImage.setImage(image);
            this.mImageContainer.getChildren().add((Object)sceneImage);
        }
    }

    public void displayScene(ElConfScene scene) {
        this.mElConfScene = scene;
        int countImages = this.mElConfScene.images.length;
        int countUnits = this.mElConfScene.units.length;
        this.mTextSceneName.setText(this.mElConfScene.name);
        this.mTextSceneInfo.setText(countImages + " image" + (countImages > 1 ? "s" : "") + " / " + countUnits + " unit" + (countUnits > 1 ? "s" : ""));
        this.displayElConfImages(this.mElConfScene.images);
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.setOnMouseClicked(this::onTouchScene);
        this.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 50px 0px 50px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        ColumnConstraints columnLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(14.54326);
        ColumnConstraints columnImage = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnImage.setPercentWidth(37.01923);
        ColumnConstraints columnName = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnName.setPercentWidth(48.43751);
        RowConstraints rowTop = new RowConstraints(35.0, 35.0, 35.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowBottom = new RowConstraints(37.0, 37.0, 37.0, Priority.NEVER, VPos.TOP, false);
        this.mTextSceneInfo = new Text("0 image / 0 unit");
        this.mTextSceneInfo.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextSceneInfo.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxSceneInfo = new TextFlow();
        boxSceneInfo.setTextAlignment(TextAlignment.LEFT);
        boxSceneInfo.setPrefHeight(35.0);
        boxSceneInfo.setMaxHeight(35.0);
        boxSceneInfo.getChildren().add((Object)this.mTextSceneInfo);
        this.mContext.mUtil.setTextBaseline(boxSceneInfo, this.mTextSceneInfo, 24.0);
        GridPane.setConstraints((Node)boxSceneInfo, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mTextSceneName = new Text("Scene 1");
        this.mTextSceneName.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mTextSceneName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
        this.mTextSceneName.setWrappingWidth(Double.MAX_VALUE);
        this.mTextSceneName.setClip((Node)new Rectangle(this.mTextSceneName.getLayoutBounds().getWidth(), this.mTextSceneName.getLayoutBounds().getHeight()));
        TextFlow boxSceneName = new TextFlow();
        boxSceneName.setTextAlignment(TextAlignment.LEFT);
        boxSceneName.setPrefHeight(37.0);
        boxSceneName.setMaxHeight(37.0);
        boxSceneName.getChildren().add((Object)this.mTextSceneName);
        GridPane.setConstraints((Node)boxSceneName, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(21.0 - this.mTextSceneName.getBaselineOffset(), 75.0, 0.0, 0.0));
        this.mImageContainer = new HBox(22.0);
        this.mImageContainer.setAlignment(Pos.CENTER_LEFT);
        this.mImageContainer.setMinWidth(0.0);
        this.mImageContainer.setPrefWidth(-1.0);
        this.mImageContainer.setMaxWidth(Double.MAX_VALUE);
        this.mImageContainer.setMinHeight(64.0);
        this.mImageContainer.setPrefHeight(64.0);
        this.mImageContainer.setMaxHeight(64.0);
        GridPane.setConstraints((Node)this.mImageContainer, (int)1, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        this.mLineMark = new LayoutWidgetIcon(this.mContext, 36.0, 36.0, "line_mark.svg", "", this.mContext.mFontRegular, 7.5, this.mContext.mNightActivatedColor);
        this.mLineMark.setTranslateX(-32.0);
        this.mLineMark.setVisible(false);
        GridPane.setConstraints((Node)this.mLineMark, (int)2, (int)0, (int)1, (int)2, (HPos)HPos.RIGHT, (VPos)VPos.CENTER);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnImage, columnName});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mImageContainer, boxSceneInfo, boxSceneName, this.mLineMark});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchScene(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                if (this.mAsSaveTarget) {
                    this.mContext.mLayoutPresenterSceneSave.onSaveAs(this.mElConfScene);
                } else {
                    this.mContext.mLayoutPresenterSceneHasContent.displayScenesWithDetail(this.mElConfScene);
                }
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

