/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewSceneSaveAs
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public StackPane mContainerView = null;
    public LayoutWidgetIcon mButtonCancel = null;

    public LayoutViewSceneSaveAs(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints columnLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnCenter = new ColumnConstraints(832.0, 832.0, 832.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnRight = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, false);
        RowConstraints rowTop = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
        RowConstraints rowBottom = new RowConstraints(150.0, 150.0, 150.0, Priority.NEVER, VPos.TOP, false);
        this.mContainerView = new StackPane();
        this.mContainerView.setAlignment(Pos.TOP_CENTER);
        GridPane.setFillWidth((Node)this.mContainerView, (Boolean)true);
        GridPane.setConstraints((Node)this.mContainerView, (int)1, (int)0);
        this.mButtonCancel = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_cross_mark_enabled.svg", 26.0, "Cancel", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightEnabledColor);
        this.mButtonCancel.setStyle("-fx-background-color: rgb(51,54,59), rgb(0,0,0);-fx-background-insets: 0px, 1px;-fx-background-radius: 16px, 15px;");
        this.mButtonCancel.setOnMouseClicked(this::onTouchCancel);
        GridPane.setConstraints((Node)this.mButtonCancel, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(59.0, 0.0, 0.0, 0.0));
        Text textHintSaveAs = new Text("Select the scene where to save your current units settings");
        textHintSaveAs.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textHintSaveAs.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 10.5));
        TextFlow boxHintSaveAs = new TextFlow();
        boxHintSaveAs.getChildren().add((Object)textHintSaveAs);
        GridPane.setConstraints((Node)boxHintSaveAs, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(130.0 - textHintSaveAs.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnCenter, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mContainerView, this.mButtonCancel, boxHintSaveAs});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchCancel(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.mContext.mLayoutPresenterSceneSave.onCancel();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

