/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfUnit;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewSceneUnit
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public ElConfUnit mElConfUnit = null;
    public Pane mGroupPane = null;
    public ImageView mUnitImage = null;
    public Text mTextUnitId = null;
    public Text mTextUnitName = null;
    public LayoutWidgetIcon mIconSignal = null;

    public LayoutViewSceneUnit(Context context) {
        this.mContext = context;
    }

    public void displayElConfUnit(ElConfUnit elConfUnit) {
        Unit_Prototype_Json prototype;
        this.mElConfUnit = elConfUnit;
        this.initIfNeeded();
        String productName = "";
        URL imageUrl = null;
        if (this.mContext.mUnitPrototypes.containsKey(elConfUnit.product_id & 0xFF) && (prototype = this.mContext.mUnitPrototypes.get(elConfUnit.product_id & 0xFF)) != null) {
            if (prototype.Image_URL != null) {
                try {
                    imageUrl = new File(this.mContext.mFolderImages + prototype.Image_URL).toURI().toURL();
                }
                catch (Throwable t) {
                    this.mContext.mLogger.printStackTrace(t);
                }
            }
            if (prototype.Model_full_name != null) {
                productName = prototype.Model_full_name;
            }
        }
        this.mGroupPane.setStyle("-fx-background-color: #" + this.mContext.mColorGroup[Math.max(0, Math.min(elConfUnit.group, 4))] + ";-fx-background-insets: 0px 0px 0px 0px;-fx-background-radius: 3px 0px 0px 3px / 3px 0px 0px 3px;");
        if (imageUrl != null) {
            this.mUnitImage.setImage(new Image(imageUrl.toString()));
        }
        if (elConfUnit.skyport_id != null) {
            this.mTextUnitId.setText(elConfUnit.skyport_id);
        }
        if (elConfUnit.friendly_name != null && !elConfUnit.friendly_name.equals("")) {
            this.mTextUnitName.setText(elConfUnit.friendly_name);
        } else {
            this.mTextUnitName.setText(productName);
        }
    }

    public void displaySignalStrength(int signalStrength) {
        int previousIndex = this.mIconSignal.getIndex();
        int newIndex = signalStrength < (previousIndex == 0 ? 30 : 20) ? 0 : (signalStrength < (previousIndex == 1 ? 55 : 45) ? 1 : (signalStrength < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mIconSignal.setIndex(newIndex);
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 0px 0px 0px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        ColumnConstraints columnLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(22.40437);
        ColumnConstraints columnImage = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnImage.setPercentWidth(25.81967);
        ColumnConstraints columnName = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnName.setPercentWidth(33.60655);
        ColumnConstraints columnSignal = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnSignal.setPercentWidth(12.02185);
        RowConstraints row = new RowConstraints(72.0, 72.0, 72.0, Priority.NEVER, VPos.CENTER, false);
        this.mGroupPane = new Pane();
        this.mGroupPane.setPrefSize(27.0, 72.0);
        GridPane.setConstraints((Node)this.mGroupPane, (int)0, (int)0);
        this.mUnitImage = new ImageView();
        this.mUnitImage.setFitWidth(64.0);
        this.mUnitImage.setFitHeight(64.0);
        this.mUnitImage.setPreserveRatio(true);
        this.mUnitImage.setSmooth(true);
        GridPane.setConstraints((Node)this.mUnitImage, (int)1, (int)0);
        this.mTextUnitId = new Text("");
        this.mTextUnitId.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextUnitId.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxUnitId = new TextFlow();
        boxUnitId.getChildren().add((Object)this.mTextUnitId);
        GridPane.setConstraints((Node)boxUnitId, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(24.0 - this.mTextUnitId.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mTextUnitName = new Text("");
        this.mTextUnitName.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mTextUnitName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
        TextFlow boxUnitName = new TextFlow();
        boxUnitName.getChildren().add((Object)this.mTextUnitName);
        GridPane.setConstraints((Node)boxUnitName, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(55.0 - this.mTextUnitName.getBaselineOffset(), 0.0, 0.0, 0.0));
        List<String> imageSignal = Arrays.asList("day_signal_0.svg", "day_signal_1.svg", "day_signal_2.svg", "day_signal_3.svg");
        this.mIconSignal = this.mContext.mUtil.factoryIconSet(24, 24, imageSignal, 0);
        GridPane.setConstraints((Node)this.mIconSignal, (int)3, (int)0);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnImage, columnName, columnSignal});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mGroupPane, this.mUnitImage, boxUnitId, boxUnitName, this.mIconSignal});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

