/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.LayoutWidgetSwitch;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewSettings
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public Text mTextButtonRestoreMessage = null;
    public Text mTextValueInstallId = null;
    public LayoutWidgetSwitch mSwitchSortAlphobetically = null;
    public LayoutWidgetSwitch mSwitchShareData = null;
    public ComboBox<String> mChoiceBridgeAutoOff = null;
    public String[] mBridgeAutoOffLabels = null;
    public int[] mBridgeAutoOffValues = null;
    public int[] mBridgeAutoOffPosition = null;

    public LayoutViewSettings(Context context) {
        this.mContext = context;
        this.mBridgeAutoOffLabels = new String[]{"No auto-off", "1 hour", "2 hours", "3 hours", "4 hours"};
        this.mBridgeAutoOffValues = new int[]{0, 1, 2, 3, 4};
        this.mBridgeAutoOffPosition = new int[]{0, 1, 2, 3, 4};
    }

    public void displayInstallId(String installId) {
        if (this.mTextValueInstallId != null) {
            this.mTextValueInstallId.setText(installId.isEmpty() ? "Not set" : installId);
        }
    }

    public void displayShareData(boolean isShareData) {
        this.mSwitchShareData.setActivated(isShareData);
    }

    public int getBridgeAutoOffIndex() {
        int translatedAutoOffValue = (int)Math.max(0.0f, Math.min((float)this.mContext.mStoredPreferences.bridgeAutoOff / 60.0f, 4.0f));
        return this.mBridgeAutoOffPosition[translatedAutoOffValue];
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        Pane line = null;
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnCenter = new ColumnConstraints(674.0, 674.0, 674.0, Priority.NEVER, HPos.CENTER, false);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.ALWAYS, HPos.RIGHT, false);
        RowConstraints rowTop = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        rowTop.setPercentHeight(75.0);
        RowConstraints rowBottom = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.BOTTOM, false);
        rowBottom.setPercentHeight(25.0);
        Parent logo = this.mContext.mUtil.loadImageNode("night_logo_display.svg");
        logo.setTranslateY(72.0);
        GridPane.setConstraints((Node)logo, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        Text textLabelRestoreMessage = new Text("Restore help messages");
        textLabelRestoreMessage.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelRestoreMessage.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelRestoreMessage = new TextFlow();
        boxLabelRestoreMessage.setTextAlignment(TextAlignment.LEFT);
        boxLabelRestoreMessage.getChildren().add((Object)textLabelRestoreMessage);
        GridPane.setConstraints((Node)boxLabelRestoreMessage, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(230.0 - textLabelRestoreMessage.getBaselineOffset(), 0.0, 0.0, 0.0));
        LayoutWidgetIcon textButtonRestoreMessage = new LayoutWidgetIcon(this.mContext, 30.0, "Reset", this.mContext.mFontRegular, 14.0, this.mContext.mNightActivatedColor);
        textButtonRestoreMessage.setGesture((EventHandler<MouseEvent>)((EventHandler)this::onTouchRestoreMessages));
        GridPane.setConstraints((Node)textButtonRestoreMessage, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(210.0, 0.0, 0.0, 0.0));
        line = new Pane();
        line.setMinWidth(674.0);
        line.setPrefWidth(674.0);
        line.setMaxWidth(674.0);
        line.setMinHeight(1.0);
        line.setPrefHeight(1.0);
        line.setMaxHeight(1.0);
        line.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
        GridPane.setConstraints((Node)line, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(250.0, 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{boxLabelRestoreMessage, textButtonRestoreMessage, line});
        Text textLabelBridgeAutoOff = new Text("Elinchrom Bridge auto-off by BLE");
        textLabelBridgeAutoOff.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelBridgeAutoOff.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelBridgeAutoOff = new TextFlow();
        boxLabelBridgeAutoOff.setTextAlignment(TextAlignment.LEFT);
        boxLabelBridgeAutoOff.getChildren().add((Object)textLabelBridgeAutoOff);
        GridPane.setConstraints((Node)boxLabelBridgeAutoOff, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(280.0 - textLabelBridgeAutoOff.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mChoiceBridgeAutoOff = new ComboBox();
        this.mChoiceBridgeAutoOff.getItems().addAll((Object[])this.mBridgeAutoOffLabels);
        this.mChoiceBridgeAutoOff.setPrefSize(140.0, 32.0);
        this.mChoiceBridgeAutoOff.getStyleClass().add((Object)"rounded");
        this.mChoiceBridgeAutoOff.getSelectionModel().select(this.getBridgeAutoOffIndex());
        this.mChoiceBridgeAutoOff.setOnAction(this::onValueChangedBridgeAutoOff);
        GridPane.setConstraints(this.mChoiceBridgeAutoOff, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(259.0, 0.0, 0.0, 0.0));
        line = new Pane();
        line.setMinWidth(674.0);
        line.setPrefWidth(674.0);
        line.setMaxWidth(674.0);
        line.setMinHeight(1.0);
        line.setPrefHeight(1.0);
        line.setMaxHeight(1.0);
        line.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
        GridPane.setConstraints((Node)line, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(300.0, 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{boxLabelBridgeAutoOff, this.mChoiceBridgeAutoOff, line});
        Text textLabelSortAlphobetically = new Text("Sort units alphabetically");
        textLabelSortAlphobetically.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelSortAlphobetically.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelSortAlphobetically = new TextFlow();
        boxLabelSortAlphobetically.setTextAlignment(TextAlignment.LEFT);
        boxLabelSortAlphobetically.getChildren().add((Object)textLabelSortAlphobetically);
        GridPane.setConstraints((Node)boxLabelSortAlphobetically, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(330.0 - textLabelSortAlphobetically.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mSwitchSortAlphobetically = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
        this.mSwitchSortAlphobetically.setActivated(this.mContext.mStoredPreferences.sortManually == 0);
        this.mSwitchSortAlphobetically.setTranslateX(1.0);
        this.mSwitchSortAlphobetically.setOnMouseClicked(this::onTouchSortAlphabetically);
        GridPane.setConstraints((Node)this.mSwitchSortAlphobetically, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(314.0, 0.0, 39.0, 175.0));
        line = new Pane();
        line.setMinWidth(674.0);
        line.setPrefWidth(674.0);
        line.setMaxWidth(674.0);
        line.setMinHeight(1.0);
        line.setPrefHeight(1.0);
        line.setMaxHeight(1.0);
        line.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
        GridPane.setConstraints((Node)line, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(350.0, 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{boxLabelSortAlphobetically, this.mSwitchSortAlphobetically, line});
        Text textLabelShareData = new Text("Share usage data");
        textLabelShareData.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelShareData.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelShareData = new TextFlow();
        boxLabelShareData.setTextAlignment(TextAlignment.LEFT);
        boxLabelShareData.getChildren().add((Object)textLabelShareData);
        GridPane.setConstraints((Node)boxLabelShareData, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(380.0 - textLabelShareData.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mSwitchShareData = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
        this.mSwitchShareData.setTranslateX(1.0);
        this.mSwitchShareData.setOnMouseClicked(this::onTouchShareData);
        GridPane.setConstraints((Node)this.mSwitchShareData, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(364.0, 0.0, 39.0, 175.0));
        line = new Pane();
        line.setMinWidth(674.0);
        line.setPrefWidth(674.0);
        line.setMaxWidth(674.0);
        line.setMinHeight(1.0);
        line.setPrefHeight(1.0);
        line.setMaxHeight(1.0);
        line.setStyle("-fx-background-color:#" + this.mContext.mNightDisabledColor + ";");
        GridPane.setConstraints((Node)line, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(400.0, 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{boxLabelShareData, this.mSwitchShareData, line});
        Text textLabelInstallId = new Text("Install ID");
        textLabelInstallId.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        textLabelInstallId.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxLabelInstallId = new TextFlow();
        boxLabelInstallId.setTextAlignment(TextAlignment.LEFT);
        boxLabelInstallId.getChildren().add((Object)textLabelInstallId);
        GridPane.setConstraints((Node)boxLabelInstallId, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(430.0 - textLabelInstallId.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mTextValueInstallId = new Text("Not set");
        this.mTextValueInstallId.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mTextValueInstallId.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxValueInstallId = new TextFlow();
        boxValueInstallId.setTextAlignment(TextAlignment.LEFT);
        boxValueInstallId.setMinHeight(30.0);
        boxValueInstallId.setPrefHeight(30.0);
        boxValueInstallId.setMaxHeight(30.0);
        boxValueInstallId.getChildren().add((Object)this.mTextValueInstallId);
        boxValueInstallId.setOnMouseClicked(this::onTouchRestoreMessages);
        GridPane.setConstraints((Node)boxValueInstallId, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(430.0 - this.mTextValueInstallId.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{boxLabelInstallId, boxValueInstallId});
        Parent imageWaves = this.mContext.mUtil.loadImageNode("waves.svg");
        GridPane.setConstraints((Node)imageWaves, (int)0, (int)1, (int)3, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER);
        LayoutWidgetIcon buttonFeedback = new LayoutWidgetIcon(this.mContext, 50.0, "Feedback", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonFeedback.setOnMouseClicked(this::onTouchFeedback);
        GridPane.setConstraints((Node)buttonFeedback, (int)0, (int)1, (int)3, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 50.0));
        LayoutWidgetIcon buttonPrivacy = new LayoutWidgetIcon(this.mContext, 50.0, "Privacy", this.mContext.mFontRegular, 10.5, this.mContext.mNightActivatedColor);
        buttonPrivacy.setOnMouseClicked(this::onTouchPrivacy);
        GridPane.setConstraints((Node)buttonPrivacy, (int)0, (int)1, (int)3, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnCenter, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{logo, imageWaves, buttonFeedback, buttonPrivacy});
    }

    public void onValueChangedBridgeAutoOff(ActionEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onChangeBridgeAutoOff(this.mChoiceBridgeAutoOff.getSelectionModel().getSelectedIndex() * 60);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchFeedback(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onFeedback();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchPrivacy(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onPrivacy();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchRestoreMessages(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onRestoreMessages();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchShareData(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onChangeSharedData(this.mSwitchShareData.onSwitch());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSortAlphabetically(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterSettings.onChangeSortedAlphabetically(this.mSwitchSortAlphobetically.onSwitch());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void setSizeSmall() {
        StackPane.setAlignment((Node)this, (Pos)Pos.TOP_CENTER);
        this.setPrefHeight(945.0);
        this.setMaxHeight(945.0);
    }

    public void setSizeBig() {
        this.setPrefHeight(-1.0);
        this.setMaxHeight(Double.MAX_VALUE);
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

