/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.OnTouchSideMenuListener;
import com.elinchrom.software.OnTouchSideMenuListenerGroup;
import com.elinchrom.software.OnTouchSideMenuListenerScene;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutViewSideMenu
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public Pane mSideMenuTopView;
    public ScrollPane mSideMenuCenterView;
    public GridPane mScenesPane;
    public Pane mDarkMask = null;
    public LayoutWidgetIcon mButtonUpdates;
    public LayoutWidgetIcon mButtonChannel;
    public Pane mGroup1DropArea;
    public Pane mGroup2DropArea;
    public Pane mGroup3DropArea;
    public Pane mGroup4DropArea;

    public LayoutViewSideMenu(Context context) {
        this.mContext = context;
    }

    public void displayHasUpdates(boolean hasUpdates) {
        this.mButtonUpdates.setIndex(hasUpdates ? 1 : 0);
    }

    public void displayScenes(ElConfScene[] elConfScenes) {
        int left = 21;
        int increment = 50;
        int base = 9;
        int count = 0;
        this.mScenesPane.getChildren().clear();
        for (ElConfScene elConfScene : elConfScenes) {
            LayoutWidgetIcon buttonScene = new LayoutWidgetIcon(this.mContext, 214.0, 32.0, "button_black_wide.svg", "night_icon_load_activated.svg", 36.0, elConfScene.name, 72.0, 20.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
            buttonScene.setGesture(new OnTouchSideMenuListenerScene(this.mContext, elConfScene, null));
            GridPane.setConstraints((Node)buttonScene, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets((double)(base + count++ * increment), 0.0, 0.0, (double)left));
            this.mScenesPane.getChildren().add((Object)buttonScene);
        }
    }

    public void displaySignalStrength(int signalStrength) {
        int previousIndex = this.mButtonChannel.getIndex();
        int newIndex = signalStrength < (previousIndex == 0 ? 30 : 20) ? 0 : (signalStrength < (previousIndex == 1 ? 55 : 45) ? 1 : (signalStrength < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mButtonChannel.setIndex(newIndex);
        }
    }

    public void displaySkyportChannel(int skyportChannel) {
        if (skyportChannel == 0) {
            this.mButtonChannel.setText("Channel");
            this.mButtonChannel.setIndex(4);
        } else {
            this.mButtonChannel.setText("Channel " + skyportChannel);
        }
    }

    public Pane getDarkMask() {
        this.initIfNeeded();
        return this.mDarkMask;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.getStyleClass().add((Object)"night-theme");
        int leftLabel = 18;
        int left = 21;
        int base = 109;
        int increment = 50;
        int count = 0;
        ColumnConstraints column = new ColumnConstraints(256.0, 256.0, 256.0, Priority.NEVER, HPos.LEFT, false);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        RowConstraints rowTop = new RowConstraints(750.0, 750.0, 750.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowScenes = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowScenes});
        this.mSideMenuTopView = new Pane();
        this.add((Node)this.mSideMenuTopView, 0, 0);
        Parent logoElinchrom = this.mContext.mUtil.loadImageNode("night_logo_side.svg");
        logoElinchrom.setTranslateX(32.0);
        logoElinchrom.setTranslateY(44.0);
        this.mSideMenuTopView.getChildren().add((Object)logoElinchrom);
        HashMap<String, String> imageUnits = new HashMap<String, String>();
        imageUnits.put("FFFFFF", "night_icon_unit_enabled.svg");
        imageUnits.put("21b894", "night_icon_unit_activated.svg");
        LayoutWidgetIcon buttonUnits = this.mContext.mUtil.factoryButtonTintable(214, 32, imageUnits, 24.0, "Units", 72, this.mContext.mFontBold, 14.0, "FFFFFF");
        buttonUnits.setTranslateX(left);
        buttonUnits.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)buttonUnits);
        this.mContext.mLayoutClickUnitsListener = new OnTouchSideMenuListenerGroup(this.mContext, buttonUnits, this.mContext.mLayoutPresenterUnits, null, "", 0, 31, 255);
        buttonUnits.setOnMouseClicked(this.mContext.mLayoutClickUnitsListener);
        HashMap<String, String> imageScenes = new HashMap<String, String>();
        imageScenes.put("FFFFFF", "night_icon_scene_enabled.svg");
        imageScenes.put("21b894", "night_icon_scene_activated.svg");
        LayoutWidgetIcon buttonScenes = this.mContext.mUtil.factoryButtonTintable(214, 32, imageScenes, 24.0, "Scenes", 72, this.mContext.mFontBold, 14.0, "FFFFFF");
        buttonScenes.setTranslateX(left);
        buttonScenes.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)buttonScenes);
        this.mContext.mLayoutClickSceneListener = new OnTouchSideMenuListener(this.mContext, buttonScenes, this.mContext.mLayoutPresenterScene);
        buttonScenes.setOnMouseClicked(this.mContext.mLayoutClickSceneListener);
        HashMap<String, List<String>> imageUpdates = new HashMap<String, List<String>>();
        imageUpdates.put("FFFFFF", Arrays.asList("night_icon_update_0_enabled.svg", "night_icon_update_1_enabled.svg"));
        imageUpdates.put("21b894", Arrays.asList("night_icon_update_0_activated.svg", "night_icon_update_1_activated.svg"));
        this.mButtonUpdates = this.mContext.mUtil.factoryButtonSet(214, 32, imageUpdates, 24.0, "Updates", 72, this.mContext.mFontBold, 14.0, "FFFFFF", 0);
        this.mButtonUpdates.setTranslateX(left);
        this.mButtonUpdates.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)this.mButtonUpdates);
        this.mContext.mLayoutClickUpdatesListener = new OnTouchSideMenuListener(this.mContext, this.mButtonUpdates, this.mContext.mLayoutPresenterUpdate);
        this.mButtonUpdates.setOnMouseClicked(this.mContext.mLayoutClickUpdatesListener);
        HashMap<String, List<String>> imageChannel = new HashMap<String, List<String>>();
        imageChannel.put("FFFFFF", Arrays.asList("night_signal_0_enabled.svg", "night_signal_1_enabled.svg", "night_signal_2_enabled.svg", "night_signal_3_enabled.svg", "night_connection_usb_enabled.svg", "night_connection_ble_enabled.svg"));
        imageChannel.put("21b894", Arrays.asList("night_signal_0_activated.svg", "night_signal_1_activated.svg", "night_signal_2_activated.svg", "night_signal_3_activated.svg", "night_connection_usb_activated.svg", "night_connection_ble_activated.svg"));
        this.mButtonChannel = this.mContext.mUtil.factoryButtonSet(214, 32, imageChannel, 24.0, "Channel", 72, this.mContext.mFontBold, 14.0, "21b894", 4);
        this.mButtonChannel.setTranslateX(left);
        this.mButtonChannel.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)this.mButtonChannel);
        this.mContext.mLayoutClickChannelListener = new OnTouchSideMenuListener(this.mContext, this.mButtonChannel, this.mContext.mLayoutPresenterChannel);
        this.mButtonChannel.setOnMouseClicked(this.mContext.mLayoutClickChannelListener);
        HashMap<String, String> imageSettings = new HashMap<String, String>();
        imageSettings.put("FFFFFF", "night_icon_settings_enabled.svg");
        imageSettings.put("21b894", "night_icon_settings_activated.svg");
        LayoutWidgetIcon buttonSettings = this.mContext.mUtil.factoryButtonTintable(214, 32, imageSettings, 24.0, "Settings", 72, this.mContext.mFontBold, 14.0, "FFFFFF");
        buttonSettings.setTranslateX(left);
        buttonSettings.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)buttonSettings);
        this.mContext.mLayoutClickSettingsListener = new OnTouchSideMenuListener(this.mContext, buttonSettings, this.mContext.mLayoutPresenterSettings);
        buttonSettings.setOnMouseClicked(this.mContext.mLayoutClickSettingsListener);
        HashMap<String, String> imageHelp = new HashMap<String, String>();
        imageHelp.put("FFFFFF", "night_icon_help_enabled.svg");
        imageHelp.put("21b894", "night_icon_help_activated.svg");
        LayoutWidgetIcon buttonHelp = this.mContext.mUtil.factoryButtonTintable(214, 32, imageHelp, 24.0, "Help", 72, this.mContext.mFontBold, 14.0, "FFFFFF");
        buttonHelp.setTranslateX(left);
        buttonHelp.setTranslateY(base + count++ * increment);
        this.mSideMenuTopView.getChildren().add((Object)buttonHelp);
        this.mContext.mLayoutClickHelpListener = new OnTouchSideMenuListener(this.mContext, buttonHelp, this.mContext.mLayoutPresenterHelp);
        buttonHelp.setOnMouseClicked(this.mContext.mLayoutClickHelpListener);
        base = 477;
        count = 0;
        Text groupsLabelText = new Text("Groups");
        groupsLabelText.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        groupsLabelText.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow groupsLabelBox = new TextFlow();
        groupsLabelBox.getChildren().add((Object)groupsLabelText);
        this.mContext.mUtil.setTextBaseline(groupsLabelBox, groupsLabelText, leftLabel, 455.0);
        this.mSideMenuTopView.getChildren().add((Object)groupsLabelBox);
        LayoutWidgetIcon buttonGroup1 = this.mContext.mUtil.factoryButton(254, 46, null, null, 0.0, "Group 1", 94, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonGroup1.getStyleClass().add((Object)"side-group-1");
        buttonGroup1.setTranslateY(base + count * increment);
        this.mContext.mLayoutClickGroup1Listener = new OnTouchSideMenuListenerGroup(this.mContext, buttonUnits, this.mContext.mLayoutPresenterUnits, buttonGroup1, "Group 1", 1, 2, 1);
        buttonGroup1.setGesture(this.mContext.mLayoutClickGroup1Listener);
        this.mGroup1DropArea = new Pane();
        this.mGroup1DropArea.setMouseTransparent(true);
        this.mGroup1DropArea.setOnDragDropped(this.mContext.mLayoutClickGroup1Listener::onDragDropped);
        this.mGroup1DropArea.setOnDragEntered(this.mContext.mLayoutClickGroup1Listener::onDragEntered);
        this.mGroup1DropArea.setOnDragExited(this.mContext.mLayoutClickGroup1Listener::onDragExited);
        this.mGroup1DropArea.setOnDragOver(this.mContext.mLayoutClickGroup1Listener::onDragOver);
        this.mGroup1DropArea.setPrefSize(254.0, 46.0);
        this.mGroup1DropArea.setTranslateY((double)(base + count++ * increment));
        this.mSideMenuTopView.getChildren().addAll((Object[])new Node[]{buttonGroup1, this.mGroup1DropArea});
        LayoutWidgetIcon buttonGroup2 = this.mContext.mUtil.factoryButton(254, 46, null, null, 0.0, "Group 2", 94, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonGroup2.getStyleClass().add((Object)"side-group-2");
        buttonGroup2.setTranslateY(base + count * increment);
        this.mContext.mLayoutClickGroup2Listener = new OnTouchSideMenuListenerGroup(this.mContext, buttonUnits, this.mContext.mLayoutPresenterUnits, buttonGroup2, "Group 2", 2, 4, 2);
        buttonGroup2.setGesture(this.mContext.mLayoutClickGroup2Listener);
        this.mGroup2DropArea = new Pane();
        this.mGroup2DropArea.setMouseTransparent(true);
        this.mGroup2DropArea.setOnDragDropped(this.mContext.mLayoutClickGroup2Listener::onDragDropped);
        this.mGroup2DropArea.setOnDragEntered(this.mContext.mLayoutClickGroup2Listener::onDragEntered);
        this.mGroup2DropArea.setOnDragExited(this.mContext.mLayoutClickGroup2Listener::onDragExited);
        this.mGroup2DropArea.setOnDragOver(this.mContext.mLayoutClickGroup2Listener::onDragOver);
        this.mGroup2DropArea.setPrefSize(254.0, 46.0);
        this.mGroup2DropArea.setTranslateY((double)(base + count++ * increment));
        this.mSideMenuTopView.getChildren().addAll((Object[])new Node[]{buttonGroup2, this.mGroup2DropArea});
        LayoutWidgetIcon buttonGroup3 = this.mContext.mUtil.factoryButton(254, 46, null, null, 0.0, "Group 3", 94, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonGroup3.getStyleClass().add((Object)"side-group-3");
        buttonGroup3.setTranslateY(base + count * increment);
        this.mContext.mLayoutClickGroup3Listener = new OnTouchSideMenuListenerGroup(this.mContext, buttonUnits, this.mContext.mLayoutPresenterUnits, buttonGroup3, "Group 3", 3, 8, 4);
        buttonGroup3.setGesture(this.mContext.mLayoutClickGroup3Listener);
        this.mGroup3DropArea = new Pane();
        this.mGroup3DropArea.setMouseTransparent(true);
        this.mGroup3DropArea.setOnDragDropped(this.mContext.mLayoutClickGroup3Listener::onDragDropped);
        this.mGroup3DropArea.setOnDragEntered(this.mContext.mLayoutClickGroup3Listener::onDragEntered);
        this.mGroup3DropArea.setOnDragExited(this.mContext.mLayoutClickGroup3Listener::onDragExited);
        this.mGroup3DropArea.setOnDragOver(this.mContext.mLayoutClickGroup3Listener::onDragOver);
        this.mGroup3DropArea.setPrefSize(254.0, 46.0);
        this.mGroup3DropArea.setTranslateY((double)(base + count++ * increment));
        this.mSideMenuTopView.getChildren().addAll((Object[])new Node[]{buttonGroup3, this.mGroup3DropArea});
        LayoutWidgetIcon buttonGroup4 = this.mContext.mUtil.factoryButton(254, 46, null, null, 0.0, "Group 4", 94, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonGroup4.getStyleClass().add((Object)"side-group-4");
        buttonGroup4.setTranslateY(base + count * increment);
        this.mContext.mLayoutClickGroup4Listener = new OnTouchSideMenuListenerGroup(this.mContext, buttonUnits, this.mContext.mLayoutPresenterUnits, buttonGroup4, "Group 4", 4, 16, 8);
        buttonGroup4.setGesture(this.mContext.mLayoutClickGroup4Listener);
        this.mGroup4DropArea = new Pane();
        this.mGroup4DropArea.setMouseTransparent(true);
        this.mGroup4DropArea.setOnDragDropped(this.mContext.mLayoutClickGroup4Listener::onDragDropped);
        this.mGroup4DropArea.setOnDragEntered(this.mContext.mLayoutClickGroup4Listener::onDragEntered);
        this.mGroup4DropArea.setOnDragExited(this.mContext.mLayoutClickGroup4Listener::onDragExited);
        this.mGroup4DropArea.setOnDragOver(this.mContext.mLayoutClickGroup4Listener::onDragOver);
        this.mGroup4DropArea.setPrefSize(254.0, 46.0);
        this.mGroup4DropArea.setTranslateY((double)(base + count++ * increment));
        this.mSideMenuTopView.getChildren().addAll((Object[])new Node[]{buttonGroup4, this.mGroup4DropArea});
        Text scenesLabelText = new Text("Scenes");
        scenesLabelText.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        scenesLabelText.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow scenesLabelBox = new TextFlow();
        scenesLabelBox.getChildren().add((Object)scenesLabelText);
        this.mContext.mUtil.setTextBaseline(scenesLabelBox, scenesLabelText, leftLabel, 730.0);
        this.mSideMenuTopView.getChildren().add((Object)scenesLabelBox);
        ColumnConstraints col100 = new ColumnConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        RowConstraints row100 = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, false);
        this.mScenesPane = new GridPane();
        this.mScenesPane.setMinHeight(-1.0);
        this.mScenesPane.setMaxHeight(Double.MAX_VALUE);
        this.mScenesPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col100});
        this.mScenesPane.getRowConstraints().addAll((Object[])new RowConstraints[]{row100});
        GridPane.setConstraints((Node)this.mScenesPane, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(0.0, 0.0, 9.0, 0.0));
        this.mSideMenuCenterView = new ScrollPane();
        this.mSideMenuCenterView.setMinWidth(0.0);
        this.mSideMenuCenterView.setMaxWidth(256.0);
        this.mSideMenuCenterView.setPrefWidth(256.0);
        this.mSideMenuCenterView.setMinHeight(0.0);
        this.mSideMenuCenterView.setPrefHeight(0.0);
        this.mSideMenuCenterView.setMaxHeight(Double.MAX_VALUE);
        this.mSideMenuCenterView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mSideMenuCenterView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mSideMenuCenterView.setContent((Node)this.mScenesPane);
        GridPane.setConstraints((Node)this.mSideMenuCenterView, (int)0, (int)1);
        this.setMinHeight(-1.0);
        this.getChildren().add((Object)this.mSideMenuCenterView);
        this.mDarkMask = new Pane();
        this.mDarkMask.setStyle("-fx-background-color: rgba(0, 0, 0, 0.72);");
        StackPane.setMargin((Node)this.mDarkMask, (Insets)new Insets(103.0, 0.0, 0.0, 0.0));
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onGroupIndent() {
        this.mGroup1DropArea.setMouseTransparent(false);
        this.mGroup2DropArea.setMouseTransparent(false);
        this.mGroup3DropArea.setMouseTransparent(false);
        this.mGroup4DropArea.setMouseTransparent(false);
    }

    public void onGroupRestore() {
        this.mGroup1DropArea.setMouseTransparent(true);
        this.mGroup2DropArea.setMouseTransparent(true);
        this.mGroup3DropArea.setMouseTransparent(true);
        this.mGroup4DropArea.setMouseTransparent(true);
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            this.mSideMenuCenterView.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mSideMenuCenterView, this.mScenesPane});
            this.getChildren().add((Object)this.mScenesPane);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.getChildren().removeAll((Object[])new Node[]{this.mSideMenuCenterView, this.mScenesPane});
            this.mSideMenuCenterView.setContent((Node)this.mScenesPane);
            this.getChildren().add((Object)this.mSideMenuCenterView);
        }
    }
}

