/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.LayoutViewUnit;
import javafx.scene.input.MouseEvent;

public class LayoutViewUnitCategoryPowerPack
extends LayoutViewUnit {
    public LayoutViewUnitCategoryPowerPack(Context context, ElinchromDevice elinchromDevice) {
        super(context, elinchromDevice);
    }

    @Override
    public void displayLampPower(byte[] lampPowerValues) {
        if (this.mElinchromDevice.mComponentLighting.mFeatureList[5] == 0 && !this.mIsSliding) {
            float lampMin = (float)this.mElinchromDevice.mComponentLighting.getMin_lamp_power() / 10.0f;
            float lampMax = (float)this.mElinchromDevice.mComponentLighting.getMax_lamp_power() / 10.0f;
            float lampValue = (this.mElinchromDevice.mComponentLighting.getHead_on() & 3) == 2 ? (float)lampPowerValues[1] / 10.0f : (float)lampPowerValues[0] / 10.0f;
            this.mLampAMin.setText("" + lampMin);
            this.mLampAMax.setText("" + lampMax);
            this.mLampAElStop.setText("" + lampValue);
            this.mLampASlider.setMin(lampMin);
            this.mLampASlider.setMax(lampMax);
            this.mLampASlider.setValue(Math.max(lampMin, Math.min(lampValue, lampMax)));
        }
    }

    @Override
    public void onMouseReleasedLampA(MouseEvent event) {
        try {
            if ((this.mElinchromDevice.mComponentLighting.getHead_on() & 3) == 2) {
                this.mContext.mLayoutPresenterUnits.onChangeLampB(this.mElinchromDevice, (int)Math.round(this.mLampASlider.getValue() * 10.0));
            } else {
                this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, (int)Math.round(this.mLampASlider.getValue() * 10.0));
            }
            this.mIsSliding = false;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void onTouchLampAMinus(MouseEvent event) {
        try {
            if ((this.mElinchromDevice.mComponentLighting.getHead_on() & 3) == 2) {
                this.mContext.mLayoutPresenterUnits.onChangeLampB(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[1] - 1);
            } else {
                this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[0] - 1);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void onTouchLampAPlus(MouseEvent event) {
        try {
            if ((this.mElinchromDevice.mComponentLighting.getHead_on() & 3) == 2) {
                this.mContext.mLayoutPresenterUnits.onChangeLampB(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[1] + 1);
            } else {
                this.mContext.mLayoutPresenterUnits.onChangeLampA(this.mElinchromDevice, this.mElinchromDevice.mComponentLighting.getLampPowerValuesFStop()[0] + 1);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void showFlashMain(int flashMainPower) {
        int[] flashPowerValues = this.mElinchromDevice.mComponentLighting.getMainPowerValues();
        byte[] checkedFlashPower = this.mElinchromDevice.mComponentLighting.getClippedFlashPowerValues(new int[]{flashMainPower, flashPowerValues[1], flashPowerValues[2]});
        this.mFlashMainElStop.setText("" + (float)checkedFlashPower[0] / 10.0f);
        this.mHeadAElStop.setText("" + (float)checkedFlashPower[1] / 10.0f);
        this.mHeadBElStop.setText("" + (float)checkedFlashPower[2] / 10.0f);
        if (this.mElinchromDevice.mComponentLighting.getLamp_mode_mode() == 2) {
            byte[] checkedLampPower = this.mElinchromDevice.mComponentLighting.getClippedLampPowerValuesFromFlashPowerValues(new int[]{checkedFlashPower[0], checkedFlashPower[1], checkedFlashPower[2]});
            this.mLampAElStop.setText("" + (float)checkedLampPower[0] / 10.0f);
        }
    }
}

