/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.LayoutWidgetProgressBar;
import com.elinchrom.software.LayoutWidgetSwitch;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewUpdate
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public StackPane mLayoutNodeDisplayMain = null;
    public StackPane mLayoutNodeDisplayLeft = null;
    public StackPane mLayoutNodeDisplayRight = null;
    public Pane mDarkPane = null;
    public LayoutWidgetSwitch mSwitchShowAllUnits = null;
    public LayoutWidgetIcon mButtonFindUnits = null;
    public LayoutWidgetIcon mButtonOk = null;
    public Text mLabelUpdateStatus = null;
    public Text mLabelShowAllUnits = null;
    public Text mLabelProgressUpdate = null;
    public Text mValueProgressUpdate = null;
    public Text mLabelProgressValidation = null;
    public Text mValueProgressValidation = null;
    public Text mLabelProgressUnits = null;
    public Text mValueProgressUnits = null;
    public LayoutWidgetProgressBar mProgressBarUpdate = null;
    public LayoutWidgetProgressBar mProgressBarValidation = null;
    public LayoutWidgetProgressBar mProgressBarUnits = null;
    public StackPane mContainerButtonUpdate = null;

    public LayoutViewUpdate(Context context) {
        this.mContext = context;
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    public void displayFindUnits(boolean isVisible) {
        this.mButtonFindUnits.setVisible(isVisible);
    }

    public void displayOk(boolean isVisible) {
        if (isVisible) {
            this.displayProgressBars(false);
            this.mContainerButtonUpdate.setVisible(false);
            this.mSwitchShowAllUnits.setVisible(false);
            this.mLabelShowAllUnits.setVisible(false);
            this.mButtonOk.setVisible(true);
        } else {
            this.mButtonOk.setVisible(false);
            this.mContainerButtonUpdate.setVisible(true);
            this.mSwitchShowAllUnits.setVisible(true);
            this.mLabelShowAllUnits.setVisible(true);
            this.displayFindUnits(true);
        }
    }

    public void displayProgressBarForExtract() {
        this.mLabelProgressUpdate.setVisible(false);
        this.mValueProgressUpdate.setVisible(false);
        this.mProgressBarUpdate.setVisible(false);
        this.mLabelProgressValidation.setVisible(true);
        this.mLabelProgressValidation.setText("Extract");
        this.mValueProgressValidation.setVisible(true);
        this.mProgressBarValidation.setVisible(true);
        this.mLabelProgressUnits.setVisible(false);
        this.mValueProgressUnits.setVisible(false);
        this.mProgressBarUnits.setVisible(false);
        this.mContainerButtonUpdate.setVisible(false);
        this.mSwitchShowAllUnits.setVisible(false);
        this.mLabelShowAllUnits.setVisible(false);
    }

    public void displayProgressBars(boolean isVisible) {
        this.mLabelProgressUpdate.setVisible(isVisible);
        this.mValueProgressUpdate.setVisible(isVisible);
        this.mProgressBarUpdate.setVisible(isVisible);
        this.mLabelProgressValidation.setVisible(isVisible);
        this.mLabelProgressValidation.setText("Validation");
        this.mValueProgressValidation.setVisible(isVisible);
        this.mProgressBarValidation.setVisible(isVisible);
        this.mLabelProgressUnits.setVisible(isVisible);
        this.mValueProgressUnits.setVisible(isVisible);
        this.mProgressBarUnits.setVisible(isVisible);
        this.mContainerButtonUpdate.setVisible(!isVisible);
        this.mSwitchShowAllUnits.setVisible(!isVisible);
        this.mLabelShowAllUnits.setVisible(!isVisible);
    }

    public void displayProgressUnits(int value) {
        this.mProgressBarUnits.setProgress(value);
        this.mValueProgressUnits.setText((int)Math.max(0.0f, Math.min((float)Math.round(this.mProgressBarUnits.getProgressPercent()), 100.0f)) + " %");
    }

    public void displayProgressValue(int event, int value, int countUpdatesDone, int countUpdates) {
        switch (event) {
            case 1: {
                this.mProgressBarUpdate.setProgress(value);
                this.mValueProgressUpdate.setText((int)Math.max(0.0f, Math.min((float)Math.round(this.mProgressBarUpdate.getProgressPercent()), 100.0f)) + " %");
                break;
            }
            case 2: {
                this.mProgressBarValidation.setProgress(value);
                this.mValueProgressValidation.setText((int)Math.max(0.0f, Math.min((float)Math.round(this.mProgressBarValidation.getProgressPercent()), 100.0f)) + " %");
            }
        }
        if (countUpdates > 0) {
            float percentDoneOtherDevices = (float)countUpdatesDone / (float)countUpdates * 100.0f;
            float percentDoneCurrentDevice = (this.mProgressBarUpdate.getProgressPercent() + this.mProgressBarValidation.getProgressPercent()) / (float)countUpdates / 2.0f;
            this.mProgressBarUnits.setProgress((int)Math.max(0.0f, Math.min((float)Math.round(percentDoneOtherDevices + percentDoneCurrentDevice), 99.0f)));
            this.mValueProgressUnits.setText((int)Math.max(0.0f, Math.min((float)Math.round(this.mProgressBarUnits.getProgressPercent()), 99.0f)) + " %");
        }
    }

    public void displayStatusText(String statusText) {
        this.mLabelUpdateStatus.setText(statusText);
    }

    protected void displayUpdates() {
    }

    @Override
    public void init() {
        GridPane.setFillHeight((Node)this, (Boolean)true);
        this.getStyleClass().add((Object)"night-theme");
        ColumnConstraints columnLeft = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, false);
        columnLeft.setPercentWidth(50.0);
        ColumnConstraints columnRight = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.RIGHT, false);
        columnRight.setPercentWidth(50.0);
        RowConstraints rowTop = new RowConstraints(50.0, 50.0, 50.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowMiddle = new RowConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, true);
        RowConstraints rowBottom = new RowConstraints(150.0, 150.0, 150.0, Priority.NEVER, VPos.BOTTOM, false);
        this.mLabelUpdateStatus = new Text();
        this.mLabelUpdateStatus.setFill((Paint)Color.web((String)this.mContext.mNightActivatedColor, (double)1.0));
        this.mLabelUpdateStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelUpdateStatus = new TextFlow();
        boxLabelUpdateStatus.setMinHeight(50.0);
        boxLabelUpdateStatus.setPrefHeight(50.0);
        boxLabelUpdateStatus.getChildren().add((Object)this.mLabelUpdateStatus);
        this.mContext.mUtil.setTextBaseline(boxLabelUpdateStatus, this.mLabelUpdateStatus, 30.0);
        GridPane.setConstraints((Node)boxLabelUpdateStatus, (int)0, (int)0, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mButtonFindUnits = new LayoutWidgetIcon(this.mContext, 50.0, "Find units", this.mContext.mFontRegular, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonFindUnits.setOnMouseClicked(this::onTouchFindUnits);
        GridPane.setConstraints((Node)this.mButtonFindUnits, (int)1, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 50.0, 0.0, 0.0));
        this.mLayoutNodeDisplayMain = new StackPane();
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayMain, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayMain, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayMain, (int)0, (int)1, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        this.mLayoutNodeDisplayLeft = new StackPane();
        this.mLayoutNodeDisplayLeft.setMouseTransparent(true);
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayLeft, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayLeft, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayLeft, (int)0, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        this.mLayoutNodeDisplayRight = new StackPane();
        this.mLayoutNodeDisplayRight.setMouseTransparent(true);
        GridPane.setFillWidth((Node)this.mLayoutNodeDisplayRight, (Boolean)true);
        GridPane.setFillHeight((Node)this.mLayoutNodeDisplayRight, (Boolean)true);
        GridPane.setConstraints((Node)this.mLayoutNodeDisplayRight, (int)1, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        LayoutWidgetIcon buttonUpdate = new LayoutWidgetIcon(this.mContext, 120.0, 32.0, null, "night_icon_refresh_small.svg", 24.0, "Update", 48.0, this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        buttonUpdate.setStyle("-fx-background-color: rgb(33,184,148);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        buttonUpdate.setOnMouseClicked(this::onTouchUpdate);
        this.mDarkPane = new Pane();
        this.mDarkPane.setPrefSize(120.0, 32.0);
        this.mDarkPane.setStyle("-fx-background-color:rgba(0,0,0,0.72);");
        this.mDarkPane.setVisible(false);
        this.mContainerButtonUpdate = new StackPane();
        this.mContainerButtonUpdate.getChildren().addAll((Object[])new Node[]{buttonUpdate, this.mDarkPane});
        GridPane.setConstraints((Node)this.mContainerButtonUpdate, (int)0, (int)2, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 111.0, 59.0, 0.0));
        this.mButtonOk = new LayoutWidgetIcon(this.mContext, 134.0, 32.0, null, "Find units", this.mContext.mFontBold, 14.0, this.mContext.mNightActivatedColor);
        this.mButtonOk.setStyle("-fx-background-color: rgb(33,184,148);-fx-background-insets: 0px;-fx-background-radius: 16px;");
        this.mButtonOk.setOnMouseClicked(this::onTouchOk);
        this.mButtonOk.setVisible(false);
        GridPane.setConstraints((Node)this.mButtonOk, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 59.0, 0.0));
        this.mLabelShowAllUnits = new Text("Show all units");
        this.mLabelShowAllUnits.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mLabelShowAllUnits.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelShowAllUnits = new TextFlow();
        boxLabelShowAllUnits.setTextAlignment(TextAlignment.LEFT);
        boxLabelShowAllUnits.setMinHeight(32.0);
        boxLabelShowAllUnits.setPrefHeight(32.0);
        boxLabelShowAllUnits.getChildren().add((Object)this.mLabelShowAllUnits);
        this.mContext.mUtil.setTextBaseline(boxLabelShowAllUnits, this.mLabelShowAllUnits, 21.0);
        GridPane.setConstraints((Node)boxLabelShowAllUnits, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 59.0, 50.0));
        this.mSwitchShowAllUnits = new LayoutWidgetSwitch(this.mContext, 36.0, 22.0);
        this.mSwitchShowAllUnits.setTranslateX(1.0);
        this.mSwitchShowAllUnits.setOnMouseClicked(this::onTouchShowAllUnits);
        GridPane.setConstraints((Node)this.mSwitchShowAllUnits, (int)1, (int)2, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.BOTTOM, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 64.0, 175.0));
        this.mLabelProgressUpdate = new Text("Update");
        this.mLabelProgressUpdate.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mLabelProgressUpdate.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mLabelProgressUpdate.setVisible(false);
        TextFlow boxLabelProgressUpdate = new TextFlow();
        boxLabelProgressUpdate.setTextAlignment(TextAlignment.LEFT);
        boxLabelProgressUpdate.setMinWidth(124.0);
        boxLabelProgressUpdate.setPrefWidth(124.0);
        boxLabelProgressUpdate.getChildren().add((Object)this.mLabelProgressUpdate);
        GridPane.setConstraints((Node)boxLabelProgressUpdate, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(45.0 - this.mLabelProgressUpdate.getBaselineOffset(), 810.0, 0.0, 0.0));
        this.mValueProgressUpdate = new Text("0 %");
        this.mValueProgressUpdate.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mValueProgressUpdate.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mValueProgressUpdate.setVisible(false);
        TextFlow boxValueProgressUpdate = new TextFlow();
        boxValueProgressUpdate.setTextAlignment(TextAlignment.RIGHT);
        boxValueProgressUpdate.setMinWidth(58.0);
        boxValueProgressUpdate.setPrefWidth(58.0);
        boxValueProgressUpdate.getChildren().add((Object)this.mValueProgressUpdate);
        GridPane.setConstraints((Node)boxValueProgressUpdate, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(45.0 - this.mValueProgressUpdate.getBaselineOffset(), 0.0, 0.0, 744.0));
        this.mProgressBarUpdate = new LayoutWidgetProgressBar(this.mContext, 0.0f, 100.0f, 686, 4, this.mContext.mColorGroup[1]);
        this.mProgressBarUpdate.setVisible(false);
        GridPane.setConstraints((Node)this.mProgressBarUpdate, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(38.0, 0.0, 0.0, 0.0));
        this.mLabelProgressValidation = new Text("Validation");
        this.mLabelProgressValidation.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mLabelProgressValidation.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mLabelProgressValidation.setVisible(false);
        TextFlow boxLabelProgressValidation = new TextFlow();
        boxLabelProgressValidation.setTextAlignment(TextAlignment.LEFT);
        boxLabelProgressValidation.setMinWidth(124.0);
        boxLabelProgressValidation.setPrefWidth(124.0);
        boxLabelProgressValidation.getChildren().add((Object)this.mLabelProgressValidation);
        GridPane.setConstraints((Node)boxLabelProgressValidation, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(80.0 - this.mLabelProgressValidation.getBaselineOffset(), 810.0, 0.0, 0.0));
        this.mValueProgressValidation = new Text("0 %");
        this.mValueProgressValidation.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mValueProgressValidation.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mValueProgressValidation.setVisible(false);
        TextFlow boxValueProgressValidation = new TextFlow();
        boxValueProgressValidation.setTextAlignment(TextAlignment.RIGHT);
        boxValueProgressValidation.setMinWidth(58.0);
        boxValueProgressValidation.setPrefWidth(58.0);
        boxValueProgressValidation.getChildren().add((Object)this.mValueProgressValidation);
        GridPane.setConstraints((Node)boxValueProgressValidation, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(80.0 - this.mValueProgressValidation.getBaselineOffset(), 0.0, 0.0, 744.0));
        this.mProgressBarValidation = new LayoutWidgetProgressBar(this.mContext, 0.0f, 100.0f, 686, 4, this.mContext.mColorGroup[2]);
        this.mProgressBarValidation.setVisible(false);
        GridPane.setConstraints((Node)this.mProgressBarValidation, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(73.0, 0.0, 0.0, 0.0));
        this.mLabelProgressUnits = new Text("Units");
        this.mLabelProgressUnits.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mLabelProgressUnits.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mLabelProgressUnits.setVisible(false);
        TextFlow boxLabelProgressUnits = new TextFlow();
        boxLabelProgressUnits.setTextAlignment(TextAlignment.LEFT);
        boxLabelProgressUnits.setMinWidth(124.0);
        boxLabelProgressUnits.setPrefWidth(124.0);
        boxLabelProgressUnits.getChildren().add((Object)this.mLabelProgressUnits);
        GridPane.setConstraints((Node)boxLabelProgressUnits, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(115.0 - this.mLabelProgressUnits.getBaselineOffset(), 810.0, 0.0, 0.0));
        this.mValueProgressUnits = new Text("0 %");
        this.mValueProgressUnits.setFill((Paint)Color.web((String)this.mContext.mNightGraphicsColor, (double)1.0));
        this.mValueProgressUnits.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mValueProgressUnits.setVisible(false);
        TextFlow boxValueProgressUnits = new TextFlow();
        boxValueProgressUnits.setTextAlignment(TextAlignment.RIGHT);
        boxValueProgressUnits.setMinWidth(58.0);
        boxValueProgressUnits.setPrefWidth(58.0);
        boxValueProgressUnits.getChildren().add((Object)this.mValueProgressUnits);
        GridPane.setConstraints((Node)boxValueProgressUnits, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(115.0 - this.mValueProgressUnits.getBaselineOffset(), 0.0, 0.0, 744.0));
        this.mProgressBarUnits = new LayoutWidgetProgressBar(this.mContext, 0.0f, 100.0f, 686, 4, this.mContext.mColorGroup[3]);
        this.mProgressBarUnits.setVisible(false);
        GridPane.setConstraints((Node)this.mProgressBarUnits, (int)0, (int)2, (int)2, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(108.0, 0.0, 0.0, 0.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeft, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowMiddle, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{boxLabelUpdateStatus, this.mButtonFindUnits, this.mLayoutNodeDisplayMain, this.mLayoutNodeDisplayLeft, this.mLayoutNodeDisplayRight, this.mContainerButtonUpdate, boxLabelShowAllUnits, this.mSwitchShowAllUnits, this.mButtonOk, boxLabelProgressUpdate, boxValueProgressUpdate, this.mProgressBarUpdate, boxLabelProgressValidation, boxValueProgressValidation, this.mProgressBarValidation, boxLabelProgressUnits, boxValueProgressUnits, this.mProgressBarUnits});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchFindUnits(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onFindUnits();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchShowAllUnits(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onShowAllUnits(this.mSwitchShowAllUnits.onSwitch());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchOk(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onOk();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchUpdate(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onUpdate();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

