/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.JsonHelpFirmwareUpdateText;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutViewUpdateListItem;
import com.elinchrom.software.LayoutWidgetIcon;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewUpdateDetail
extends GridPane
implements LayoutView {
    public Context mContext;
    public boolean mIsInitialized = false;
    public ScrollPane mHelpUpdateDetailScrollView = null;
    public GridPane mScrollContentPane = null;
    public ImageView mImageProduct = null;
    public ImageView mHelpUpdateImage = null;
    public LayoutWidgetIcon mFirmwareMark = null;
    public Text mTextUnitId = null;
    public Text mTextFriendlyName = null;
    public Text mFirmwareStatus = null;
    public Text mValueProductName = null;
    public Text mValueCurrentFirmware = null;
    public Text mValueLatestFirmware = null;
    public Text mValueFirmwareUpdateMode = null;
    public Text mTextReleaseNoteTitle = null;
    public Text mTextReleaseNoteText = null;
    public Text mHelpUpdateTitle = null;
    public Text mHelpUpdateText = null;
    public String mReleaseNoteUrl = "";
    public String mUpdateModeFaqUrl = "";

    public LayoutViewUpdateDetail(Context context) {
        this.mContext = context;
    }

    public void displayUpdateListItem(LayoutViewUpdateListItem layoutViewUpdateListItem) {
        ElinchromDevice elinchromDevice = layoutViewUpdateListItem.mElinchromDevice;
        URL helpUpdateImageUrl = null;
        URL deviceImageUrl = elinchromDevice.getImageUrl();
        String firmwareUpdateMode = elinchromDevice.valueGetByte(60) == 3 ? "Enabled" : "Disabled";
        String versionFirmwareCurrent = elinchromDevice.getFirmwareVersion();
        String versionFirmwareLatest = this.mContext.mUtil.getLatestFirmwareVersion(layoutViewUpdateListItem.mJsonNewsFirmware);
        boolean hasNewFirmware = this.mContext.mIsInternetAvailable && !elinchromDevice.isFirmwareVersionLatest();
        this.mReleaseNoteUrl = layoutViewUpdateListItem.mJsonNewsFirmware.release_note_url;
        this.mTextReleaseNoteTitle.setText(layoutViewUpdateListItem.mJsonNewsFirmware.release_title);
        this.mTextReleaseNoteText.setText(layoutViewUpdateListItem.mJsonNewsFirmware.release_note);
        this.mValueFirmwareUpdateMode.setText(firmwareUpdateMode);
        this.mTextUnitId.setText(elinchromDevice.getSkyportId());
        this.mTextFriendlyName.setText(elinchromDevice.getFriendlyName());
        this.mValueProductName.setText(elinchromDevice.getProductName());
        this.mValueCurrentFirmware.setText(versionFirmwareCurrent);
        this.mValueLatestFirmware.setText(versionFirmwareLatest);
        this.mFirmwareMark.setVisible(hasNewFirmware);
        this.mFirmwareStatus.setVisible(!hasNewFirmware);
        if (layoutViewUpdateListItem.mJsonHelpContents == null) {
            this.mHelpUpdateTitle.setText("");
            this.mHelpUpdateText.setText("");
            this.mUpdateModeFaqUrl = "";
        } else {
            for (JsonHelpFirmwareUpdateText jsonHelpFirmwareUpdateText : layoutViewUpdateListItem.mJsonHelpContents.update_mode_texts) {
                if (!Arrays.asList(jsonHelpFirmwareUpdateText.operationg_systems).contains(this.mContext.mUtil.isWindows() ? "WINDOWS" : "MACOS")) continue;
                this.mHelpUpdateText.setText(jsonHelpFirmwareUpdateText.update_mode_text);
                break;
            }
            if (!layoutViewUpdateListItem.mJsonHelpContents.update_mode_image_name.equals("")) {
                try {
                    helpUpdateImageUrl = new File(this.mContext.mFolderImages + layoutViewUpdateListItem.mJsonHelpContents.update_mode_image_name).toURI().toURL();
                }
                catch (Throwable t) {
                    this.mContext.mLogger.printStackTrace(t);
                }
            }
            this.mUpdateModeFaqUrl = layoutViewUpdateListItem.mJsonHelpContents.update_mode_faq_url;
            this.mHelpUpdateTitle.setText(layoutViewUpdateListItem.mJsonHelpContents.update_mode_title);
        }
        if (helpUpdateImageUrl != null) {
            this.mHelpUpdateImage.setImage(new Image(helpUpdateImageUrl.toString()));
        } else {
            this.mHelpUpdateImage.setImage(null);
        }
        if (deviceImageUrl != null) {
            this.mImageProduct.setImage(new Image(deviceImageUrl.toString()));
        } else {
            this.mImageProduct.setImage(null);
        }
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        ColumnConstraints columnLeftMargin = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnLeft = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnCenter = new ColumnConstraints(632.0, 632.0, 632.0, Priority.NEVER, HPos.LEFT, false);
        ColumnConstraints columnRight = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, HPos.LEFT, false);
        ColumnConstraints columnRightMargin = new ColumnConstraints(50.0, 50.0, 50.0, Priority.NEVER, HPos.LEFT, false);
        RowConstraints rowTitle = new RowConstraints(265.0, 265.0, 265.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowHelp = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, false);
        RowConstraints rowImage = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, false);
        RowConstraints rowNote = new RowConstraints(-1.0, -1.0, Double.MAX_VALUE, Priority.ALWAYS, VPos.TOP, false);
        this.mImageProduct = new ImageView();
        this.mImageProduct.setFitWidth(100.0);
        this.mImageProduct.setFitHeight(100.0);
        this.mImageProduct.setPreserveRatio(true);
        this.mImageProduct.setSmooth(true);
        GridPane.setConstraints((Node)this.mImageProduct, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(26.0, 0.0, 0.0, 0.0));
        this.mTextUnitId = new Text("");
        this.mTextUnitId.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextUnitId.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxUnitId = new TextFlow();
        boxUnitId.setTextAlignment(TextAlignment.LEFT);
        boxUnitId.setTranslateX(125.0);
        boxUnitId.getChildren().add((Object)this.mTextUnitId);
        this.mContext.mUtil.setTextBaseline(boxUnitId, this.mTextUnitId, 53.0);
        GridPane.setConstraints((Node)boxUnitId, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mTextFriendlyName = new Text("");
        this.mTextFriendlyName.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextFriendlyName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBlack, 28.0));
        TextFlow boxFriendlyName = new TextFlow();
        boxFriendlyName.setTextAlignment(TextAlignment.LEFT);
        boxFriendlyName.setTranslateX(125.0);
        boxFriendlyName.getChildren().add((Object)this.mTextFriendlyName);
        this.mContext.mUtil.setTextBaseline(boxFriendlyName, this.mTextFriendlyName, 85.0);
        GridPane.setConstraints((Node)boxFriendlyName, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mFirmwareStatus = new Text(this.mContext.mIsInternetAvailable ? "Your firmware is up to date" : "No Internet");
        this.mFirmwareStatus.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFirmwareStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxFirmwareStatus = new TextFlow();
        boxFirmwareStatus.setTextAlignment(TextAlignment.LEFT);
        boxFirmwareStatus.setTranslateX(125.0);
        boxFirmwareStatus.getChildren().add((Object)this.mFirmwareStatus);
        this.mContext.mUtil.setTextBaseline(boxFirmwareStatus, this.mFirmwareStatus, 110.0);
        GridPane.setConstraints((Node)boxFirmwareStatus, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mFirmwareMark = new LayoutWidgetIcon(this.mContext, -1.0, 210.0, null, "firmware_mark.svg", 3.5, "A new firmware is available", 16.0, this.mContext.mFontRegular, 14.0, this.mContext.mDayActivatedColor);
        this.mFirmwareMark.setVisible(false);
        this.mFirmwareMark.setTranslateX(125.0);
        GridPane.setConstraints((Node)this.mFirmwareMark, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        Text labelProductName = new Text("Product");
        labelProductName.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        labelProductName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelProductName = new TextFlow();
        boxLabelProductName.setTextAlignment(TextAlignment.LEFT);
        boxLabelProductName.getChildren().add((Object)labelProductName);
        GridPane.setConstraints((Node)boxLabelProductName, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(167.0 - labelProductName.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mValueProductName = new Text("");
        this.mValueProductName.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mValueProductName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxValueProductName = new TextFlow();
        boxValueProductName.setTextAlignment(TextAlignment.LEFT);
        boxValueProductName.getChildren().add((Object)this.mValueProductName);
        GridPane.setConstraints((Node)boxValueProductName, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(167.0 - this.mValueProductName.getBaselineOffset(), 0.0, 0.0, 0.0));
        Text labelCurrentFirmware = new Text("Current firmware");
        labelCurrentFirmware.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        labelCurrentFirmware.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelCurrentFirmware = new TextFlow();
        boxLabelCurrentFirmware.setTextAlignment(TextAlignment.LEFT);
        boxLabelCurrentFirmware.getChildren().add((Object)labelCurrentFirmware);
        GridPane.setConstraints((Node)boxLabelCurrentFirmware, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(192.0 - labelCurrentFirmware.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mValueCurrentFirmware = new Text("");
        this.mValueCurrentFirmware.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mValueCurrentFirmware.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxValueCurrentFirmware = new TextFlow();
        boxValueCurrentFirmware.setTextAlignment(TextAlignment.LEFT);
        boxValueCurrentFirmware.getChildren().add((Object)this.mValueCurrentFirmware);
        GridPane.setConstraints((Node)boxValueCurrentFirmware, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(192.0 - this.mValueCurrentFirmware.getBaselineOffset(), 0.0, 0.0, 0.0));
        Text labelLatestFirmware = new Text("Latest firmware");
        labelLatestFirmware.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        labelLatestFirmware.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelLatestFirmware = new TextFlow();
        boxLabelLatestFirmware.setTextAlignment(TextAlignment.LEFT);
        boxLabelLatestFirmware.getChildren().add((Object)labelLatestFirmware);
        GridPane.setConstraints((Node)boxLabelLatestFirmware, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(217.0 - labelLatestFirmware.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mValueLatestFirmware = new Text("");
        this.mValueLatestFirmware.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mValueLatestFirmware.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxValueLatestFirmware = new TextFlow();
        boxValueLatestFirmware.setTextAlignment(TextAlignment.LEFT);
        boxValueLatestFirmware.getChildren().add((Object)this.mValueLatestFirmware);
        GridPane.setConstraints((Node)boxValueLatestFirmware, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(217.0 - this.mValueLatestFirmware.getBaselineOffset(), 0.0, 0.0, 0.0));
        Text labelFirmwareUpdateMode = new Text("Firmware update mode");
        labelFirmwareUpdateMode.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        labelFirmwareUpdateMode.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 14.0));
        TextFlow boxLabelFirmwareUpdateMode = new TextFlow();
        boxLabelFirmwareUpdateMode.setTextAlignment(TextAlignment.LEFT);
        boxLabelFirmwareUpdateMode.getChildren().add((Object)labelFirmwareUpdateMode);
        GridPane.setConstraints((Node)boxLabelFirmwareUpdateMode, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(242.0 - labelFirmwareUpdateMode.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mValueFirmwareUpdateMode = new Text("");
        this.mValueFirmwareUpdateMode.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mValueFirmwareUpdateMode.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxValueFirmwareUpdateMode = new TextFlow();
        boxValueFirmwareUpdateMode.setTextAlignment(TextAlignment.LEFT);
        boxValueFirmwareUpdateMode.getChildren().add((Object)this.mValueFirmwareUpdateMode);
        GridPane.setConstraints((Node)boxValueFirmwareUpdateMode, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.RIGHT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(242.0 - this.mValueFirmwareUpdateMode.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mHelpUpdateTitle = new Text("");
        this.mHelpUpdateTitle.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mHelpUpdateTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.0));
        TextFlow boxHelpUpdateTitle = new TextFlow();
        boxHelpUpdateTitle.setTextAlignment(TextAlignment.LEFT);
        boxHelpUpdateTitle.getChildren().add((Object)this.mHelpUpdateTitle);
        boxHelpUpdateTitle.setOnMouseClicked(this::onTouchHelpUpdateDescription);
        GridPane.setConstraints((Node)boxHelpUpdateTitle, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(30.0 - this.mHelpUpdateTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mHelpUpdateText = new Text("");
        this.mHelpUpdateText.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mHelpUpdateText.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxHelpUpdateText = new TextFlow();
        boxHelpUpdateText.setTextAlignment(TextAlignment.LEFT);
        boxHelpUpdateText.setLineSpacing(25.0 - this.mHelpUpdateText.getFont().getSize() * 1.25);
        boxHelpUpdateText.getChildren().add((Object)this.mHelpUpdateText);
        GridPane.setConstraints((Node)boxHelpUpdateText, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(62.0 - this.mHelpUpdateText.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mHelpUpdateImage = new ImageView();
        this.mHelpUpdateImage.setFitWidth(512.0);
        this.mHelpUpdateImage.setPreserveRatio(true);
        this.mHelpUpdateImage.setSmooth(true);
        this.mHelpUpdateImage.setOnMouseClicked(this::onTouchHelpUpdateDescription);
        GridPane.setConstraints((Node)this.mHelpUpdateImage, (int)2, (int)2, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(20.0, 0.0, 0.0, 0.0));
        this.mTextReleaseNoteTitle = new Text("");
        this.mTextReleaseNoteTitle.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mTextReleaseNoteTitle.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontBold, 21.0));
        TextFlow boxReleaseNoteTitle = new TextFlow();
        boxReleaseNoteTitle.setTextAlignment(TextAlignment.LEFT);
        boxReleaseNoteTitle.getChildren().add((Object)this.mTextReleaseNoteTitle);
        boxReleaseNoteTitle.setOnMouseClicked(this::onTouchReleaseNote);
        GridPane.setConstraints((Node)boxReleaseNoteTitle, (int)2, (int)3, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(41.0 - this.mTextReleaseNoteTitle.getBaselineOffset(), 0.0, 0.0, 0.0));
        this.mTextReleaseNoteText = new Text("");
        this.mTextReleaseNoteText.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextReleaseNoteText.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxReleaseNoteText = new TextFlow();
        boxReleaseNoteText.setTextAlignment(TextAlignment.LEFT);
        boxReleaseNoteText.setLineSpacing(25.0 - this.mTextReleaseNoteText.getFont().getSize() * 1.25);
        boxReleaseNoteText.getChildren().add((Object)this.mTextReleaseNoteText);
        GridPane.setConstraints((Node)boxReleaseNoteText, (int)2, (int)3, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.ALWAYS, (Insets)new Insets(73.0 - this.mTextReleaseNoteText.getBaselineOffset(), 0.0, 45.0, 0.0));
        this.mScrollContentPane = new GridPane();
        this.mScrollContentPane.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 50px 0px 50px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        this.mScrollContentPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnLeftMargin, columnLeft, columnCenter, columnRight, columnRightMargin});
        this.mScrollContentPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTitle, rowHelp, rowImage, rowNote});
        this.mScrollContentPane.getChildren().addAll((Object[])new Node[]{this.mImageProduct, boxUnitId, boxFriendlyName, boxFirmwareStatus, this.mFirmwareMark, boxLabelProductName, boxValueProductName, boxLabelCurrentFirmware, boxValueCurrentFirmware, boxLabelLatestFirmware, boxValueLatestFirmware, boxLabelFirmwareUpdateMode, boxValueFirmwareUpdateMode, boxHelpUpdateTitle, boxHelpUpdateText, this.mHelpUpdateImage, boxReleaseNoteTitle, boxReleaseNoteText});
        GridPane.setConstraints((Node)this.mScrollContentPane, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.NEVER);
        this.getStyleClass().addAll((Object[])new String[]{"day-theme"});
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.LEFT, true);
        column.setPercentWidth(100.0);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        row.setPercentHeight(100.0);
        this.mHelpUpdateDetailScrollView = new ScrollPane();
        this.mHelpUpdateDetailScrollView.setStyle("-fx-background-color:#" + this.mContext.mDayActivatedColor + ";");
        this.mHelpUpdateDetailScrollView.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.mHelpUpdateDetailScrollView.setFitToWidth(true);
        this.mHelpUpdateDetailScrollView.setContent((Node)this.mScrollContentPane);
        GridPane.setConstraints((Node)this.mHelpUpdateDetailScrollView, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.ALWAYS, (Priority)Priority.ALWAYS);
        GridPane.setFillHeight((Node)this.mHelpUpdateDetailScrollView, (Boolean)true);
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{row});
        this.getChildren().addAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchHelpUpdateDescription(MouseEvent event) {
        try {
            this.mContext.mUtil.openWebpage(new URL(this.mUpdateModeFaqUrl));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchReleaseNote(MouseEvent event) {
        try {
            this.mContext.mUtil.openWebpage(new URL(this.mReleaseNoteUrl));
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }

    public void setSizeSmall() {
        if (this.isInitialized()) {
            this.mHelpUpdateDetailScrollView.setContent(null);
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView, this.mScrollContentPane});
            this.getChildren().add((Object)this.mScrollContentPane);
        }
    }

    public void setSizeBig() {
        if (this.isInitialized()) {
            this.getChildren().removeAll((Object[])new Node[]{this.mHelpUpdateDetailScrollView, this.mScrollContentPane});
            this.mHelpUpdateDetailScrollView.setContent((Node)this.mScrollContentPane);
            this.getChildren().add((Object)this.mHelpUpdateDetailScrollView);
        }
    }
}

