/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.JsonHelpContents;
import com.elinchrom.software.JsonHelpFirmwareUpdate;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.LayoutView;
import com.elinchrom.software.LayoutWidgetIcon;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutViewUpdateListItem
extends GridPane
implements LayoutView {
    public Context mContext;
    public ElinchromDevice mElinchromDevice;
    public JsonHelpFirmwareUpdate mJsonHelpFirmwareUpdate;
    public JsonNewsFirmware mJsonNewsFirmware;
    public JsonHelpContents mJsonHelpContents;
    public URL mImageUrl;
    public boolean mIsInitialized = false;
    public boolean mIsSelected = false;
    public boolean mHasNewFirmware = false;
    public boolean mHasNewFirmwareSav = false;
    public boolean mIsUpdateMode = false;
    public LayoutWidgetIcon mIconCheckbox = null;
    public LayoutWidgetIcon mIconConnection = null;
    public LayoutWidgetIcon mIconSignal = null;
    public LayoutWidgetIcon mFirmwareMark = null;
    public LayoutWidgetIcon mSavSelectVersion = null;
    public LayoutWidgetIcon mSavExtractFirmware = null;
    public ImageView mImageUnit = null;
    public Text mTextProductName = null;
    public Text mTextProductId = null;
    public Text mFirmwareStatus = null;
    public LayoutWidgetIcon mIconStatus = null;
    public LayoutWidgetIcon mLineMark = null;

    public LayoutViewUpdateListItem(Context context, ElinchromDevice flashDevice, JsonHelpFirmwareUpdate jsonHelpFirmwareUpdate, JsonNewsFirmware jsonNewsFirmware, JsonHelpContents jsonHelpContents, URL imageUrl) {
        this.mContext = context;
        this.mElinchromDevice = flashDevice;
        this.mJsonHelpFirmwareUpdate = jsonHelpFirmwareUpdate;
        this.mJsonNewsFirmware = jsonNewsFirmware;
        this.mJsonHelpContents = jsonHelpContents;
        this.mImageUrl = imageUrl;
        this.mIsSelected = true;
    }

    public void disableSav() {
        this.mSavSelectVersion.setVisible(false);
        this.mSavExtractFirmware.setVisible(false);
        this.displayFirmwareStatus(this.mContext.mIsInternetAvailable && !this.mElinchromDevice.isFirmwareVersionLatest());
    }

    public void enableSav() {
        this.mSavSelectVersion.setVisible(true);
        this.mSavExtractFirmware.setVisible(true);
        this.mFirmwareStatus.setVisible(false);
        this.mFirmwareMark.setVisible(false);
        this.displayFirmwareStatus(this.mContext.mIsInternetAvailable && !this.mElinchromDevice.isFirmwareVersionLatest());
    }

    public void setIsSav(boolean isSav) {
        if (isSav) {
            this.enableSav();
        } else {
            this.disableSav();
        }
    }

    public void displayCheckbox() {
        this.mIconCheckbox.setIndex(this.mHasNewFirmware ? (this.mIsUpdateMode && this.mIsSelected ? 2 : 1) : 0);
        this.mIconCheckbox.setVisible(true);
    }

    public void displayUpdateConnectionType(int connectionType) {
        this.mIconConnection.setIndex(connectionType);
    }

    public void displayFirmwareStatus(boolean hasNewFirmware) {
        if (this.mContext.mModuleManagerSdk.valueGetByte(48) == 1) {
            boolean bl = this.mHasNewFirmware = this.mContext.mLayoutPresenterUpdate.mHasNewFirmwareSav != null && this.mContext.mLayoutPresenterUpdate.mHasNewFirmwareSav.mElinchromDevice.equals(this.mElinchromDevice);
            if (this.mHasNewFirmware) {
                this.mSavSelectVersion.setText("File selected");
            } else {
                this.mSavSelectVersion.setText("Select version");
            }
        } else {
            this.mHasNewFirmware = hasNewFirmware;
            this.mFirmwareStatus.setText(this.mContext.mIsInternetAvailable ? "Your firmware is up to date" : "No Internet");
            this.mFirmwareStatus.setVisible(!hasNewFirmware);
            this.mFirmwareMark.setVisible(hasNewFirmware);
        }
        this.displayCheckbox();
    }

    public void displayFirmwareUpdateMode(boolean isFirmwareUpdateMode) {
        this.mIsUpdateMode = isFirmwareUpdateMode;
        this.displayCheckbox();
    }

    public void displayId(String id) {
        this.mTextProductId.setText(id);
    }

    public void displayImage(URL url) {
        if (url != null) {
            this.mImageUnit.setImage(new Image(url.toString()));
        }
    }

    public void displayMark(boolean showMark) {
        this.mLineMark.setVisible(showMark);
    }

    public void displayName(String name) {
        this.mTextProductName.setText(name);
    }

    public void displayResult(int result) {
        this.displayStartedFirmwareStatus(result == 0 ? "Update successful" : "Update failed");
        this.mIconStatus.setIndex(result == 0 ? 0 : 1);
        this.mIconStatus.setVisible(true);
    }

    public void displayResultExtract(int result) {
        this.displayStartedFirmwareStatus(result == 0 ? "Extract successful" : "Extract failed");
        this.mIconStatus.setIndex(result == 0 ? 0 : 1);
        this.mIconStatus.setVisible(true);
    }

    public void displaySignalStrength(int signalStrength) {
        int previousIndex = this.mIconSignal.getIndex();
        int newIndex = signalStrength < (previousIndex == 0 ? 30 : 20) ? 0 : (signalStrength < (previousIndex == 1 ? 55 : 45) ? 1 : (signalStrength < (previousIndex == 2 ? 80 : 70) ? 2 : 3));
        if (newIndex != previousIndex) {
            this.mIconSignal.setIndex(newIndex);
        }
    }

    public void displayStartedFirmwareStatus(String text) {
        this.mFirmwareStatus.setText(text);
        this.mFirmwareStatus.setVisible(true);
        this.mFirmwareMark.setVisible(false);
        this.mSavSelectVersion.setVisible(false);
        this.mSavExtractFirmware.setVisible(false);
        this.mIconCheckbox.setVisible(false);
    }

    @Override
    public Node getViewNode() {
        return this;
    }

    @Override
    public void init() {
        this.setOnMouseClicked(this::onTouchUnit);
        this.setStyle("-fx-background-color: rgb(255,255,255);-fx-background-insets: 0px 50px 0px 50px;-fx-background-radius: 3px 3px 3px 3px / 3px 3px 3px 3px;");
        ColumnConstraints columnCheckbox = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnCheckbox.setPercentWidth(16.586);
        ColumnConstraints columnImage = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnImage.setPercentWidth(13.019);
        ColumnConstraints columnName = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnName.setPercentWidth(30.49);
        ColumnConstraints columnStatus = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnStatus.setPercentWidth(24.158);
        ColumnConstraints columnRight = new ColumnConstraints(0.0, -1.0, Double.MAX_VALUE, Priority.NEVER, HPos.LEFT, false);
        columnRight.setPercentWidth(15.747);
        RowConstraints rowTop = new RowConstraints(35.0, 35.0, 35.0, Priority.NEVER, VPos.TOP, false);
        RowConstraints rowBottom = new RowConstraints(37.0, 37.0, 37.0, Priority.NEVER, VPos.TOP, false);
        List<String> imageCheckbox = Arrays.asList("day_checkbox_disabled.svg", "day_checkbox_enabled_black.svg", "day_checkbox_activated.svg");
        this.mIconCheckbox = this.mContext.mUtil.factoryIconSet(22, 22, imageCheckbox, 0);
        this.mIconCheckbox.setOnMouseClicked(this::onTouchSelectionCheckbox);
        GridPane.setConstraints((Node)this.mIconCheckbox, (int)0, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 81.0));
        this.mImageUnit = new ImageView();
        this.mImageUnit.setFitWidth(64.0);
        this.mImageUnit.setFitHeight(64.0);
        this.mImageUnit.setPreserveRatio(true);
        this.mImageUnit.setSmooth(true);
        GridPane.setConstraints((Node)this.mImageUnit, (int)1, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        this.mTextProductId = new Text("000000");
        this.mTextProductId.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mTextProductId.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxProductId = new TextFlow();
        boxProductId.setTextAlignment(TextAlignment.LEFT);
        boxProductId.setPrefHeight(35.0);
        boxProductId.setMaxHeight(35.0);
        boxProductId.getChildren().add((Object)this.mTextProductId);
        this.mContext.mUtil.setTextBaseline(boxProductId, this.mTextProductId, 24.0);
        GridPane.setConstraints((Node)boxProductId, (int)2, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mTextProductName = new Text("");
        this.mTextProductName.setFill((Paint)Color.web((String)this.mContext.mDayActivatedColor, (double)1.0));
        this.mTextProductName.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontSemibold, 17.5));
        TextFlow boxProductName = new TextFlow();
        boxProductName.setTextAlignment(TextAlignment.LEFT);
        boxProductName.setPrefHeight(37.0);
        boxProductName.setMaxHeight(37.0);
        boxProductName.getChildren().add((Object)this.mTextProductName);
        this.mContext.mUtil.setTextBaseline(boxProductName, this.mTextProductName, 21.0);
        GridPane.setConstraints((Node)boxProductName, (int)2, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        List<String> imageConnection = Arrays.asList("day_connection_usb.svg", "day_connection_usb.svg", "day_connection_ble.svg", "day_connection_skyport.svg");
        this.mIconConnection = this.mContext.mUtil.factoryIconSet(24, 24, imageConnection, 0);
        this.mIconConnection.setTranslateY(7.0);
        GridPane.setConstraints((Node)this.mIconConnection, (int)3, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        List<String> imageSignal = Arrays.asList("day_signal_0.svg", "day_signal_1.svg", "day_signal_2.svg", "day_signal_3.svg");
        this.mIconSignal = this.mContext.mUtil.factoryIconSet(24, 24, imageSignal, 0);
        this.mIconSignal.setTranslateX(48.0);
        this.mIconSignal.setTranslateY(7.0);
        GridPane.setConstraints((Node)this.mIconSignal, (int)3, (int)0, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mFirmwareStatus = new Text(this.mContext.mIsInternetAvailable ? "Your firmware is up to date" : "No Internet");
        this.mFirmwareStatus.setFill((Paint)Color.web((String)this.mContext.mDayGraphicsColor, (double)1.0));
        this.mFirmwareStatus.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        TextFlow boxFirmwareStatus = new TextFlow();
        boxFirmwareStatus.setTextAlignment(TextAlignment.LEFT);
        boxFirmwareStatus.setTranslateX(1.0);
        boxFirmwareStatus.getChildren().add((Object)this.mFirmwareStatus);
        this.mContext.mUtil.setTextBaseline(boxFirmwareStatus, this.mFirmwareStatus, 21.0);
        GridPane.setConstraints((Node)boxFirmwareStatus, (int)3, (int)1, (int)2, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mFirmwareMark = new LayoutWidgetIcon(this.mContext, -1.0, 32.0, null, "firmware_mark.svg", 3.5, "A new firmware is available", 16.0, this.mContext.mFontRegular, 14.0, this.mContext.mDayActivatedColor);
        this.mFirmwareMark.setVisible(false);
        this.mFirmwareMark.setTranslateX(1.0);
        GridPane.setConstraints((Node)this.mFirmwareMark, (int)3, (int)1, (int)1, (int)1, (HPos)HPos.LEFT, (VPos)VPos.TOP);
        this.mSavSelectVersion = new LayoutWidgetIcon(this.mContext, -1.0, 32.0, null, null, 0.0, "Select version", 0.0, this.mContext.mFontRegular, 14.0, this.mContext.mColorGroup[3]);
        this.mSavSelectVersion.setVisible(false);
        this.mSavSelectVersion.setOnMouseClicked(this::onTouchSavSelectVersion);
        GridPane.setConstraints((Node)this.mSavSelectVersion, (int)3, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(35.0, 0.0, 0.0, 0.0));
        this.mSavExtractFirmware = new LayoutWidgetIcon(this.mContext, -1.0, 32.0, null, null, 0.0, "Extract firmware", 0.0, this.mContext.mFontRegular, 14.0, this.mContext.mColorGroup[4]);
        this.mSavExtractFirmware.setVisible(false);
        this.mSavExtractFirmware.setOnMouseClicked(this::onTouchSavExtractFirmware);
        GridPane.setConstraints((Node)this.mSavExtractFirmware, (int)3, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.TOP, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(35.0, 0.0, 0.0, 103.0));
        List<String> imageStatus = Arrays.asList("success.svg", "failure.svg");
        this.mIconStatus = this.mContext.mUtil.factoryIconSet(22, 22, imageStatus, 0);
        this.mIconStatus.setVisible(false);
        GridPane.setConstraints((Node)this.mIconStatus, (int)4, (int)0, (int)1, (int)2, (HPos)HPos.LEFT, (VPos)VPos.CENTER);
        this.mLineMark = new LayoutWidgetIcon(this.mContext, 36.0, 36.0, "line_mark.svg", "", this.mContext.mFontRegular, 7.5, this.mContext.mNightActivatedColor);
        this.mLineMark.setTranslateX(-32.0);
        this.mLineMark.setVisible(false);
        GridPane.setConstraints((Node)this.mLineMark, (int)4, (int)0, (int)1, (int)2, (HPos)HPos.RIGHT, (VPos)VPos.CENTER, (Priority)Priority.NEVER, (Priority)Priority.NEVER, (Insets)new Insets(0.0, 0.0, 0.0, 81.0));
        this.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{columnCheckbox, columnImage, columnName, columnStatus, columnRight});
        this.getRowConstraints().addAll((Object[])new RowConstraints[]{rowTop, rowBottom});
        this.getChildren().addAll((Object[])new Node[]{this.mIconCheckbox, this.mImageUnit, boxProductId, boxProductName, this.mIconConnection, this.mIconSignal, boxFirmwareStatus, this.mFirmwareMark, this.mSavSelectVersion, this.mSavExtractFirmware, this.mIconStatus, this.mLineMark});
    }

    @Override
    public boolean isInitialized() {
        return this.mIsInitialized;
    }

    public void onTouchUnit(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onUnit(this);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSelectionCheckbox(MouseEvent event) {
        try {
            if (this.mHasNewFirmware && this.mIsUpdateMode) {
                this.mIsSelected = !this.mIsSelected;
                this.mIconCheckbox.setIndex(this.mIsSelected ? 2 : 1);
            } else if (this.mHasNewFirmware && !this.mContext.mLayoutPresenterMessages.displayFindUnitsMessageIfNeeded(this.mContext.mLayoutPresenterUpdate)) {
                this.mContext.mLayoutPresenterUpdate.onFindUnits();
            }
            event.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSavSelectVersion(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onSavSelectVersion(this);
            event.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchSavExtractFirmware(MouseEvent event) {
        try {
            this.mContext.mLayoutPresenterUpdate.onSavExtractFirmware(this);
            event.consume();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.mIsInitialized = isInitialized;
    }
}

