/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.GestureHandler;
import com.elinchrom.software.GestureHandlerLongPress;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;

public class LayoutWidgetIcon
extends StackPane {
    public Context mContext;
    public Map<String, ArrayList<Parent>> mImageNodes = new TreeMap<String, ArrayList<Parent>>();
    public Text mTextNode = null;
    public String mTint = "";
    public int mIndex = 0;
    public boolean mIsEnabled = true;
    public Pane mIconPane = null;
    public Pane mPressedPane = null;

    public LayoutWidgetIcon(Context context, double height, String text, URL font, double fontSize, String textColor) {
        this(context, -1.0, height, null, null, 0.0, text, 0.0, font, fontSize, textColor);
    }

    public LayoutWidgetIcon(Context context, double height, String backgroundName, String text, URL font, double fontSize, String textColor) {
        this(context, 0.0, height, backgroundName, text, font, fontSize, textColor);
    }

    public LayoutWidgetIcon(Context context, double width, double height, String backgroundName, String text, URL font, double fontSize, String textColor) {
        this.mContext = context;
        this.setAlignment(Pos.TOP_LEFT);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.MAX_VALUE, height);
        if (backgroundName != null) {
            Parent background = this.mContext.mUtil.loadImageNode(backgroundName);
            this.mIconPane = new Pane();
            this.mIconPane.getChildren().add((Object)background);
            HBox iconBox = new HBox();
            iconBox.setAlignment(Pos.CENTER);
            iconBox.setFillHeight(false);
            iconBox.setPrefSize(width, height);
            iconBox.setMaxSize(Double.MAX_VALUE, height);
            iconBox.getChildren().add((Object)this.mIconPane);
            this.getChildren().add((Object)iconBox);
        }
        this.mTextNode = new Text(text);
        this.mTextNode.setFill((Paint)Color.web((String)textColor, (double)1.0));
        this.mTextNode.setFont(this.mContext.mUtil.loadFont(font, fontSize));
        TextFlow textBox = new TextFlow();
        textBox.setTextAlignment(TextAlignment.CENTER);
        textBox.setMinHeight(height);
        textBox.setPrefSize(width, height);
        textBox.setMaxSize(Double.MAX_VALUE, height);
        textBox.getChildren().add((Object)this.mTextNode);
        this.mContext.mUtil.setTextBaseline(textBox, this.mTextNode, 0.5 * height + 5.0);
        this.mPressedPane = new Pane();
        this.mPressedPane.setPrefSize(width, height);
        this.mPressedPane.getStyleClass().add((Object)"pressed-mask");
        this.mPressedPane.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{textBox, this.mPressedPane});
    }

    public LayoutWidgetIcon(Context context, double width, double height, String backgroundName, String iconName, double iconCenter, String text, double textLeft, URL font, double fontSize, String textColor) {
        this(context, width, height, backgroundName, iconName, iconCenter, text, textLeft, 0.0, font, fontSize, textColor);
    }

    public LayoutWidgetIcon(Context context, double width, double height, String backgroundName, String iconName, double iconCenter, String text, double textLeft, double textRight, URL font, double fontSize, String textColor) {
        this.mContext = context;
        this.setAlignment(Pos.TOP_LEFT);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.MAX_VALUE, height);
        if (backgroundName != null) {
            Parent background = this.mContext.mUtil.loadImageNode(backgroundName);
            Pane backgroundPane = new Pane();
            backgroundPane.getChildren().add((Object)background);
            this.getChildren().add((Object)backgroundPane);
        }
        if (iconName != null) {
            Parent icon = this.mContext.mUtil.loadImageNode(iconName);
            this.mIconPane = new Pane();
            this.mIconPane.getChildren().add((Object)icon);
            HBox iconBox = new HBox();
            iconBox.setAlignment(Pos.CENTER);
            iconBox.setFillHeight(false);
            iconBox.setPrefSize(2.0 * iconCenter, height);
            iconBox.setMaxSize(2.0 * iconCenter, height);
            iconBox.getChildren().add((Object)this.mIconPane);
            this.getChildren().add((Object)iconBox);
        }
        this.mTextNode = new Text(text);
        this.mTextNode.setFill((Paint)Color.web((String)textColor, (double)1.0));
        this.mTextNode.setFont(this.mContext.mUtil.loadFont(font, fontSize));
        this.mTextNode.setWrappingWidth(Double.MAX_VALUE);
        this.mTextNode.setClip((Node)new Rectangle(this.mTextNode.getLayoutBounds().getWidth(), this.mTextNode.getLayoutBounds().getHeight()));
        TextFlow textBox = new TextFlow();
        textBox.setPrefWidth(width > textLeft + textRight ? width - textLeft - textRight : width);
        textBox.setMaxWidth(width > textLeft + textRight ? width - textLeft - textRight : width);
        textBox.setMinHeight(height);
        textBox.setPrefHeight(height);
        textBox.setMaxHeight(height);
        textBox.getChildren().add((Object)this.mTextNode);
        textBox.relocate(textLeft, 0.0);
        this.mContext.mUtil.setTextBaseline(textBox, this.mTextNode, 0.5 * height + 5.0);
        Pane textPane = new Pane();
        textPane.getChildren().add((Object)textBox);
        this.mPressedPane = new Pane();
        this.mPressedPane.setPrefSize(width, height);
        this.mPressedPane.getStyleClass().add((Object)"pressed-mask");
        this.mPressedPane.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{textPane, this.mPressedPane});
    }

    public LayoutWidgetIcon(Context context, double width, double height) {
        this.mContext = context;
        this.mIconPane = new Pane();
        HBox iconBox = new HBox();
        iconBox.setAlignment(Pos.CENTER);
        iconBox.setFillHeight(false);
        iconBox.setMinSize(width, height);
        iconBox.setPrefSize(width, height);
        iconBox.setMaxSize(width, height);
        iconBox.getChildren().add((Object)this.mIconPane);
        this.mPressedPane = new Pane();
        this.mPressedPane.setPrefSize(width, height);
        this.mPressedPane.getStyleClass().add((Object)"pressed-mask");
        this.mPressedPane.setVisible(false);
        this.setAlignment(Pos.TOP_LEFT);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.MAX_VALUE, height);
        this.getChildren().addAll((Object[])new Node[]{iconBox, this.mPressedPane});
    }

    public LayoutWidgetIcon(Context context, double width, double height, String text, URL font, double fontSize) {
        this.mContext = context;
        this.setAlignment(Pos.TOP_LEFT);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.MAX_VALUE, height);
        this.mIconPane = new Pane();
        HBox iconBox = new HBox();
        iconBox.setAlignment(Pos.CENTER);
        iconBox.setFillHeight(false);
        iconBox.setMinSize(width, height);
        iconBox.setPrefSize(width, height);
        iconBox.setMaxSize(width, height);
        iconBox.getChildren().add((Object)this.mIconPane);
        this.mTextNode = new Text(text);
        this.mTextNode.setFont(this.mContext.mUtil.loadFont(font, fontSize));
        TextFlow textBox = new TextFlow();
        textBox.setTextAlignment(TextAlignment.CENTER);
        textBox.setMinHeight(height);
        textBox.setPrefSize(width, height);
        textBox.setMaxSize(width, height);
        textBox.getChildren().add((Object)this.mTextNode);
        this.mContext.mUtil.setTextBaseline(textBox, this.mTextNode, 0.5 * height + 5.0);
        this.mPressedPane = new Pane();
        this.mPressedPane.setPrefSize(width, height);
        this.mPressedPane.getStyleClass().add((Object)"pressed-mask");
        this.mPressedPane.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{iconBox, textBox, this.mPressedPane});
    }

    public LayoutWidgetIcon(Context context, double width, double height, double iconCenter, String text, int textLeft, URL font, double fontSize) {
        this.mContext = context;
        this.setAlignment(Pos.TOP_LEFT);
        this.setPrefSize(width, height);
        this.setMaxSize(Double.MAX_VALUE, height);
        this.mIconPane = new Pane();
        HBox iconBox = new HBox();
        iconBox.setAlignment(Pos.CENTER);
        iconBox.setFillHeight(false);
        iconBox.setMinSize(2.0 * iconCenter, height);
        iconBox.setPrefSize(2.0 * iconCenter, height);
        iconBox.setMaxSize(2.0 * iconCenter, height);
        iconBox.getChildren().add((Object)this.mIconPane);
        this.mTextNode = new Text(text);
        this.mTextNode.setFont(this.mContext.mUtil.loadFont(font, fontSize));
        TextFlow textBox = new TextFlow();
        textBox.setMinHeight(height);
        textBox.setPrefHeight(height);
        textBox.setMaxHeight(height);
        textBox.getChildren().add((Object)this.mTextNode);
        textBox.relocate((double)textLeft, 0.0);
        this.mContext.mUtil.setTextBaseline(textBox, this.mTextNode, 0.5 * height + 5.0);
        Pane textPane = new Pane();
        textPane.getChildren().add((Object)textBox);
        this.mPressedPane = new Pane();
        this.mPressedPane.setPrefSize(width, height);
        this.mPressedPane.getStyleClass().add((Object)"pressed-mask");
        this.mPressedPane.setVisible(false);
        this.getChildren().addAll((Object[])new Node[]{iconBox, textPane, this.mPressedPane});
    }

    public int getIndex() {
        return this.mIndex;
    }

    public String getTint() {
        return this.mTint;
    }

    public boolean isActivated() {
        return this.mIndex != 0;
    }

    public void onPressed(boolean isPressed) {
        if (this.mIsEnabled) {
            this.mPressedPane.setVisible(isPressed);
        }
    }

    protected void onSetImage() {
        if (this.mTextNode != null) {
            this.mTextNode.setFill((Paint)Color.web((String)this.mTint, (double)1.0));
        }
        this.mIconPane.getChildren().clear();
        this.mIconPane.getChildren().add((Object)((Node)this.mImageNodes.get(this.mTint).get(this.mIndex)));
    }

    protected void onSetBackground() {
        if (this.mTextNode != null) {
            this.mTextNode.setFill((Paint)Color.web((String)this.mTint, (double)1.0));
        }
        this.mIconPane.getChildren().clear();
        this.mIconPane.getChildren().add((Object)((Node)this.mImageNodes.get(this.mTint).get(this.mIndex)));
    }

    public void setEnabled(boolean isEnabled) {
        this.mIsEnabled = isEnabled;
    }

    public void setGesture(EventHandler<MouseEvent> onClick) {
        GestureHandler gestureHandler = new GestureHandler(this.mContext, this, onClick);
        this.setOnMousePressed(gestureHandler);
        this.setOnMouseClicked(gestureHandler);
        this.setOnMouseExited(gestureHandler);
    }

    public void setGesture(EventHandler<MouseEvent> onClick, EventHandler<MouseEvent> onLongPress) {
        GestureHandlerLongPress gestureHandlerLongPress = new GestureHandlerLongPress(this.mContext, this, onClick, onLongPress);
        this.setOnMousePressed(gestureHandlerLongPress);
        this.setOnMouseClicked(gestureHandlerLongPress);
        this.setOnMouseExited(gestureHandlerLongPress);
    }

    public void setImages(Map<String, String> imageNames) {
        for (Map.Entry<String, String> imageName : imageNames.entrySet()) {
            ArrayList<Parent> arrayOfImageNodes = new ArrayList<Parent>();
            arrayOfImageNodes.add(this.mContext.mUtil.loadImageNode(imageName.getValue()));
            this.mImageNodes.put(imageName.getKey(), arrayOfImageNodes);
        }
    }

    public void setImageSets(Map<String, List<String>> imageNames) {
        for (Map.Entry<String, List<String>> arrayOfImageNames : imageNames.entrySet()) {
            ArrayList<Parent> arrayOfImageNodes = new ArrayList<Parent>();
            for (String imageName : arrayOfImageNames.getValue()) {
                arrayOfImageNodes.add(this.mContext.mUtil.loadImageNode(imageName));
            }
            this.mImageNodes.put(arrayOfImageNames.getKey(), arrayOfImageNodes);
        }
    }

    public void setBackgroundIndex(int index) {
        this.mIndex = index;
        this.onSetBackground();
    }

    public void setBackgroundTint(String tint) {
        this.mTint = tint;
        this.onSetBackground();
    }

    public void setIndex(int index) {
        this.mIndex = index;
        this.onSetImage();
    }

    public void setText(String text) {
        this.mTextNode.setText(text);
    }

    public void setTint(String tint) {
        this.mTint = tint;
        this.onSetImage();
    }
}

