/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;

public class LayoutWidgetToggleGroup
extends GridPane {
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public Context mContext;
    public Pane mPaneLeft = null;
    public Pane mPaneCenter = null;
    public Pane mPaneRight = null;
    public Text mTextBoxLeft = null;
    public Text mTextBoxCenter = null;
    public Text mTextBoxRight = null;
    public EventHandler<? super MouseEvent> mEventHandlerLeft = null;
    public EventHandler<? super MouseEvent> mEventHandlerCenter = null;
    public EventHandler<? super MouseEvent> mEventHandlerRight = null;

    public LayoutWidgetToggleGroup(Context context, int width, int height, String textLeft, String textCenter, String textRight, EventHandler<? super MouseEvent> eventHandlerLeft, EventHandler<? super MouseEvent> eventHandlerCenter, EventHandler<? super MouseEvent> eventHandlerRight) {
        this.mContext = context;
        this.mEventHandlerLeft = eventHandlerLeft;
        this.mEventHandlerCenter = eventHandlerCenter;
        this.mEventHandlerRight = eventHandlerRight;
        this.setPrefSize(width, height);
        this.getStyleClass().add((Object)"control-set");
        ColumnConstraints column = new ColumnConstraints(-1.0, -1.0, -1.0, Priority.NEVER, HPos.CENTER, false);
        RowConstraints row = new RowConstraints(-1.0, -1.0, -1.0, Priority.NEVER, VPos.TOP, false);
        Pane paneOuter = new Pane();
        paneOuter.setPrefSize((double)width, (double)height);
        paneOuter.getStyleClass().add((Object)"control-set-outer");
        GridPane.setConstraints((Node)paneOuter, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        Pane paneInner = new Pane();
        paneInner.setPrefSize(((double)width + 2.0) / 3.0, (double)height);
        paneInner.getStyleClass().add((Object)"control-set-inner");
        GridPane.setConstraints((Node)paneInner, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mPaneCenter = new Pane();
        this.mPaneCenter.setOnMouseClicked(this::onTouchCenter);
        this.mPaneCenter.setPrefSize(((double)width + 2.0) / 3.0, (double)height);
        GridPane.setConstraints((Node)this.mPaneCenter, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mPaneLeft = new Pane();
        this.mPaneLeft.setOnMouseClicked(this::onTouchLeft);
        this.mPaneLeft.setPrefSize(((double)width + 2.0) / 3.0, (double)height);
        this.mPaneLeft.setTranslateX(1.0 - ((double)width + 2.0) / 3.0);
        GridPane.setConstraints((Node)this.mPaneLeft, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mPaneRight = new Pane();
        this.mPaneRight.setOnMouseClicked(this::onTouchRight);
        this.mPaneRight.setPrefSize(((double)width + 2.0) / 3.0, (double)height);
        this.mPaneRight.setTranslateX(((double)width + 2.0) / 3.0 - 1.0);
        GridPane.setConstraints((Node)this.mPaneRight, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mTextBoxCenter = new Text(textCenter);
        this.mTextBoxCenter.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mTextBoxCenter.setOnMouseClicked(this::onTouchCenter);
        TextFlow textContainerCenter = new TextFlow();
        textContainerCenter.getChildren().add((Object)this.mTextBoxCenter);
        this.mContext.mUtil.setTextBaseline(textContainerCenter, this.mTextBoxCenter, (double)height / 2.0 + 5.0);
        GridPane.setConstraints((Node)textContainerCenter, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mTextBoxLeft = new Text(textLeft);
        this.mTextBoxLeft.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mTextBoxLeft.setOnMouseClicked(this::onTouchLeft);
        TextFlow textContainerLeft = new TextFlow();
        textContainerLeft.getChildren().add((Object)this.mTextBoxLeft);
        this.mContext.mUtil.setTextBaseline(textContainerLeft, this.mTextBoxLeft, 1.0 - ((double)width + 2.0) / 3.0, (double)height / 2.0 + 5.0);
        GridPane.setConstraints((Node)textContainerLeft, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.mTextBoxRight = new Text(textRight);
        this.mTextBoxRight.setFont(this.mContext.mUtil.loadFont(this.mContext.mFontRegular, 14.0));
        this.mTextBoxRight.setOnMouseClicked(this::onTouchRight);
        TextFlow textContainerRight = new TextFlow();
        textContainerRight.getChildren().add((Object)this.mTextBoxRight);
        this.mContext.mUtil.setTextBaseline(textContainerRight, this.mTextBoxRight, ((double)width + 2.0) / 3.0 - 1.0, (double)height / 2.0 + 5.0);
        GridPane.setConstraints((Node)textContainerRight, (int)0, (int)0, (int)1, (int)1, (HPos)HPos.CENTER, (VPos)VPos.TOP);
        this.getColumnConstraints().add((Object)column);
        this.getRowConstraints().add((Object)row);
        this.getChildren().addAll((Object[])new Node[]{paneOuter, paneInner, this.mPaneCenter, this.mPaneLeft, this.mPaneRight, textContainerCenter, textContainerLeft, textContainerRight});
        this.setSelected(0);
    }

    public void setSelected(int index) {
        this.mPaneLeft.getStyleClass().clear();
        this.mPaneCenter.getStyleClass().clear();
        this.mPaneRight.getStyleClass().clear();
        this.mTextBoxLeft.getStyleClass().clear();
        this.mTextBoxCenter.getStyleClass().clear();
        this.mTextBoxRight.getStyleClass().clear();
        switch (index) {
            default: {
                this.mPaneLeft.getStyleClass().add((Object)"control-set-left");
                this.mTextBoxLeft.getStyleClass().add((Object)"front-group");
                break;
            }
            case 1: {
                this.mPaneCenter.getStyleClass().add((Object)"control-set-center");
                this.mTextBoxCenter.getStyleClass().add((Object)"front-group");
                break;
            }
            case 2: {
                this.mPaneRight.getStyleClass().add((Object)"control-set-right");
                this.mTextBoxRight.getStyleClass().add((Object)"front-group");
            }
        }
    }

    public void onCenter() {
        this.setSelected(1);
    }

    public void onLeft() {
        this.setSelected(0);
    }

    public void onRight() {
        this.setSelected(2);
    }

    public void onTouchCenter(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.onCenter();
            }
            this.mEventHandlerCenter.handle((Event)event);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchLeft(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.onLeft();
            }
            this.mEventHandlerLeft.handle((Event)event);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void onTouchRight(MouseEvent event) {
        try {
            if (event.getEventType().equals(MouseEvent.MOUSE_CLICKED)) {
                this.onRight();
            }
            this.mEventHandlerRight.handle((Event)event);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }
}

