/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Task;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class QueuePeriodic {
    protected ArrayList<Task> mPeriodicSchedule = new ArrayList();
    protected ArrayList<Task> mTaskList = new ArrayList();
    protected ArrayList<ArrayList<ArrayList<Task>>> mGroupList = new ArrayList();
    protected int mMaxGroupSize = 0;
    protected int mNextIndex = 0;
    protected Object mLock = new Object();

    public QueuePeriodic() {
    }

    public QueuePeriodic(Task ... tasks) {
        this.addPeriodicTask(new ArrayList<Task>(Arrays.asList(tasks)));
        this.mPeriodicSchedule = this.mTaskList;
    }

    public void addPeriodicTask(Task ... tasks) {
        this.addPeriodicTask(new ArrayList<Task>(Arrays.asList(tasks)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPeriodicTask(ArrayList<Task> tasks) {
        Object object = this.mLock;
        synchronized (object) {
            ArrayList<Task> oldTaskList = this.mTaskList;
            this.mTaskList = new ArrayList();
            this.mTaskList.addAll(tasks);
            this.mTaskList.addAll(oldTaskList);
        }
        this.createSchedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createSchedule() {
        Object object = this.mLock;
        synchronized (object) {
            int groupCount = this.mGroupList.size();
            this.mPeriodicSchedule = new ArrayList();
            this.mNextIndex = 0;
            for (int passIndex = 0; passIndex < this.mMaxGroupSize; ++passIndex) {
                for (int groupIndex = 0; groupIndex < groupCount + 1; ++groupIndex) {
                    if (groupIndex < groupCount) {
                        ArrayList<ArrayList<Task>> currentGroup = this.mGroupList.get(groupIndex);
                        if (passIndex >= currentGroup.size()) continue;
                        this.mPeriodicSchedule.addAll((Collection<Task>)currentGroup.get(passIndex));
                        continue;
                    }
                    this.mPeriodicSchedule.addAll(this.mTaskList);
                }
            }
            if (this.mMaxGroupSize == 0) {
                this.mPeriodicSchedule.addAll(this.mTaskList);
            }
            int currentIndex = 0;
            for (Task task : this.mPeriodicSchedule) {
                task.mPeriodicIndex = currentIndex++;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mPeriodicSchedule = new ArrayList();
            this.mTaskList = new ArrayList();
            this.mGroupList = new ArrayList();
            this.mMaxGroupSize = 0;
            this.mNextIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task head() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNextIndex >= this.mPeriodicSchedule.size()) {
                this.mNextIndex = 0;
            }
            return this.mPeriodicSchedule.isEmpty() ? null : this.mPeriodicSchedule.get(this.mNextIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task next() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mNextIndex >= this.mPeriodicSchedule.size()) {
                this.mNextIndex = 0;
            }
            return this.mPeriodicSchedule.isEmpty() ? null : this.mPeriodicSchedule.get(this.mNextIndex++);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mPeriodicSchedule.size();
        }
    }
}

