/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.SortableComponent;
import com.elinchrom.software.SortedCollectionComparator;
import com.elinchrom.software.SortedDeviceItem;
import java.util.ArrayList;
import java.util.TreeSet;

public class SortedCollection<SortedDeviceType extends SortableComponent<SortedDeviceType>>
extends TreeSet<SortedDeviceItem<SortedDeviceType>> {
    public Context mContext = null;
    public boolean mIsSortedManually = false;

    public SortedCollection(Context context, boolean isSortedManually) {
        super(new SortedCollectionComparator(context, isSortedManually));
        this.mContext = context;
        this.mIsSortedManually = isSortedManually;
    }

    public void add(SortedDeviceType elinchromDevice, int orderManual) {
        this.add(new SortedDeviceItem<SortedDeviceType>(elinchromDevice, orderManual));
    }

    public void addAll(ArrayList<SortedDeviceType> components) {
        for (SortableComponent component : components) {
            String skyportId = component.getElinchromDevice().getSkyportId();
            int orderManual = this.mContext.mManuallySortedFlashUnitMap.containsKey(skyportId) ? this.mContext.mManuallySortedFlashUnitMap.get(skyportId) : 0;
            this.add(new SortedDeviceItem<SortableComponent>(component, orderManual));
        }
    }

    @Override
    public boolean contains(SortedDeviceType elinchromDevice) {
        boolean result = false;
        for (SortedDeviceItem sortedDeviceItem : this) {
            if (!sortedDeviceItem.mSortedDevice.equals(elinchromDevice)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public boolean remove(SortedDeviceType elinchromDevice) {
        return super.remove(new SortedDeviceItem<SortedDeviceType>(elinchromDevice, 0));
    }
}

