/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.SortableComponent;
import com.elinchrom.software.SortedDeviceItem;
import java.util.Comparator;

public class SortedCollectionComparator<SortedDeviceType extends SortableComponent<SortedDeviceType>>
implements Comparator<SortedDeviceItem<SortedDeviceType>> {
    public Context mContext;
    public boolean mIsSortedManually;

    public SortedCollectionComparator(Context Context2, boolean isSortedManually) {
        this.mContext = Context2;
        this.mIsSortedManually = isSortedManually;
    }

    @Override
    public int compare(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        try {
            return this.mIsSortedManually ? this.compareManually(sortableBridge1, sortableBridge2) : this.compareAutomatically(sortableBridge1, sortableBridge2);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
            return 0;
        }
    }

    public int compareAutomatically(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        ElinchromDevice elinchromDevice1 = sortableBridge1.getElinchromDevice();
        ElinchromDevice elinchromDevice2 = sortableBridge2.getElinchromDevice();
        if (elinchromDevice1.mComponentLighting == null && elinchromDevice2.mComponentLighting == null) {
            return this.compareAutomaticallyProducts(sortableBridge1, sortableBridge2);
        }
        if (elinchromDevice1.mComponentLighting == null) {
            return -1;
        }
        if (elinchromDevice2.mComponentLighting == null) {
            return 1;
        }
        return this.compareAutomaticallyGroup(sortableBridge1, sortableBridge2);
    }

    public int compareAutomaticallyFriendlyName(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        ElinchromDevice elinchromDevice1 = sortableBridge1.getElinchromDevice();
        ElinchromDevice elinchromDevice2 = sortableBridge2.getElinchromDevice();
        int result = this.mContext.mUtil.convertUtf8BytesToString(elinchromDevice1.mComponentLighting.getFriendly_name()).compareTo(this.mContext.mUtil.convertUtf8BytesToString(elinchromDevice2.mComponentLighting.getFriendly_name()));
        return result != 0 ? result : this.compareAutomaticallyProducts(sortableBridge1, sortableBridge2);
    }

    public int compareAutomaticallyGroup(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        ElinchromDevice elinchromDevice1 = sortableBridge1.getElinchromDevice();
        ElinchromDevice elinchromDevice2 = sortableBridge2.getElinchromDevice();
        int result = Integer.valueOf(elinchromDevice1.mComponentLighting.getGroup()).compareTo(Integer.valueOf(elinchromDevice2.mComponentLighting.getGroup()));
        return result != 0 ? result : this.compareAutomaticallyFriendlyName(sortableBridge1, sortableBridge2);
    }

    public int compareAutomaticallyProducts(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        ElinchromDevice elinchromDevice1 = sortableBridge1.getElinchromDevice();
        ElinchromDevice elinchromDevice2 = sortableBridge2.getElinchromDevice();
        int result = Integer.valueOf(elinchromDevice2.getProductId()).compareTo(elinchromDevice1.getProductId());
        return result != 0 ? result : this.compareAutomaticallySkyportId(sortableBridge1, sortableBridge2);
    }

    public int compareAutomaticallySkyportId(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        ElinchromDevice elinchromDevice1 = sortableBridge1.getElinchromDevice();
        ElinchromDevice elinchromDevice2 = sortableBridge2.getElinchromDevice();
        int result = Long.valueOf(elinchromDevice1.valueGetLong(41)).compareTo(elinchromDevice2.valueGetLong(41));
        return result != 0 ? result : this.compareAutomaticallySortedDevice(sortableBridge1, sortableBridge2);
    }

    public int compareAutomaticallySortedDevice(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        return sortableBridge1.mSortedDevice.compareTo(sortableBridge2.mSortedDevice);
    }

    public int compareManually(SortedDeviceItem<SortedDeviceType> sortableBridge1, SortedDeviceItem<SortedDeviceType> sortableBridge2) {
        int result = Integer.valueOf(sortableBridge1.mOrderManual).compareTo(sortableBridge2.mOrderManual);
        return result != 0 ? result : this.compareAutomatically(sortableBridge1, sortableBridge2);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof SortedCollectionComparator;
    }
}

