/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.DataServiceRequest;
import com.elinchrom.software.ElinchromDevice;
import com.elinchrom.software.FileType;
import com.elinchrom.software.FirmwareOnline;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.FlashDeviceCompact;
import com.elinchrom.software.FlashDeviceContinuousLight;
import com.elinchrom.software.FlashDeviceFullyAsymmetric;
import com.elinchrom.software.FlashDeviceMultipleRatios;
import com.elinchrom.software.FlashDevicePowerPack;
import com.elinchrom.software.FlashDeviceSingleRatio;
import com.elinchrom.software.JsonNewsFirmware;
import com.elinchrom.software.LayoutWidgetIcon;
import com.elinchrom.software.Scene;
import com.elinchrom.software.SortedDeviceItem;
import com.elinchrom.software.TaskInit;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.scene.Parent;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.scene.text.TextFlow;
import javafx.stage.Stage;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import org.girod.javafx.svgimage.SVGLoader;

public class Util {
    public Context mContext;
    protected final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public Util(Context context) {
        this.mContext = context;
    }

    public <T> T[] arrayAppend(T[] itemArray, T item) throws NegativeArraySizeException {
        itemArray = Arrays.copyOf(itemArray, itemArray.length + 1);
        itemArray[itemArray.length - 1] = item;
        return itemArray;
    }

    public int[] arrayAppendUnsignedOrdered(int[] itemArray, int item) throws NegativeArraySizeException {
        int[] result;
        if (this.arrayContains(itemArray, item)) {
            result = itemArray;
        } else {
            int index;
            result = new int[itemArray.length + 1];
            for (index = 0; index < itemArray.length && ((long)itemArray[index] & 0xFFFFFFFFL) < ((long)item & 0xFFFFFFFFL); ++index) {
                result[index] = itemArray[index];
            }
            result[index] = item;
            while (index < itemArray.length) {
                result[index + 1] = itemArray[index];
                ++index;
            }
        }
        return result;
    }

    public boolean arrayContains(int[] itemArray, int item) {
        int index;
        for (index = 0; index < itemArray.length && itemArray[index] != item; ++index) {
        }
        return index < itemArray.length;
    }

    public String byteArrayToHexString(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = this.HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = this.HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public long byteArrayToLongMSBFirst(byte[] byteArray) {
        long longValue = 0L;
        for (int i = 0; byteArray != null && byteArray.length > i && i < 8; ++i) {
            longValue += (long)(byteArray[byteArray.length - i - 1] & 0xFF) << 8 * i;
        }
        return longValue;
    }

    public String checkFriendlyName(String friendlyNameString, int maxNameLength) {
        byte[] friendlyNameBytes;
        while ((friendlyNameBytes = friendlyNameString.getBytes(StandardCharsets.UTF_8)) != null && friendlyNameBytes.length > maxNameLength) {
            friendlyNameString = friendlyNameString.substring(0, friendlyNameString.length() - 1);
        }
        return friendlyNameString;
    }

    public byte[] cleanBytes(byte[] string) {
        if (string == null) {
            string = new byte[]{};
        }
        int trimmedLength = string.length;
        byte[] result = null;
        try {
            for (int index = string.length - 1; index >= 0; --index) {
                if (string[index] == 0 || string[index] == -1) {
                    if (result == null) {
                        --trimmedLength;
                        continue;
                    }
                    result[index] = 32;
                    continue;
                }
                if (result != null) continue;
                result = Arrays.copyOfRange(string, 0, trimmedLength);
            }
        }
        catch (Exception exception) {
            result = new byte[]{};
        }
        return result != null ? result : new byte[]{};
    }

    public double convert_in_fstop(double joule) {
        double fstop = Math.log(joule) / Math.log(2.0) - 2.7288187;
        return fstop *= 10.0;
    }

    public double convert_in_joule(double fstop) {
        if (fstop == 0.0) {
            return 0.0;
        }
        double energy = Math.pow(2.0, (fstop /= 10.0) + 2.7288187);
        energy = energy < 100.0 ? Math.floor(10.0 * energy) / 10.0 : Math.floor(energy);
        return energy;
    }

    public byte[] convertIntToByteArrayMSBFirst(int number) {
        return new byte[]{(byte)((number & 0xFF000000) >>> 24), (byte)((number & 0xFF0000) >>> 16), (byte)((number & 0xFF00) >>> 8), (byte)(number & 0xFF)};
    }

    public String convertPowerToDottedValue(int value) {
        char[] flash_power = Integer.toString(value).toCharArray();
        if (flash_power.length == 1) {
            return "0." + flash_power[0];
        }
        return flash_power[0] + "." + flash_power[1];
    }

    public byte[] convertStringToUtf8Bytes(String string) {
        return string.getBytes(StandardCharsets.UTF_8);
    }

    public String convertUtf8BytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public byte[] convertHexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = null;
        if ((len & 1) == 0) {
            data = new byte[len / 2];
            for (int i = 0; i < len; i += 2) {
                data[i / 2] = (byte)(Character.digit(s.charAt(i), 16) << 4 | Character.digit(s.charAt(i + 1), 16));
            }
        }
        return data;
    }

    private String decrypt(byte[] input) {
        String result = "";
        try {
            String modeString = "SAVE";
            char[] mode = new char[modeString.length()];
            modeString.getChars(0, modeString.length(), mode, 0);
            byte[] data = new byte[16];
            this.mContext.mModuleManagerApp.ElModuleManagerSdkAddProduct(0L, -463990653, -816902474, 16, data, 0);
            SecretKeySpec key = new SecretKeySpec(data, "" + mode[1] + mode[3] + mode[0]);
            Cipher cipher = Cipher.getInstance("" + mode[1] + mode[3] + mode[0]);
            cipher.init(2, key);
            result = this.convertUtf8BytesToString(cipher.doFinal(input));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public int dipsToPixels(int dips) {
        return dips;
    }

    private String encrypt(String plaintext) {
        Object encodedText = "";
        byte[] plainBytes = plaintext.getBytes(StandardCharsets.UTF_8);
        try {
            String modeString = "SAVER";
            char[] mode = new char[modeString.length()];
            modeString.getChars(0, modeString.length(), mode, 0);
            byte[] data = new byte[294];
            this.mContext.mModuleManagerApp.ElModuleManagerSdkAddProduct(0L, 138212594, -296860286, 294, data, 0);
            KeyFactory keyFactory = KeyFactory.getInstance("" + mode[4] + mode[0] + mode[1]);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(data);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance("" + mode[4] + mode[0] + mode[1] + "/ECB/OAEPPadding");
            cipher.init(1, (Key)publicKey, OAEPParameterSpec.DEFAULT);
            for (int i = 0; i < plaintext.length(); i += 214) {
                byte[] cipherText = cipher.doFinal(Arrays.copyOfRange(plainBytes, i, Math.min(i + 214, plaintext.length())));
                encodedText = (String)encodedText + this.byteArrayToHexString(cipherText);
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return encodedText;
    }

    public static Alert factoryAlert(Alert.AlertType type, String title, String header, String content, String buttonOk, String buttonCancel) {
        Image appIcon = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("images/app_logo.png"));
        ButtonType buttonTypeOk = buttonOk == null ? null : new ButtonType(buttonOk, ButtonBar.ButtonData.OK_DONE);
        ButtonType buttonTypeCancel = buttonCancel == null ? null : new ButtonType(buttonCancel, ButtonBar.ButtonData.CANCEL_CLOSE);
        Alert alert = null;
        alert = buttonTypeOk != null && buttonTypeCancel != null ? new Alert(type, "", new ButtonType[]{buttonTypeOk, buttonTypeCancel}) : (buttonTypeOk != null ? new Alert(type, "", new ButtonType[]{buttonTypeOk}) : new Alert(type, "", new ButtonType[0]));
        alert.setHeaderText(null);
        ((Stage)alert.getDialogPane().getScene().getWindow()).getIcons().add((Object)appIcon);
        alert.setTitle(title);
        alert.setContentText(header + "\n\n" + content + "\n\n");
        return alert;
    }

    public String fstopToJouleString(double fstop) {
        Object result = "0.0";
        if (fstop != 0.0) {
            double energy = Math.pow(2.0, (fstop /= 10.0) + 2.7288187);
            if (energy < 100.0) {
                energy = (double)Math.round(10.0 * energy) / 10.0;
                result = "" + energy;
            } else {
                energy = Math.round(energy);
                result = "" + (int)energy;
            }
        }
        return (String)result + "Ws";
    }

    public LayoutWidgetIcon factoryButton(int width, int height, String backgroundName, String iconName, double iconCenter, String text, int textLeft, URL font, double fontSize, String tint) {
        LayoutWidgetIcon layoutWidgetIcon = new LayoutWidgetIcon(this.mContext, width, height, backgroundName, iconName, iconCenter, text, textLeft, font, fontSize, tint);
        return layoutWidgetIcon;
    }

    public LayoutWidgetIcon factoryButton(int width, int height, Map<String, String> imageNames, String text, URL font, double fontSize, String defaultTint) {
        LayoutWidgetIcon layoutWidgetIcon = new LayoutWidgetIcon(this.mContext, (double)width, height, text, font, fontSize);
        layoutWidgetIcon.setImages(imageNames);
        layoutWidgetIcon.setBackgroundTint(defaultTint);
        return layoutWidgetIcon;
    }

    public LayoutWidgetIcon factoryButtonTintable(int width, int height, Map<String, String> imageNames, double imageCenter, String text, int textLeft, URL font, double fontSize, String defaultTint) {
        LayoutWidgetIcon layoutWidgetIcon = new LayoutWidgetIcon(this.mContext, (double)width, (double)height, imageCenter, text, textLeft, font, fontSize);
        layoutWidgetIcon.setImages(imageNames);
        layoutWidgetIcon.setTint(defaultTint);
        return layoutWidgetIcon;
    }

    public LayoutWidgetIcon factoryButtonSet(int width, int height, Map<String, List<String>> imageNames, double imageCenter, String text, int textLeft, URL font, double fontSize, String defaultTint, int defaultIndex) {
        LayoutWidgetIcon layoutWidgetIcon = new LayoutWidgetIcon(this.mContext, (double)width, (double)height, imageCenter, text, textLeft, font, fontSize);
        layoutWidgetIcon.setImageSets(imageNames);
        layoutWidgetIcon.setTint(defaultTint);
        layoutWidgetIcon.setIndex(defaultIndex);
        return layoutWidgetIcon;
    }

    public LayoutWidgetIcon factoryIconSet(int width, int height, List<String> imageNames, int defaultIndex) {
        LayoutWidgetIcon layoutWidgetIcon = new LayoutWidgetIcon(this.mContext, width, height);
        HashMap<String, List<String>> imageMap = new HashMap<String, List<String>>();
        imageMap.put("", imageNames);
        layoutWidgetIcon.setImageSets(imageMap);
        layoutWidgetIcon.setTint("");
        layoutWidgetIcon.setIndex(defaultIndex);
        return layoutWidgetIcon;
    }

    public FlashDevice factoryFlashUnit(ElinchromDevice elinchromDevice) {
        FlashDevice flashUnit = null;
        switch (elinchromDevice.valueGetByte(32) & 0xFF) {
            case 1: {
                flashUnit = new FlashDeviceCompact(this.mContext, elinchromDevice);
                break;
            }
            case 2: {
                flashUnit = new FlashDeviceSingleRatio(this.mContext, elinchromDevice);
                break;
            }
            case 3: {
                flashUnit = new FlashDeviceMultipleRatios(this.mContext, elinchromDevice);
                break;
            }
            case 5: {
                flashUnit = new FlashDeviceFullyAsymmetric(this.mContext, elinchromDevice);
                break;
            }
            case 4: {
                flashUnit = new FlashDeviceContinuousLight(this.mContext, elinchromDevice);
                break;
            }
            case 7: {
                flashUnit = new FlashDevicePowerPack(this.mContext, elinchromDevice);
                break;
            }
        }
        return flashUnit;
    }

    public String factorySharingRequest() {
        byte[] bytes = new byte[8];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(bytes);
        DataServiceRequest dataServiceRequest = new DataServiceRequest();
        dataServiceRequest.reservation_id = this.byteArrayToHexString(bytes);
        dataServiceRequest.agree = 1;
        String jsonString = this.mContext.mGson.toJson(dataServiceRequest);
        return "service_version=2&data=" + this.encrypt(jsonString);
    }

    public String factorySharingRequest(String install_id, int agree) {
        DataServiceRequest dataServiceRequest = new DataServiceRequest();
        dataServiceRequest.install_id = install_id;
        dataServiceRequest.agree = agree;
        String jsonString = this.mContext.mGson.toJson(dataServiceRequest);
        return "service_version=2&data=" + this.encrypt(jsonString);
    }

    public String factorySharingSoftwareRequest(String install_id, int os, String osVersion, int software, String softwareVersion) {
        DataServiceRequest dataServiceRequest = new DataServiceRequest();
        dataServiceRequest.install_id = install_id;
        dataServiceRequest.os = os;
        dataServiceRequest.os_version = osVersion;
        dataServiceRequest.software = software;
        dataServiceRequest.software_version = softwareVersion;
        dataServiceRequest.refresh_mode = this.mContext.mRefreshMode;
        String jsonString = this.mContext.mGson.toJson(dataServiceRequest);
        return "service_version=2&data=" + this.encrypt(jsonString);
    }

    public String factorySharingUnitRequest(String install_id, FlashDevice flashDevice) {
        int skyport_channel = 0;
        try {
            skyport_channel = this.mContext.mStoredPreferences.lastUsedSkyportChannel;
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        DataServiceRequest dataServiceRequest = new DataServiceRequest();
        dataServiceRequest.install_id = install_id;
        dataServiceRequest.refresh_mode = this.mContext.mModuleManagerSdk.valueGetByte(46);
        dataServiceRequest.skyport_id = flashDevice.mElinchromDevice.getSkyportId();
        dataServiceRequest.product_id = flashDevice.mElinchromDevice.getProductId();
        dataServiceRequest.firmware_version = flashDevice.mElinchromDevice.getFirmwareVersion();
        dataServiceRequest.flash_count = flashDevice.getFlash_counter();
        dataServiceRequest.power_fstop_total = flashDevice.getFlash_power();
        dataServiceRequest.skyport_group = flashDevice.hasData(5) ? flashDevice.getGroup() : (byte)0;
        dataServiceRequest.skyport_channel = skyport_channel;
        dataServiceRequest.audio = this.byteArrayToHexString(flashDevice.readNative(0));
        dataServiceRequest.charge_mode = this.byteArrayToHexString(flashDevice.readNative(1));
        dataServiceRequest.flash_mode = this.byteArrayToHexString(flashDevice.readNative(2));
        dataServiceRequest.flash_fstop = this.byteArrayToHexString(flashDevice.getFlash_power_values());
        dataServiceRequest.head_status = this.byteArrayToHexString(flashDevice.readNative(6));
        dataServiceRequest.lamp_fstop = this.byteArrayToHexString(flashDevice.getLamp_power_fstop_values());
        dataServiceRequest.lamp_percent = this.byteArrayToHexString(flashDevice.readNative(8));
        dataServiceRequest.lamp_mode = this.byteArrayToHexString(flashDevice.readNative(9));
        dataServiceRequest.photocell_status = this.byteArrayToHexString(flashDevice.readNative(10));
        dataServiceRequest.power_ctrl = this.byteArrayToHexString(flashDevice.readNative(11));
        dataServiceRequest.auto_off = this.byteArrayToHexString(flashDevice.readNative(14));
        String jsonString = this.mContext.mGson.toJson(dataServiceRequest);
        return "service_version=2&data=" + this.encrypt(jsonString);
    }

    public FirmwareOnline findLatestFirmware(int productId) {
        FirmwareOnline latestFirmware = null;
        for (FirmwareOnline firmwareOnline : this.mContext.mNewestFirmwares) {
            String[] allProductIds = firmwareOnline.getFamilyID().split(",");
            if (!Arrays.asList(allProductIds).contains(Integer.toString(productId))) continue;
            if (latestFirmware == null) {
                latestFirmware = firmwareOnline;
                continue;
            }
            firmwareOnline.mBootloaderMajor[1] = latestFirmware.mBootloaderMajor[0];
            firmwareOnline.mBootloaderMinor[1] = latestFirmware.mBootloaderMinor[0];
            firmwareOnline.mFirmwareMajor[1] = latestFirmware.mFirmwareMajor[0];
            firmwareOnline.mFirmwareMinor[1] = latestFirmware.mFirmwareMinor[0];
            latestFirmware = firmwareOnline;
            break;
        }
        return latestFirmware;
    }

    public String findSceneNameSuggestion() {
        int index;
        for (index = 1; new Scene(this.mContext, "Scene " + index).exists() && index < Integer.MAX_VALUE; ++index) {
        }
        return "Scene " + index;
    }

    public String getApplicationDirectory() {
        Object appDirectory = null;
        try {
            File jarFile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            File jarDirectory = new File(jarFile.getParent());
            appDirectory = this.isWindows() ? jarDirectory.getParent() : jarDirectory.getParentFile().getParentFile().getParent();
            appDirectory = (String)appDirectory + System.getProperty("file.separator");
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return appDirectory;
    }

    public String getJson(FileType fileType) throws IOException {
        byte[] contentBytes = fileType.getAllBytes();
        String json_data = this.decrypt(contentBytes);
        return json_data;
    }

    public String getLatestFirmwareVersion(JsonNewsFirmware jsonNewsFirmware) {
        Object latestFirmwareVersion = "";
        if (jsonNewsFirmware.firmwares.length > 1) {
            latestFirmwareVersion = (String)latestFirmwareVersion + (int)(jsonNewsFirmware.firmwares[0].firmware_version * 10.0f);
            latestFirmwareVersion = (String)latestFirmwareVersion + ".";
            latestFirmwareVersion = (String)latestFirmwareVersion + (int)(jsonNewsFirmware.firmwares[1].firmware_version * 10.0f);
        } else if (jsonNewsFirmware.firmwares.length > 0) {
            latestFirmwareVersion = (String)latestFirmwareVersion + jsonNewsFirmware.firmwares[0].firmware_version;
        }
        return latestFirmwareVersion;
    }

    public int getOsCode() {
        if (this.isWindows()) {
            return 4;
        }
        return 3;
    }

    public String getOsVersionString() {
        return System.getProperty("os.version");
    }

    public String getUserApplicationDataDirectory() {
        String dataDirectory = this.isWindows() ? System.getenv("AppData") + "\\" : System.getProperty("user.home") + "/Library/Application Support/";
        return dataDirectory + "Elinchrom Studio" + System.getProperty("file.separator");
    }

    public int hasNewFirmware(int productId, int board0Major, int board0Minor) {
        return this.hasNewFirmware(productId, board0Major, board0Minor, 0, 0);
    }

    public int hasNewFirmware(int productId, int board0Major, int board0Minor, int board1Major, int board1Minor) {
        int hasNewFirmware = 0;
        FirmwareOnline firmwareOnline = this.findLatestFirmware(productId);
        if (this.mContext.mIsInternetAvailable && firmwareOnline != null) {
            hasNewFirmware = 2;
            if (firmwareOnline.mFirmwareMajor[0] > board0Major || firmwareOnline.mFirmwareMajor[0] == board0Major && firmwareOnline.mFirmwareMinor[0] > board0Minor) {
                hasNewFirmware = 1;
            }
            if (firmwareOnline.mFirmwareMajor[1] > board1Major || firmwareOnline.mFirmwareMajor[1] == board1Major && firmwareOnline.mFirmwareMinor[1] > board1Minor) {
                hasNewFirmware = 1;
            }
        }
        return hasNewFirmware;
    }

    public void initSharing() {
        try {
            if (this.mContext.mStoredPreferences.installId.isEmpty() && this.mContext.mStoredPreferences.shareData == 0) {
                this.mContext.mStoredPreferences.needRefreshSharing = 0;
                this.mContext.mFileManager.writePreferencesFile(this.mContext.mStoredPreferences);
            }
            if (this.mContext.mStoredPreferences.needRefreshSharing == 1) {
                String request = this.mContext.mStoredPreferences.installId.isEmpty() && this.mContext.mStoredPreferences.shareData == 1 ? this.factorySharingRequest() : this.factorySharingRequest(this.mContext.mStoredPreferences.installId, this.mContext.mStoredPreferences.shareData);
                this.mContext.mOpThreadCore.enqueueMediumPriorityTask(new TaskInit(this.mContext, 29, new String[]{request}));
            } else {
                this.initSharingSoftware();
            }
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
    }

    public void initSharingSoftware() {
        if (this.mContext.mStoredPreferences.shareData == 1 && !this.mContext.mStoredPreferences.installId.isEmpty()) {
            String request = this.factorySharingSoftwareRequest(this.mContext.mStoredPreferences.installId, this.getOsCode(), this.getOsVersionString(), 3, "2.0.1317");
            this.mContext.mOpThreadCore.enqueueMediumPriorityTask(new TaskInit(this.mContext, 31, new String[]{request}));
        }
    }

    public byte[] intToBytes(int x) {
        byte[] bytes = new byte[4];
        int i = 0;
        while (x != 0) {
            bytes[i] = (byte)(x & 0xFF);
            ++i;
            x >>>= 8;
        }
        return bytes;
    }

    public boolean isAndroid() {
        return System.getProperty("java.vendor").toLowerCase().contains("android");
    }

    public boolean isInternetAvailable() {
        boolean result = false;
        try {
            URL url = new URL("https://services.elinchrom.com");
            HttpsURLConnection urlConnect = (HttpsURLConnection)url.openConnection();
            Object objData = urlConnect.getContent();
            result = true;
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
        return result;
    }

    public boolean isLowerThan(String leftSemanticVersion, String rightSemanticVersion) {
        return this.semanticVersionToLong(leftSemanticVersion) < this.semanticVersionToLong(rightSemanticVersion);
    }

    public boolean isMacOs(String version) {
        return System.getProperty("os.name").equals("Mac OS X") && (System.getProperty("os.version").equals(version) || System.getProperty("os.version").startsWith(version + "."));
    }

    public boolean isMacOsBigSur() {
        return this.isMacOs("10.16") || this.isMacOs("11");
    }

    public boolean isMacOsCatalina() {
        return this.isMacOs("10.15");
    }

    public boolean isMacOsMonterey() {
        return this.isMacOs("10.17") || this.isMacOs("12");
    }

    public boolean isMacOsSonoma() {
        return this.isMacOs("10.19") || this.isMacOs("14");
    }

    public boolean isMacOsVentura() {
        return this.isMacOs("10.18") || this.isMacOs("13");
    }

    public boolean isNothingSelected() {
        boolean nothingSelected = true;
        for (SortedDeviceItem sortedDeviceItem : this.mContext.mSortedLightingDevices) {
            if ((1 << sortedDeviceItem.getElinchromDevice().mComponentLighting.getGroup() & this.mContext.mGroupSelected) == 0) continue;
            nothingSelected &= !sortedDeviceItem.getElinchromDevice().mComponentLighting.getLayoutViewUnit().mIsSelected;
        }
        return nothingSelected;
    }

    public boolean isOk(Alert.AlertType type, String title, String header, String content) {
        return this.isOk(type, title, header, content, null, null);
    }

    public boolean isOk(Alert.AlertType type, String title, String header, String content, String buttonOk) {
        return this.isOk(type, title, header, content, buttonOk, null);
    }

    public boolean isOk(Alert.AlertType type, String title, String header, String content, String buttonOk, String buttonCancel) {
        Alert alert = Util.factoryAlert(type, title, header, content, buttonOk, buttonCancel);
        Optional result = alert.showAndWait();
        return result.isPresent() && ((ButtonType)result.get()).getButtonData() == ButtonBar.ButtonData.OK_DONE;
    }

    public boolean isWindows() {
        return System.getProperty("os.name").indexOf("Windows ") == 0;
    }

    public Font loadFont(URL urlFont, double sizeFont) {
        return Font.loadFont((String)urlFont.toString(), (double)sizeFont);
    }

    public Parent loadImageNode(String imageName) {
        return this.loadImageNode(Thread.currentThread().getContextClassLoader().getResource("images/" + imageName));
    }

    public Parent loadImageNode(URL imageUrl) {
        return SVGLoader.load(imageUrl);
    }

    public int mimeTypeToFileFormat(String mimeType) {
        int result = 0;
        if (mimeType != null) {
            if (mimeType.contains("png")) {
                result = 1;
            } else if (mimeType.contains("jpeg")) {
                result = 2;
            } else if (mimeType.contains("tiff")) {
                result = 3;
            }
        }
        return result;
    }

    public void openWebpage(URL url) {
        try {
            URI uri = url.toURI();
            this.mContext.mAppMain.getHostServices().showDocument(uri.toString());
        }
        catch (URISyntaxException uriSyntaxException) {
            this.mContext.mLogger.printStackTrace(uriSyntaxException);
        }
    }

    public void openWebpageFeedback() {
        try {
            URL url = new URL("mailto:support@elinchrom.ch?subject=Elinchrom%20Studio%202.0");
            this.openWebpage(url);
        }
        catch (MalformedURLException malformedUrlException) {
            this.mContext.mLogger.printStackTrace(malformedUrlException);
        }
    }

    public void openWebpagePrivacy() {
        try {
            URL url = new URL("https://www.elinchrom.com/privacy-policy/");
            this.openWebpage(url);
        }
        catch (MalformedURLException malformedUrlException) {
            this.mContext.mLogger.printStackTrace(malformedUrlException);
        }
    }

    public int pixelsToDips(int pixels) {
        return pixels;
    }

    public int scaleX(float pixels) {
        return (int)pixels;
    }

    public int scaleY(float pixels) {
        return (int)pixels;
    }

    public long semanticVersionToLong(String semanticVersion) {
        long version = 0L;
        String[] versionElements = semanticVersion.split("\\.");
        if (versionElements.length > 0) {
            try {
                version |= (long)((Integer.parseInt(versionElements[0]) & 0xFF) << 24);
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (versionElements.length > 1) {
            try {
                version |= (long)((Integer.parseInt(versionElements[1]) & 0xFF) << 16);
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (versionElements.length > 2) {
            try {
                version |= (long)((Integer.parseInt(versionElements[2]) & 0xFFFF) << 0);
            }
            catch (Exception exception) {
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return version;
    }

    public void setTextBaseline(TextFlow textContainer, Text textNode, double baseline) {
        textContainer.setTranslateY(baseline - textNode.getBaselineOffset());
    }

    public void setTextBaseline(TextFlow textContainer, Text textNode, double left, double baseline) {
        textContainer.setTranslateX(left);
        textContainer.setTranslateY(baseline - textNode.getBaselineOffset());
    }

    public void setTextBaselineAndSpacing(TextFlow textContainer, Text textNode, double baseline, double lineSpacing) {
        textContainer.setTranslateY(baseline - textNode.getBaselineOffset());
        textContainer.setLineSpacing(lineSpacing - textNode.getFont().getSize() * 1.25);
    }

    public void setTextBaselineAndSpacing(TextFlow textContainer, Text textNode, double left, double baseline, double lineSpacing) {
        textContainer.setTranslateX(left);
        textContainer.setTranslateY(baseline - textNode.getBaselineOffset());
        textContainer.setLineSpacing(lineSpacing - textNode.getFont().getSize() * 1.25);
    }

    public void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int tryFindUniqueProductIdFromSkyportId(String skyportId) {
        boolean isUnique = true;
        int firstProductId = 0;
        byte[] skyportIdArray = this.convertHexStringToByteArray(skyportId);
        if (skyportIdArray != null && skyportIdArray.length > 0) {
            byte familyId = skyportIdArray[0];
            for (Unit_Prototype_Json unitPrototype : this.mContext.mUnitPrototypes.values()) {
                if (unitPrototype.Family_id != (familyId & 0xFF)) continue;
                if (firstProductId == 0) {
                    firstProductId = unitPrototype.Product_id;
                    continue;
                }
                isUnique = false;
                break;
            }
        }
        return isUnique ? firstProductId : 0;
    }

    protected String tryGetLocalFile(String fileName, String defaultUrl) {
        String fileUrl = defaultUrl;
        try {
            File localFile = new File(this.mContext.mFolderDebug + System.getProperty("file.separator") + fileName);
            if (localFile.canRead()) {
                fileUrl = localFile.toURI().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fileUrl;
    }

    public int valueToPercent(float value, float maxValue) {
        return maxValue == 0.0f ? 0 : (int)(value / maxValue * 100.0f);
    }

    public String valueToPercentString(float value, float maxValue) {
        return this.valueToPercent(value, maxValue) + "%";
    }
}

