/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.ApplicationFileChooser;
import com.elinchrom.software.ApplicationFileResult;
import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfScene;
import com.elinchrom.software.LayoutViewUpdateListItem;
import java.io.File;
import javafx.application.Platform;
import javafx.embed.swing.SwingNode;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileNameExtensionFilter;

public class ApplicationFileChooserSwing
extends ApplicationFileChooser {
    public JFileChooser mJFileChooser = null;
    public Stage mStage = null;
    public SwingNode mSwingNode = null;

    public ApplicationFileChooserSwing(Context context) {
        super(context);
    }

    @Override
    public void addFilter(String description, boolean isDefault, String ... extensions) {
        FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter(description, extensions);
        this.mJFileChooser.addChoosableFileFilter(fileNameExtensionFilter);
        if (isDefault) {
            this.mJFileChooser.setFileFilter(fileNameExtensionFilter);
        }
    }

    @Override
    public void close() {
        while (this.mSwingNode.getContent() == null) {
            this.mContext.mUtil.sleep(20L);
        }
        this.mStage.hide();
    }

    @Override
    public void enable() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        this.init("Elinchrom Studio", null, "", false, StageStyle.UNDECORATED, 0.0);
        this.showOpenDialog((file, elConfScene, layoutViewUpdateListItem) -> {}, null, null);
    }

    @Override
    public void init(String title, File initialDirectory, String initialFileName, boolean showAllFiles, StageStyle stageStyle, double opacity) {
        Image appIcon = new Image(Thread.currentThread().getContextClassLoader().getResourceAsStream("images/app_logo.png"));
        this.mSwingNode = new SwingNode();
        BorderPane pane = new BorderPane();
        pane.setCenter((Node)this.mSwingNode);
        Scene scene = new Scene((Parent)pane);
        this.mStage = new Stage(stageStyle);
        this.mStage.setTitle(title);
        this.mStage.setScene(scene);
        this.mStage.setOpacity(opacity);
        this.mStage.getIcons().add((Object)appIcon);
        this.mJFileChooser = new JFileChooser(initialDirectory);
        this.mJFileChooser.setAcceptAllFileFilterUsed(showAllFiles);
        this.mJFileChooser.setFileSelectionMode(0);
        this.mJFileChooser.setSelectedFile(new File(initialFileName));
    }

    public void showDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mJFileChooser.addActionListener(actionEvent -> Platform.runLater(() -> {
            try {
                if ("ApproveSelection".equals(actionEvent.getActionCommand())) {
                    File[] fileArray;
                    if (this.mJFileChooser.isMultiSelectionEnabled()) {
                        fileArray = this.mJFileChooser.getSelectedFiles();
                    } else {
                        File[] fileArray2 = new File[1];
                        fileArray = fileArray2;
                        fileArray2[0] = this.mJFileChooser.getSelectedFile();
                    }
                    for (File selectedFile : fileArray) {
                        applicationFileResult.choose(selectedFile, elConfScene, layoutViewUpdateListItem);
                    }
                } else {
                    applicationFileResult.choose(null, elConfScene, layoutViewUpdateListItem);
                }
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
            try {
                this.mStage.hide();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }));
        SwingUtilities.invokeLater(() -> this.mSwingNode.setContent((JComponent)this.mJFileChooser));
        this.mStage.setOnCloseRequest(windowEvent -> {
            try {
                applicationFileResult.choose(null, elConfScene, layoutViewUpdateListItem);
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        });
        this.mStage.show();
        while (this.mSwingNode.getContent() == null) {
            this.mContext.mUtil.sleep(20L);
        }
        Platform.runLater(() -> {
            this.mContext.mUtil.sleep(100L);
            Platform.runLater(() -> {
                this.mContext.mUtil.sleep(100L);
                Platform.runLater(() -> {
                    this.mContext.mUtil.sleep(100L);
                    Platform.runLater(() -> {
                        this.mContext.mUtil.sleep(100L);
                        Platform.runLater(() -> {
                            this.mContext.mUtil.sleep(100L);
                            Platform.runLater(() -> {
                                this.mContext.mUtil.sleep(100L);
                                Platform.runLater(() -> {
                                    this.mContext.mUtil.sleep(100L);
                                    Platform.runLater(() -> {
                                        this.mContext.mUtil.sleep(100L);
                                        Platform.runLater(() -> {
                                            this.mContext.mUtil.sleep(100L);
                                            Platform.runLater(() -> {
                                                this.mContext.mUtil.sleep(100L);
                                                Platform.runLater(() -> {
                                                    this.mStage.setX(this.mStage.getX() + 1.0);
                                                    this.mStage.setY(this.mStage.getY() + 1.0);
                                                });
                                            });
                                        });
                                    });
                                });
                            });
                        });
                    });
                });
            });
        });
    }

    @Override
    public void showOpenDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mJFileChooser.setMultiSelectionEnabled(false);
        this.showDialog(applicationFileResult, elConfScene, layoutViewUpdateListItem);
    }

    @Override
    public void showOpenMultipleDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mJFileChooser.setMultiSelectionEnabled(true);
        this.showDialog(applicationFileResult, elConfScene, layoutViewUpdateListItem);
    }

    @Override
    public void showSaveDialog(ApplicationFileResult applicationFileResult, ElConfScene elConfScene, LayoutViewUpdateListItem layoutViewUpdateListItem) {
        this.mJFileChooser.setMultiSelectionEnabled(false);
        this.showDialog(applicationFileResult, elConfScene, layoutViewUpdateListItem);
    }
}

