/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.BridgeDeviceBle;
import com.elinchrom.software.BridgeDeviceUsb;
import com.elinchrom.software.ComponentUpdatable;
import com.elinchrom.software.Context;
import com.elinchrom.software.FlashDevice;
import com.elinchrom.software.SortableComponent;
import com.elinchrom.software.Task;
import com.elinchrom.software.TaskInsert;
import com.elinchrom.software.Unit_Prototype_Json;
import java.io.File;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;

public class ElinchromDevice
implements SortableComponent<ElinchromDevice> {
    public Context mContext = null;
    public long mDeviceId = 0L;
    public long mDeviceSdk = 0L;
    ComponentUpdatable mComponentUpdatable = null;
    BridgeDeviceUsb mComponentBridgeUsb = null;
    BridgeDeviceBle mComponentBridgeBle = null;
    FlashDevice mComponentLighting = null;
    public int mProductId = 0;
    public String mSkyportId = null;
    public String mProductName = null;
    public String Image_URL = null;
    public String mSkyportIdString = null;
    public String mSkyportHexaId = null;
    public String mSkyportIntegerId = null;
    public Task mRefreshTask = null;
    public Instant mSignalCheckTimeUsb = null;
    public Instant mSignalCheckTimeBle = null;
    public Instant mSignalCheckTimeSkyport = null;

    public ElinchromDevice(Context context, long deviceId, long deviceSdk) {
        this.mContext = context;
        this.mDeviceId = deviceId;
        this.mDeviceSdk = deviceSdk;
        this.mRefreshTask = new TaskInsert(this.mContext, 9, 0L, 0L, this.mDeviceId);
        this.mProductId = (int)this.valueGetLong(29);
        byte[] data = this.valueGet(41);
        this.mSkyportId = this.mContext.mUtil.byteArrayToHexString(new byte[]{data[2], data[1], data[0]});
        Unit_Prototype_Json unit_prototype = this.mContext.mUnitPrototypes.get(this.mProductId);
        this.mProductName = unit_prototype.getModel_full_name();
        this.Image_URL = unit_prototype.getImage_URL();
        this.mSignalCheckTimeUsb = Instant.now().minus(Duration.ofSeconds(10L));
        this.mSignalCheckTimeBle = Instant.now().minus(Duration.ofSeconds(10L));
        this.mSignalCheckTimeSkyport = Instant.now().minus(Duration.ofSeconds(10L));
    }

    @Override
    public int compareTo(ElinchromDevice other) {
        return Long.valueOf(this.mDeviceId).compareTo(other.mDeviceId);
    }

    public boolean equals(Object other) {
        return other instanceof ElinchromDevice && this.mDeviceId == ((ElinchromDevice)other).mDeviceId;
    }

    public void free() {
        if (this.mComponentUpdatable != null) {
            this.mComponentUpdatable.mElinchromDevice = null;
        }
        if (this.mComponentBridgeUsb != null) {
            this.mComponentBridgeUsb.mElinchromDevice = null;
        }
        if (this.mComponentBridgeBle != null) {
            this.mComponentBridgeBle.mElinchromDevice = null;
        }
        if (this.mComponentLighting != null) {
            if (this.mComponentLighting.mLayoutViewUnit != null) {
                this.mComponentLighting.mLayoutViewUnit.mElinchromDevice = null;
            }
            this.mComponentLighting.mElinchromDevice = null;
        }
    }

    public int getConnectionType() {
        return 3;
    }

    @Override
    public ElinchromDevice getElinchromDevice() {
        return this;
    }

    public String getFirmwareFileName1() {
        return "firmware-" + this.mProductName.toLowerCase().replace("-", "_").replace(" ", "_") + (this.mComponentUpdatable.mNumberOfBoards > 1 ? "-master-" : "-") + this.getFirmwareVersionBoard1() + ".elx";
    }

    public String getFirmwareFileName2() {
        return "firmware-" + this.mProductName.toLowerCase().replace("-", "_").replace(" ", "_") + "-slave-" + this.getFirmwareVersionBoard2() + ".elx";
    }

    public String getFriendlyName() {
        if (this.mComponentLighting != null && this.mComponentLighting.hasData(4)) {
            return this.mContext.mUtil.convertUtf8BytesToString(this.mContext.mUtil.cleanBytes(this.mComponentLighting.getFriendly_name()));
        }
        return this.mProductName;
    }

    public URL getImageUrl() {
        URL url = null;
        try {
            url = new File(this.mContext.mFolderImages + this.Image_URL).toURI().toURL();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        return url;
    }

    public int getProductId() {
        return this.mProductId;
    }

    public String getProductName() {
        return this.mProductName;
    }

    public String getFirmwareVersion() {
        return this.mComponentUpdatable.mNumberOfBoards > 1 ? this.getFirmwareVersion2Boards() : this.getFirmwareVersionBoard1();
    }

    public String getFirmwareVersionBoard1() {
        byte[] valueBoard0 = this.valueGet(43);
        return valueBoard0[2] + "." + valueBoard0[1];
    }

    public String getFirmwareVersionBoard2() {
        byte[] valueBoard1 = this.valueGet(44);
        return valueBoard1[2] + "." + valueBoard1[1];
    }

    public String getFirmwareVersion2Boards() {
        byte[] valueBoard0 = this.valueGet(43);
        byte[] valueBoard1 = this.valueGet(44);
        return "" + valueBoard0[2] + valueBoard0[1] + "." + valueBoard1[2] + valueBoard1[1];
    }

    public Task getRefreshTask() {
        return this.mRefreshTask;
    }

    public String getSkyportId() {
        return this.mSkyportId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isDetectedOnChannel() {
        return this.valueGetByte(59) == 1 || this.valueGetByte(57) == 1 && this.valueGetByte(66) != 0 && this.valueGetByte(66) == this.mContext.mModuleManagerSdk.valueGetByte(38);
    }

    public boolean isFirmwareInfoAvailable() {
        return this.valueGetByte(56) == 1 || this.isDetectedOnChannel() || this.isSelectedBridgeByBle();
    }

    public boolean isFirmwareVersionLatest() {
        return this.getFirmwareVersion().equals(this.mComponentUpdatable.mFirmwareVersionLatest);
    }

    public boolean isLightingUnitInNormalMode() {
        return (this.valueGetByte(54) != 1 || this.valueGetByte(55) != 1) && this.valueGetByte(60) == 1;
    }

    public boolean isPeriodicRefreshEnabled() {
        return this.isDetectedOnChannel() && this.isLightingUnitInNormalMode();
    }

    public boolean isSelectedBridgeByBle() {
        return this.mContext.mBridgeDevice != null && this.mContext.mBridgeDevice.mElinchromDevice.mDeviceId == this.mDeviceId && this.valueGetByte(62) == 2;
    }

    public boolean isSelectedBridgeByUsb() {
        return this.mContext.mBridgeDevice != null && this.mContext.mBridgeDevice.mElinchromDevice.mDeviceId == this.mDeviceId && this.valueGetByte(62) == 1;
    }

    public boolean isRefreshByBleEnabled() {
        return this.isSelectedBridgeByBle() && !this.isPeriodicRefreshEnabled();
    }

    public boolean isRefreshByUsbEnabled() {
        return this.valueGetByte(56) == 1 && (this.valueGetByte(52) == 3 && this.valueGetByte(60) == 1 || this.valueGetByte(61) == 1);
    }

    public boolean isRefreshUpdateSignalBySkyportEnabled() {
        return this.valueGetByte(59) == 1 && this.valueGetByte(61) == 3 && this.valueGetByte(60) != 1;
    }

    public boolean isRefreshUpdateSignalByUsbEnabled() {
        return this.valueGetByte(56) == 1 && this.valueGetByte(61) == 1 && !this.isRefreshByUsbEnabled();
    }

    public byte[] valueGet(int deviceIndex) {
        return this.mContext.mModuleManagerSdk.valueGet(this, deviceIndex);
    }

    public byte valueGetByte(int valueIndex) {
        return this.mContext.mModuleManagerSdk.valueGetByte(this, valueIndex);
    }

    public long valueGetLong(int valueIndex) {
        return this.mContext.mModuleManagerSdk.valueGetLong(this, valueIndex);
    }

    public void valueSet(int valueIndex, byte[] value) {
        this.mContext.mModuleManagerSdk.valueSet(this, valueIndex, value);
    }

    public void valueSetByte(int valueIndex, byte value) {
        this.mContext.mModuleManagerSdk.valueSetByte(this, valueIndex, value);
    }
}

