/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.ElConfImage;
import com.elinchrom.software.FileDocument;
import com.elinchrom.software.FileTypeAsset;
import com.elinchrom.software.FileTypePrivate;
import com.elinchrom.software.FileTypeUrl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import javafx.scene.image.Image;

public class FileDocumentPicture
extends FileDocument {
    public String mFileName = null;
    public String mMimeType = null;

    public FileDocumentPicture(Context context) {
        super(context);
    }

    public FileDocumentPicture fromElConfImage(ElConfImage elConfImage) {
        this.setFileType(new FileTypePrivate(this.mContext, this.mContext.mFolderScenes + "id0x" + this.mContext.mUtil.byteArrayToHexString(this.mContext.mUtil.convertIntToByteArrayMSBFirst(elConfImage.id)) + ".elconf"));
        return this;
    }

    public FileDocumentPicture fromLocalFolder(String fileName) {
        this.setFileType(new FileTypePrivate(this.mContext, fileName));
        return this;
    }

    public FileDocumentPicture fromResources(String fileName) {
        this.setFileType(new FileTypeAsset(this.mContext, fileName));
        this.mFileName = fileName;
        return this;
    }

    public FileDocumentPicture fromUrl(String sourceUrlPath, String fileName) {
        this.setFileType(new FileTypeUrl(this.mContext, sourceUrlPath, fileName));
        this.mFileName = fileName;
        return this;
    }

    public Image getImage() {
        Image image = null;
        if (this.getFile() != null) {
            try {
                URL url = this.getFile().toURI().toURL();
                image = new Image(url.toString());
            }
            catch (MalformedURLException malformedURLException) {
                this.mContext.mLogger.printStackTrace(malformedURLException);
            }
            try {
                this.mMimeType = Files.probeContentType(this.getFile().getAbsoluteFile().toPath());
            }
            catch (IOException ioException) {
                this.mContext.mLogger.printStackTrace(ioException);
            }
        }
        return image;
    }

    @Override
    public boolean tryValidate() {
        return this.mFileType.isValid();
    }
}

