/*
 * Decompiled with CFR 0.152.
 */
package com.elinchrom.software;

import com.elinchrom.software.Context;
import com.elinchrom.software.StoredPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class FileManager {
    public Context mContext;

    public FileManager(Context context) {
        this.mContext = context;
    }

    protected StoredPreferences getDefaultPreferences() {
        return new StoredPreferences();
    }

    public void initFolders() {
        File folder = null;
        try {
            folder = new File(this.mContext.mFolderDebug);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderUserApplicationData);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderConfig);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderImages);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderPreferences);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderScenes);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            folder = new File(this.mContext.mFolderTemporary);
            if (!folder.exists()) {
                folder.mkdir();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
    }

    public void initCheckedNameFlashUnits() {
        File local_units_file = new File(this.mContext.mFolderPreferences + "checked_name_units.txt");
        String firstLine = null;
        try {
            if (!local_units_file.exists()) {
                local_units_file.createNewFile();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(local_units_file)));
            firstLine = br.readLine();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        String[] checkedNameFlashUnitArray = firstLine == null ? new String[]{} : firstLine.split(";");
        this.mContext.mCheckedNameFlashUnitArray = new ArrayList<String>(Arrays.asList(checkedNameFlashUnitArray));
    }

    public void initManuallySortedUnits() {
        File local_units_file = new File(this.mContext.mFolderPreferences + "manually_sorted_units.txt");
        String firstLine = null;
        try {
            if (!local_units_file.exists()) {
                local_units_file.createNewFile();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(local_units_file)));
            firstLine = br.readLine();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        String[] storedFlashUnitArray = firstLine == null ? new String[]{} : firstLine.split(";");
        int position = 0;
        for (String storedFlashUnit : storedFlashUnitArray) {
            this.mContext.mManuallySortedFlashUnitMap.put(storedFlashUnit, position++);
        }
    }

    public void initPreferencesFile() {
        StoredPreferences storedPreferences;
        File localPreferencesFile = new File(this.mContext.mFolderPreferences + "local_preferences.json");
        boolean isLocalPreferencesFileExisting = false;
        BufferedWriter bw = null;
        try {
            isLocalPreferencesFileExisting = localPreferencesFile.exists();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        if (!isLocalPreferencesFileExisting) {
            try {
                localPreferencesFile.createNewFile();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
            try {
                String defaultPreferences = this.mContext.mGson.toJson(this.getDefaultPreferences());
                bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(localPreferencesFile), "UTF-8"));
                bw.write(defaultPreferences);
                bw.newLine();
                bw.flush();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        this.mContext.mStoredPreferences = (storedPreferences = this.readPreferencesFile()) == null ? this.getDefaultPreferences() : storedPreferences;
    }

    protected StoredPreferences readPreferencesFile() {
        File localPreferencesFile = new File(this.mContext.mFolderPreferences + "local_preferences.json");
        StoredPreferences storedPreferences = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(localPreferencesFile);
            byte[] jsonData = new byte[(int)localPreferencesFile.length()];
            inputStream.read(jsonData);
            String jsonString = new String(jsonData, "UTF-8");
            storedPreferences = this.mContext.mGson.fromJson(jsonString, StoredPreferences.class);
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
        return storedPreferences;
    }

    public String sendToService(String request) {
        String result = "";
        try {
            if (this.mContext.mIsInternetAvailable) {
                byte[] postData = request.getBytes(StandardCharsets.UTF_8);
                int postDataLength = postData.length;
                URL url = new URL("https://services.elinchrom.com/data.php");
                HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
                connection.setDoOutput(true);
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                connection.setRequestProperty("charset", "utf-8");
                connection.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                connection.setUseCaches(false);
                DataOutputStream connectionOutputStream = new DataOutputStream(connection.getOutputStream());
                connectionOutputStream.write(postData);
                connectionOutputStream.flush();
                connectionOutputStream.close();
                if (connection.getResponseCode() == 200) {
                    String jsonLine;
                    Object jsonString = "";
                    BufferedReader connectionInputStream = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((jsonLine = connectionInputStream.readLine()) != null) {
                        jsonString = (String)jsonString + jsonLine;
                    }
                    result = jsonString;
                    this.mContext.mLogger.log("Sent to data service: " + this.mContext.mUtil.byteArrayToHexString(postData));
                    this.mContext.mLogger.log("JSON response: " + (String)jsonString);
                } else {
                    this.mContext.mLogger.printStackTrace("Https response code was: " + connection.getResponseCode());
                }
            }
        }
        catch (Throwable throwable) {
            this.mContext.mLogger.printStackTrace(throwable);
        }
        return result;
    }

    public void updateCheckedNameFlashUnits() {
        File local_units_file = new File(this.mContext.mFolderPreferences + "checked_name_units.txt");
        BufferedWriter bw = null;
        try {
            if (!local_units_file.exists()) {
                local_units_file.createNewFile();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(local_units_file)));
            bw.write(String.join((CharSequence)";", this.mContext.mCheckedNameFlashUnitArray.toArray(new String[0])));
            bw.newLine();
            bw.flush();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }

    public void updateManuallySortedUnits() {
        File local_units_file = new File(this.mContext.mFolderPreferences + "manually_sorted_units.txt");
        BufferedWriter bw = null;
        CharSequence[] storedFlashUnitArray = new String[this.mContext.mManuallySortedFlashUnitMap.size()];
        for (Map.Entry<String, Integer> storedEntry : this.mContext.mManuallySortedFlashUnitMap.entrySet()) {
            storedFlashUnitArray[storedEntry.getValue().intValue()] = storedEntry.getKey();
        }
        try {
            if (!local_units_file.exists()) {
                local_units_file.createNewFile();
            }
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        try {
            bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(local_units_file)));
            bw.write(String.join((CharSequence)";", storedFlashUnitArray));
            bw.newLine();
            bw.flush();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }

    public void writePreferencesFile(StoredPreferences storedPreferences) {
        BufferedWriter bw = null;
        try {
            File localPreferencesFile = new File(this.mContext.mFolderPreferences + "local_preferences.json");
            String preferencesString = this.mContext.mGson.toJson(storedPreferences);
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(localPreferencesFile), "UTF-8"));
            bw.write(preferencesString);
            bw.newLine();
            bw.flush();
        }
        catch (Throwable t) {
            this.mContext.mLogger.printStackTrace(t);
        }
        if (bw != null) {
            try {
                bw.close();
            }
            catch (Throwable t) {
                this.mContext.mLogger.printStackTrace(t);
            }
        }
    }
}

